/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.sonar.java.resolve.Scope;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.java.resolve.Types;

public class Resolve {
    private final SymbolNotFound symbolNotFound = new SymbolNotFound();
    private final Types types = new Types();

    private Symbol findField(Env env, Symbol.TypeSymbol site, String name, Symbol.TypeSymbol c) {
        Symbol symbol;
        Symbol bestSoFar = this.symbolNotFound;
        for (Symbol symbol2 : c.members().lookup(name)) {
            if (symbol2.kind != 4) continue;
            return this.isAccessible(env, site, symbol2) ? symbol2 : new AccessErrorSymbol(symbol2);
        }
        if (c.getSuperclass() != null) {
            symbol = this.findField(env, site, name, c.getSuperclass().symbol);
            if (symbol.kind < bestSoFar.kind) {
                bestSoFar = symbol;
            }
        }
        for (Type interfaceType : c.getInterfaces()) {
            symbol = this.findField(env, site, name, interfaceType.symbol);
            if (symbol.kind >= bestSoFar.kind) continue;
            bestSoFar = symbol;
        }
        return bestSoFar;
    }

    private Symbol findVar(Env env, String name) {
        Symbol bestSoFar = this.symbolNotFound;
        Env env1 = env;
        while (env1.outer() != null) {
            Symbol sym = null;
            for (Symbol symbol : env1.scope().lookup(name)) {
                if (symbol.kind != 4) continue;
                sym = symbol;
            }
            if (sym == null) {
                sym = this.findField(env1, env1.enclosingClass(), name, env1.enclosingClass());
            }
            if (sym.kind < 64) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
            env1 = env1.outer();
        }
        return bestSoFar;
    }

    public Symbol findMemberType(Env env, Symbol.TypeSymbol site, String name, Symbol.TypeSymbol c) {
        Symbol bestSoFar = this.symbolNotFound;
        for (Symbol symbol : c.members().lookup(name)) {
            if (symbol.kind != 2) continue;
            return this.isAccessible(env, site, symbol) ? symbol : new AccessErrorSymbol(symbol);
        }
        if (c.getSuperclass() != null) {
            Symbol symbol = this.findMemberType(env, site, name, c.getSuperclass().symbol);
            if (symbol.kind < bestSoFar.kind) {
                bestSoFar = symbol;
            }
        }
        for (Type interfaceType : c.getInterfaces()) {
            Symbol symbol = this.findMemberType(env, site, name, interfaceType.symbol);
            if (symbol.kind >= bestSoFar.kind) continue;
            bestSoFar = symbol;
        }
        return bestSoFar;
    }

    private Symbol findType(Env env, String name) {
        Symbol bestSoFar = this.symbolNotFound;
        Env env1 = env;
        while (env1.outer() != null) {
            for (Symbol symbol : env1.scope().lookup(name)) {
                if (symbol.kind != 2) continue;
                return symbol;
            }
            Symbol symbol = this.findMemberType(env1, env1.enclosingClass(), name, env1.enclosingClass());
            if (symbol.kind < 64) {
                return symbol;
            }
            if (symbol.kind < bestSoFar.kind) {
                bestSoFar = symbol;
            }
            env1 = env1.outer();
        }
        for (Symbol symbol : env.packge().members.lookup(name)) {
            if (symbol.kind >= bestSoFar.kind) continue;
            bestSoFar = symbol;
        }
        return bestSoFar;
    }

    public Symbol findIdent(Env env, String name, int kind) {
        Symbol symbol;
        Symbol bestSoFar = this.symbolNotFound;
        if ((kind & 4) != 0) {
            symbol = this.findVar(env, name);
            if (symbol.kind < 64) {
                return symbol;
            }
            if (symbol.kind < bestSoFar.kind) {
                bestSoFar = symbol;
            }
        }
        if ((kind & 2) != 0) {
            symbol = this.findType(env, name);
            if (symbol.kind < 64) {
                return symbol;
            }
            if (symbol.kind < bestSoFar.kind) {
                bestSoFar = symbol;
            }
        }
        if ((kind & 1) != 0) {
            // empty if block
        }
        return bestSoFar;
    }

    public Symbol findIdentInPackage(Env env, Symbol site, String name, int kind) {
        return this.symbolNotFound;
    }

    public Symbol findIdentInType(Env env, Symbol.TypeSymbol site, String name, int kind) {
        Symbol symbol;
        Symbol bestSoFar = this.symbolNotFound;
        if ((kind & 4) != 0) {
            symbol = this.findField(env, site, name, site);
            if (symbol.kind < 64) {
                return symbol;
            }
            if (symbol.kind < bestSoFar.kind) {
                bestSoFar = symbol;
            }
        }
        if ((kind & 2) != 0) {
            symbol = this.findMemberType(env, site, name, site);
            if (symbol.kind < 64) {
                return symbol;
            }
            if (symbol.kind < bestSoFar.kind) {
                bestSoFar = symbol;
            }
        }
        return bestSoFar;
    }

    public Symbol findMethod(Env env, String name, List<Type> argTypes) {
        Symbol bestSoFar = this.symbolNotFound;
        Env env1 = env;
        while (env1.outer() != null) {
            Symbol sym = this.findMethod(env1, env1.enclosingClass(), name, argTypes);
            if (sym.kind < 64) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
            env1 = env1.outer;
        }
        return bestSoFar;
    }

    public Symbol findMethod(Env env, Symbol.TypeSymbol site, String name, List<Type> argTypes) {
        Symbol bestSoFar = this.symbolNotFound;
        for (Symbol symbol : site.members().lookup(name)) {
            if (symbol.kind != 16) continue;
            bestSoFar = this.selectBest(env, site, argTypes, symbol, bestSoFar);
        }
        if (bestSoFar.kind < 64) {
            return bestSoFar;
        }
        for (Symbol symbol : site.enclosingClass().members().lookup(name)) {
            if (symbol.kind != 16 || !this.isAccessible(env, site, symbol)) continue;
            if (bestSoFar.kind < 64) {
                return new AmbiguityErrorSymbol();
            }
            bestSoFar = symbol;
        }
        return bestSoFar;
    }

    private Symbol selectBest(Env env, Symbol.TypeSymbol site, List<Type> argTypes, Symbol symbol, Symbol bestSoFar) {
        if (!this.isInheritedIn(symbol, site)) {
            return bestSoFar;
        }
        if (symbol.type == null) {
            return bestSoFar;
        }
        if (!this.isArgumentsAcceptable(argTypes, ((Type.MethodType)symbol.type).argTypes)) {
            return bestSoFar;
        }
        if (!this.isAccessible(env, site, symbol)) {
            return new AccessErrorSymbol(symbol);
        }
        return this.selectMostSpecific(symbol, bestSoFar);
    }

    private boolean isArgumentsAcceptable(List<Type> argTypes, List<Type> formals) {
        if (argTypes.size() != formals.size()) {
            return false;
        }
        for (int i = 0; i < argTypes.size(); ++i) {
            if (this.types.isSubtype(argTypes.get(i), formals.get(i))) continue;
            return false;
        }
        return true;
    }

    private Symbol selectMostSpecific(Symbol m1, Symbol m2) {
        if (m2.type == null) {
            return m1;
        }
        boolean m1SignatureMoreSpecific = this.isSignatureMoreSpecific(m1, m2);
        boolean m2SignatureMoreSpecific = this.isSignatureMoreSpecific(m2, m1);
        if (m1SignatureMoreSpecific && m2SignatureMoreSpecific) {
            return new AmbiguityErrorSymbol();
        }
        if (m1SignatureMoreSpecific) {
            return m1;
        }
        if (m2SignatureMoreSpecific) {
            return m2;
        }
        return new AmbiguityErrorSymbol();
    }

    private boolean isSignatureMoreSpecific(Symbol m1, Symbol m2) {
        return this.isArgumentsAcceptable(((Type.MethodType)m1.type).argTypes, ((Type.MethodType)m2.type).argTypes);
    }

    @VisibleForTesting
    boolean isAccessible(Env env, Symbol.TypeSymbol c) {
        boolean result;
        switch (c.flags() & 7) {
            case 2: {
                result = env.enclosingClass().outermostClass() == c.owner().outermostClass();
                break;
            }
            case 0: {
                result = env.packge() == c.packge();
                break;
            }
            case 1: {
                result = true;
                break;
            }
            case 4: {
                result = env.packge() == c.packge() || this.isInnerSubClass(env.enclosingClass(), c.owner());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return result;
    }

    private boolean isInnerSubClass(Symbol.TypeSymbol c, Symbol base) {
        while (c != null && this.isSubClass(c, base)) {
            c = c.owner().enclosingClass();
        }
        return c != null;
    }

    @VisibleForTesting
    boolean isSubClass(Symbol.TypeSymbol c, Symbol base) {
        if (c == null) {
            return false;
        }
        if (c == base) {
            return true;
        }
        if ((base.flags() & 0x200) != 0) {
            for (Type interfaceType : c.getInterfaces()) {
                if (!this.isSubClass(interfaceType.symbol, base)) continue;
                return true;
            }
            return this.isSubClass(Resolve.superclassSymbol(c), base);
        }
        return this.isSubClass(Resolve.superclassSymbol(c), base);
    }

    private boolean isAccessible(Env env, Symbol.TypeSymbol site, Symbol symbol) {
        switch (symbol.flags() & 7) {
            case 2: {
                return env.enclosingClass().outermostClass() == symbol.owner().outermostClass() && this.isInheritedIn(symbol, site);
            }
            case 0: {
                return env.packge() == symbol.packge() && this.isAccessible(env, site) && this.isInheritedIn(symbol, site) && this.notOverriddenIn(site, symbol);
            }
            case 1: {
                return this.isAccessible(env, site) && this.notOverriddenIn(site, symbol);
            }
            case 4: {
                return (env.packge() == symbol.packge() || this.isProtectedAccessible(symbol, env.enclosingClass, site)) && this.isAccessible(env, site) && this.notOverriddenIn(site, symbol);
            }
        }
        throw new IllegalStateException();
    }

    private boolean notOverriddenIn(Symbol.TypeSymbol site, Symbol symbol) {
        return true;
    }

    @VisibleForTesting
    boolean isInheritedIn(Symbol symbol, Symbol.TypeSymbol clazz) {
        switch (symbol.flags() & 7) {
            case 1: {
                return true;
            }
            case 2: {
                return symbol.owner() == clazz;
            }
            case 4: {
                return true;
            }
            case 0: {
                Symbol.PackageSymbol thisPackage = symbol.packge();
                Symbol.TypeSymbol sup = clazz;
                while (sup != null && sup != symbol.owner()) {
                    if (sup.packge() != thisPackage) {
                        return false;
                    }
                    sup = Resolve.superclassSymbol(sup);
                }
                return true;
            }
        }
        throw new IllegalStateException();
    }

    private boolean isProtectedAccessible(Symbol symbol, Symbol.TypeSymbol c, Symbol.TypeSymbol site) {
        return true;
    }

    private static Symbol.TypeSymbol superclassSymbol(Symbol.TypeSymbol c) {
        Type supertype = c.getSuperclass();
        return supertype == null ? null : supertype.symbol;
    }

    public static class AccessErrorSymbol
    extends Symbol {
        Symbol symbol;

        public AccessErrorSymbol(Symbol symbol) {
            super(64, 0, null, null);
            this.symbol = symbol;
        }
    }

    public static class AmbiguityErrorSymbol
    extends Symbol {
        public AmbiguityErrorSymbol() {
            super(65, 0, null, null);
        }
    }

    public static class SymbolNotFound
    extends Symbol {
        public SymbolNotFound() {
            super(66, 0, null, null);
        }
    }

    static class Env {
        Env next;
        Env outer;
        Symbol.PackageSymbol packge;
        Symbol.TypeSymbol enclosingClass;
        Scope scope;

        Env() {
        }

        Env outer() {
            return this.outer;
        }

        Symbol.TypeSymbol enclosingClass() {
            return this.enclosingClass;
        }

        public Symbol.PackageSymbol packge() {
            return this.packge;
        }

        Scope scope() {
            return this.scope;
        }

        public Env dup() {
            Env env = new Env();
            env.next = this;
            env.outer = this.outer;
            env.packge = this.packge;
            env.enclosingClass = this.enclosingClass;
            env.scope = this.scope;
            return env;
        }
    }
}

