/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.java.resolve.Symbol;

public class Scope {
    final Symbol owner;
    final Scope next;
    private ArrayListMultimap<String, Symbol> symbols = ArrayListMultimap.create();

    public Scope(Symbol owner) {
        this.owner = owner;
        this.next = null;
    }

    public Scope(Scope next) {
        this.owner = next.owner;
        this.next = next;
    }

    public void enter(Symbol symbol) {
        this.symbols.put((Object)symbol.name, (Object)symbol);
    }

    public List<Symbol> lookup(String name) {
        Scope scope = this;
        while (scope != null && !scope.symbols.containsKey((Object)name)) {
            scope = scope.next;
        }
        return scope == null ? ImmutableList.of() : scope.symbols.get((Object)name);
    }
}

