/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressReport
implements Runnable {
    private final long period;
    private final Logger logger;
    private String message = "";
    private final Thread thread;
    private String stopMessage = "";

    public ProgressReport(String threadName, long period, Logger logger) {
        this.period = period;
        this.logger = logger;
        this.thread = new Thread(this);
        this.thread.setName(threadName);
    }

    public ProgressReport(String threadName, long period) {
        this(threadName, period, LoggerFactory.getLogger(ProgressReport.class));
    }

    @Override
    public void run() {
        while (!Thread.interrupted()) {
            try {
                Thread.sleep(this.period);
                this.logger.info(this.message);
            }
            catch (InterruptedException e) {
                this.thread.interrupt();
            }
        }
        this.logger.info(this.stopMessage);
    }

    public void start(String startMessage) {
        this.logger.info(startMessage);
        this.thread.start();
    }

    public void message(String message) {
        this.message = message;
    }

    public void stop(String stopMessage) {
        this.stopMessage = stopMessage;
        this.thread.interrupt();
    }
}

