/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.google.common.base.Preconditions;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaMetric;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.ast.visitors.JavaAstVisitor;
import org.sonar.java.ast.visitors.MethodHelper;
import org.sonar.squidbridge.api.SourceMethod;
import org.sonar.squidbridge.measures.Metric;
import org.sonar.squidbridge.measures.MetricDef;

public class AccessorVisitor
extends JavaAstVisitor {
    public void init() {
        MethodHelper.subscribe(this);
    }

    public void visitNode(AstNode astNode) {
        MethodHelper methodHelper;
        SourceMethod sourceMethod = (SourceMethod)this.getContext().peekSourceCode();
        if (astNode.is(new AstNodeType[]{JavaGrammar.METHOD_DECLARATOR_REST, JavaGrammar.VOID_METHOD_DECLARATOR_REST}) && (methodHelper = new MethodHelper(astNode)).isPublic() && this.isAccessor(methodHelper)) {
            sourceMethod.setMeasure((MetricDef)Metric.ACCESSORS, 1);
        }
    }

    public void leaveNode(AstNode astNode) {
        SourceMethod sourceMethod = (SourceMethod)this.getContext().peekSourceCode();
        if (sourceMethod.isAccessor()) {
            sourceMethod.setMeasure((MetricDef)Metric.PUBLIC_API, 0);
            sourceMethod.setMeasure((MetricDef)Metric.PUBLIC_DOC_API, 0);
            sourceMethod.setMeasure((MetricDef)JavaMetric.METHODS, 0);
            sourceMethod.setMeasure((MetricDef)JavaMetric.COMPLEXITY, 0);
        }
    }

    private boolean isAccessor(MethodHelper method) {
        return this.isValidGetter(method) || this.isValidSetter(method) || this.isValidBooleanGetter(method);
    }

    private boolean isValidGetter(MethodHelper method) {
        List<AstNode> statements;
        String methodName = method.getName().getTokenValue();
        if (methodName.startsWith("get") && !method.hasParameters() && !method.getReturnType().is(new AstNodeType[]{JavaKeyword.VOID}) && (statements = method.getStatements()).size() == 1) {
            AstNode blockStatement = statements.get(0);
            Preconditions.checkState((boolean)blockStatement.is(new AstNodeType[]{JavaGrammar.BLOCK_STATEMENT}));
            return this.inspectGetterMethodBody(blockStatement.getFirstChild().getFirstChild());
        }
        return false;
    }

    private boolean isValidSetter(MethodHelper method) {
        List<AstNode> statements;
        String methodName = method.getName().getTokenValue();
        if (methodName.startsWith("set") && method.getParameters().size() == 1 && method.getReturnType().is(new AstNodeType[]{JavaKeyword.VOID}) && (statements = method.getStatements()).size() == 1) {
            AstNode blockStatement = statements.get(0);
            Preconditions.checkState((boolean)blockStatement.is(new AstNodeType[]{JavaGrammar.BLOCK_STATEMENT}));
            return this.inspectSetterMethodBody(blockStatement.getFirstChild().getFirstChild());
        }
        return false;
    }

    private boolean inspectSetterMethodBody(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{JavaGrammar.EXPRESSION_STATEMENT})) {
            AstNode expression = astNode.getFirstChild(new AstNodeType[]{JavaGrammar.STATEMENT_EXPRESSION}).getFirstChild(new AstNodeType[]{JavaGrammar.EXPRESSION});
            AstNode assignmentExpression = expression.getFirstChild();
            if (assignmentExpression.is(new AstNodeType[]{JavaGrammar.ASSIGNMENT_EXPRESSION})) {
                AstNode varToAssign = assignmentExpression.getFirstDescendant(new AstNodeType[]{JavaTokenType.IDENTIFIER});
                return this.findPrivateClassVariable(varToAssign);
            }
        }
        return false;
    }

    private boolean isValidBooleanGetter(MethodHelper method) {
        List<AstNode> statements;
        String methodName = method.getName().getTokenValue();
        if (methodName.startsWith("is") && !method.hasParameters() && this.hasBooleanReturnType(method) && (statements = method.getStatements()).size() == 1) {
            AstNode blockStatement = statements.get(0);
            Preconditions.checkState((boolean)blockStatement.is(new AstNodeType[]{JavaGrammar.BLOCK_STATEMENT}));
            return this.inspectGetterMethodBody(blockStatement.getFirstChild().getFirstChild());
        }
        return false;
    }

    private boolean inspectGetterMethodBody(AstNode astNode) {
        AstNode varReturned;
        AstNode qualifiedIdentifier;
        AstNode primary;
        AstNode expression;
        return astNode.is(new AstNodeType[]{JavaGrammar.RETURN_STATEMENT}) && astNode.hasDirectChildren(new AstNodeType[]{JavaGrammar.EXPRESSION}) && (expression = astNode.getFirstChild(new AstNodeType[]{JavaGrammar.EXPRESSION})).getNumberOfChildren() == 1 && expression.getFirstChild().is(new AstNodeType[]{JavaGrammar.PRIMARY}) && (primary = expression.getFirstChild()).getNumberOfChildren() == 1 && primary.getFirstChild().is(new AstNodeType[]{JavaGrammar.QUALIFIED_IDENTIFIER}) && (qualifiedIdentifier = primary.getFirstChild()).getNumberOfChildren() == 1 && this.findPrivateClassVariable(varReturned = qualifiedIdentifier.getFirstChild());
    }

    private boolean findPrivateClassVariable(AstNode varReturned) {
        AstNode classBody = varReturned.getFirstAncestor((AstNodeType)JavaGrammar.CLASS_BODY_DECLARATION).getParent();
        for (AstNode classBodyDeclaration : classBody.getChildren(new AstNodeType[]{JavaGrammar.CLASS_BODY_DECLARATION})) {
            if (!this.hasPrivateModifier(classBodyDeclaration)) continue;
            for (AstNode memberDecl : classBodyDeclaration.getChildren(new AstNodeType[]{JavaGrammar.MEMBER_DECL})) {
                AstNode fieldDeclaration = memberDecl.getFirstChild(new AstNodeType[]{JavaGrammar.FIELD_DECLARATION});
                if (fieldDeclaration == null) continue;
                for (AstNode variableDeclarator : fieldDeclaration.getFirstChild(new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATORS}).getChildren(new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATOR})) {
                    if (!varReturned.getTokenValue().equals(variableDeclarator.getFirstChild().getTokenValue())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasPrivateModifier(AstNode classBodyDeclaration) {
        for (AstNode modifierNode : classBodyDeclaration.getChildren(new AstNodeType[]{JavaGrammar.MODIFIER})) {
            if (!modifierNode.getChild(0).is(new AstNodeType[]{JavaKeyword.PRIVATE})) continue;
            return true;
        }
        return false;
    }

    private boolean hasBooleanReturnType(MethodHelper method) {
        AstNode typeNode = method.getReturnType();
        return typeNode.isNot(new AstNodeType[]{JavaKeyword.VOID}) && typeNode.getChildren().size() == 1 && typeNode.getChild(0).getChild(0).is(new AstNodeType[]{JavaKeyword.BOOLEAN});
    }
}

