/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.google.common.base.Preconditions;
import com.sonar.sslr.api.AstNode;
import java.io.File;
import org.sonar.java.ast.visitors.JavaAstVisitor;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourceFile;
import org.sonar.squidbridge.api.SourcePackage;

public class FileVisitor
extends JavaAstVisitor {
    public void visitFile(AstNode astNode) {
        SourceFile sourceFile = FileVisitor.createSourceFile(this.peekParentPackage(), this.getContext().getFile());
        this.getContext().addSourceCode((SourceCode)sourceFile);
    }

    public void leaveFile(AstNode astNode) {
        Preconditions.checkState((boolean)this.getContext().peekSourceCode().isType(SourceFile.class));
        this.getContext().popSourceCode();
    }

    private static SourceFile createSourceFile(SourcePackage parentPackage, File file) {
        StringBuilder key = new StringBuilder();
        if (parentPackage != null && !"".equals(parentPackage.getKey())) {
            key.append(parentPackage.getKey());
            key.append("/");
        }
        key.append(file.getName());
        return new SourceFile(key.toString(), file.getPath());
    }
}

