/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.sonar.java.ast.api.JavaMetric;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.visitors.JavaAstVisitor;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.measures.MetricDef;

public class LinesVisitor
extends JavaAstVisitor {
    private final Charset charset;

    public LinesVisitor(Charset charset) {
        this.charset = charset;
    }

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaPunctuator.RWING});
    }

    public void visitNode(AstNode astNode) {
        SourceCode sourceCode = this.getContext().peekSourceCode();
        Preconditions.checkState((sourceCode.getStartAtLine() != -1 && sourceCode.getEndAtLine() != -1 ? 1 : 0) != 0);
        sourceCode.setMeasure((MetricDef)JavaMetric.LINES, sourceCode.getEndAtLine() - sourceCode.getStartAtLine() + 1);
    }

    public void leaveFile(AstNode astNode) {
        if (astNode == null) {
            return;
        }
        try {
            String content = Files.toString((File)this.getContext().getFile(), (Charset)this.charset);
            String[] lines = content.split("(\r)?\n|\r", -1);
            this.getContext().peekSourceCode().setMeasure((MetricDef)JavaMetric.LINES, lines.length);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

