/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.google.common.base.Preconditions;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Trivia;
import java.util.List;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.ast.visitors.MethodHelper;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.squidbridge.measures.Metric;
import org.sonar.squidbridge.measures.MetricDef;
import org.sonar.sslr.parser.LexerlessGrammar;

public class PublicApiVisitor
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        PublicApiVisitor.subscribe(this);
    }

    public static void subscribe(SquidCheck<LexerlessGrammar> visitor) {
        visitor.subscribeTo(new AstNodeType[]{JavaGrammar.CLASS_DECLARATION, JavaGrammar.INTERFACE_DECLARATION, JavaGrammar.ENUM_DECLARATION, JavaGrammar.ANNOTATION_TYPE_DECLARATION, JavaGrammar.FIELD_DECLARATION, JavaGrammar.CONSTRUCTOR_DECLARATOR_REST, JavaGrammar.METHOD_DECLARATOR_REST, JavaGrammar.VOID_METHOD_DECLARATOR_REST, JavaGrammar.INTERFACE_METHOD_DECLARATOR_REST, JavaGrammar.VOID_INTERFACE_METHOD_DECLARATORS_REST, JavaGrammar.ANNOTATION_METHOD_REST});
    }

    public void visitNode(AstNode astNode) {
        SourceCode currentResource = this.getContext().peekSourceCode();
        if (PublicApiVisitor.isPublicApi(astNode)) {
            currentResource.add((MetricDef)Metric.PUBLIC_API, 1.0);
            if (PublicApiVisitor.isDocumentedApi(astNode)) {
                currentResource.add((MetricDef)Metric.PUBLIC_DOC_API, 1.0);
            }
        }
    }

    public static boolean isPublicApi(AstNode astNode) {
        return PublicApiVisitor.isPublic(astNode) && !PublicApiVisitor.isStaticFinalVariable(astNode) && !PublicApiVisitor.isMethodWithOverrideAnnotation(astNode) && !PublicApiVisitor.isEmptyDefaultConstructor(astNode);
    }

    public static String getType(AstNode node) {
        String type = node.is(new AstNodeType[]{JavaGrammar.CLASS_DECLARATION}) ? "class" : (node.is(new AstNodeType[]{JavaGrammar.INTERFACE_DECLARATION}) ? "interface" : (node.is(new AstNodeType[]{JavaGrammar.ENUM_DECLARATION}) ? "enum" : (node.is(new AstNodeType[]{JavaGrammar.ANNOTATION_TYPE_DECLARATION}) ? "annotation" : (node.is(new AstNodeType[]{JavaGrammar.FIELD_DECLARATION}) ? "field" : (node.is(new AstNodeType[]{JavaGrammar.CONSTRUCTOR_DECLARATOR_REST}) ? "constructor" : "method")))));
        return type;
    }

    private static boolean isEmptyDefaultConstructor(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{JavaGrammar.CONSTRUCTOR_DECLARATOR_REST})) {
            MethodHelper method = new MethodHelper(astNode);
            return !method.hasParameters() && method.getStatements().isEmpty();
        }
        return false;
    }

    private static boolean isMethodWithOverrideAnnotation(AstNode astNode) {
        if (PublicApiVisitor.isMethod(astNode)) {
            return PublicApiVisitor.hasAnnotation(astNode, "Override") || PublicApiVisitor.hasAnnotation(astNode, "java.lang.Override");
        }
        return false;
    }

    private static boolean hasAnnotation(AstNode astNode, String expected) {
        AstNode declaration = PublicApiVisitor.getDeclaration(astNode);
        for (AstNode modifier : PublicApiVisitor.getModifiers(declaration)) {
            AstNode annotation = modifier.getFirstChild(new AstNodeType[]{JavaGrammar.ANNOTATION});
            if (annotation == null) continue;
            StringBuilder value = new StringBuilder();
            for (AstNode identifier : annotation.getFirstChild(new AstNodeType[]{JavaGrammar.QUALIFIED_IDENTIFIER}).getChildren()) {
                value.append(identifier.getTokenValue());
            }
            if (!value.toString().equals(expected)) continue;
            return true;
        }
        return false;
    }

    private static boolean isMethod(AstNode astNode) {
        return astNode.is(new AstNodeType[]{JavaGrammar.METHOD_DECLARATOR_REST, JavaGrammar.VOID_METHOD_DECLARATOR_REST, JavaGrammar.INTERFACE_METHOD_DECLARATOR_REST, JavaGrammar.VOID_INTERFACE_METHOD_DECLARATORS_REST, JavaGrammar.ANNOTATION_METHOD_REST});
    }

    private static boolean isStaticFinalVariable(AstNode astNode) {
        AstNode declaration = PublicApiVisitor.getDeclaration(astNode);
        return astNode.is(new AstNodeType[]{JavaGrammar.FIELD_DECLARATION, JavaGrammar.CONSTANT_DECLARATORS_REST}) && PublicApiVisitor.hasModifier(declaration, (AstNodeType)JavaKeyword.STATIC) && PublicApiVisitor.hasModifier(declaration, (AstNodeType)JavaKeyword.FINAL);
    }

    public static boolean isDocumentedApi(AstNode astNode) {
        return PublicApiVisitor.getApiJavadoc(astNode) != null;
    }

    public static String getApiJavadoc(AstNode astNode) {
        AstNode declaration = PublicApiVisitor.getDeclaration(astNode);
        for (Trivia trivia : declaration.getToken().getTrivia()) {
            String value;
            if (!trivia.isComment() || !(value = trivia.getToken().getOriginalValue()).startsWith("/**")) continue;
            return value;
        }
        return null;
    }

    private static boolean isPublic(AstNode astNode) {
        AstNode declaration = PublicApiVisitor.getDeclaration(astNode);
        return declaration.is(new AstNodeType[]{JavaGrammar.ANNOTATION_TYPE_ELEMENT_DECLARATION}) || declaration.is(new AstNodeType[]{JavaGrammar.INTERFACE_BODY_DECLARATION}) || PublicApiVisitor.hasModifier(declaration, (AstNodeType)JavaKeyword.PUBLIC);
    }

    private static boolean hasModifier(AstNode declaration, AstNodeType astNodeType) {
        for (AstNode modifier : PublicApiVisitor.getModifiers(declaration)) {
            if (!modifier.getFirstChild().is(new AstNodeType[]{astNodeType})) continue;
            return true;
        }
        return false;
    }

    private static List<AstNode> getModifiers(AstNode declaration) {
        return declaration.getChildren(new AstNodeType[]{JavaGrammar.MODIFIER});
    }

    public static AstNode getDeclaration(AstNode astNode) {
        AstNode declaration;
        if (astNode.getParent().is(new AstNodeType[]{JavaGrammar.MEMBER_DECL})) {
            declaration = astNode.getParent().getParent();
            Preconditions.checkState((boolean)declaration.is(new AstNodeType[]{JavaGrammar.CLASS_BODY_DECLARATION}));
        } else if (astNode.getParent().is(new AstNodeType[]{JavaGrammar.GENERIC_METHOD_OR_CONSTRUCTOR_REST})) {
            declaration = astNode.getParent().getParent().getParent();
            Preconditions.checkState((boolean)declaration.is(new AstNodeType[]{JavaGrammar.CLASS_BODY_DECLARATION}));
        } else if (astNode.getParent().is(new AstNodeType[]{JavaGrammar.INTERFACE_MEMBER_DECL})) {
            declaration = astNode.getParent().getParent();
            Preconditions.checkState((boolean)declaration.is(new AstNodeType[]{JavaGrammar.INTERFACE_BODY_DECLARATION}));
        } else if (astNode.getParent().is(new AstNodeType[]{JavaGrammar.INTERFACE_METHOD_OR_FIELD_REST})) {
            declaration = astNode.getParent().getParent().getParent().getParent();
            Preconditions.checkState((boolean)declaration.is(new AstNodeType[]{JavaGrammar.INTERFACE_BODY_DECLARATION}));
        } else if (astNode.getParent().is(new AstNodeType[]{JavaGrammar.INTERFACE_GENERIC_METHOD_DECL})) {
            declaration = astNode.getParent().getParent().getParent();
            Preconditions.checkState((boolean)declaration.is(new AstNodeType[]{JavaGrammar.INTERFACE_BODY_DECLARATION}));
        } else if (astNode.getParent().is(new AstNodeType[]{JavaGrammar.ANNOTATION_METHOD_OR_CONSTANT_REST})) {
            declaration = astNode.getParent().getParent().getParent();
            Preconditions.checkState((boolean)declaration.is(new AstNodeType[]{JavaGrammar.ANNOTATION_TYPE_ELEMENT_DECLARATION}));
        } else if (astNode.getParent().is(new AstNodeType[]{JavaGrammar.TYPE_DECLARATION})) {
            declaration = astNode.getParent();
        } else if (astNode.getParent().is(new AstNodeType[]{JavaGrammar.BLOCK_STATEMENT})) {
            declaration = astNode.getParent();
        } else if (astNode.getParent().is(new AstNodeType[]{JavaGrammar.ANNOTATION_TYPE_ELEMENT_REST})) {
            declaration = astNode.getParent().getParent();
            Preconditions.checkState((boolean)declaration.is(new AstNodeType[]{JavaGrammar.ANNOTATION_TYPE_ELEMENT_DECLARATION}));
        } else {
            throw new IllegalStateException(astNode.getParent().getType().toString());
        }
        return declaration;
    }
}

