/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.asm;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.sonar.java.bytecode.asm.AsmClassProvider;
import org.sonar.java.bytecode.asm.AsmEdge;
import org.sonar.java.bytecode.asm.AsmField;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.asm.AsmResource;
import org.sonar.java.bytecode.asm.SourceCodeEdgeUsage;

public class AsmClass
extends AsmResource {
    private final String internalName;
    private AsmClassProvider.DETAIL_LEVEL level;
    private AsmClass superClass;
    private final Map<String, AsmMethod> methods = Maps.newHashMap();
    private final Map<String, AsmField> fields = Maps.newHashMap();

    public AsmClass(String internalName, AsmClassProvider.DETAIL_LEVEL level) {
        this.internalName = internalName;
        this.setDetailLevel(level);
    }

    public AsmClass(String internalName) {
        this.internalName = internalName;
    }

    final void setDetailLevel(AsmClassProvider.DETAIL_LEVEL level) {
        this.level = level;
    }

    AsmClassProvider.DETAIL_LEVEL getDetailLevel() {
        return this.level;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public String getDisplayName() {
        return this.getInternalName().replace('/', '.');
    }

    void addMethod(AsmMethod asmMethod) {
        this.methods.put(asmMethod.getKey(), asmMethod);
    }

    public Collection<AsmMethod> getMethods() {
        return this.methods.values();
    }

    public Collection<AsmField> getFields() {
        return this.fields.values();
    }

    void addField(AsmField field) {
        this.fields.put(field.getName(), field);
    }

    public AsmField getField(String fieldName) {
        return this.fields.get(fieldName);
    }

    AsmField getFieldOrCreateIt(String fieldName) {
        AsmField field = this.getField(fieldName);
        if (field != null) {
            return field;
        }
        field = new AsmField(this, fieldName);
        this.addField(field);
        return field;
    }

    public AsmMethod getMethod(String key) {
        return this.methods.get(key);
    }

    AsmMethod getMethodOrCreateIt(String key) {
        AsmMethod method = this.getMethod(key);
        if (method != null) {
            return method;
        }
        method = new AsmMethod(this, key);
        method.setBodyLoaded(false);
        this.addMethod(method);
        return method;
    }

    void setSuperClass(AsmClass superClass) {
        this.superClass = superClass;
        this.addEdge(new AsmEdge(this, superClass, SourceCodeEdgeUsage.EXTENDS));
    }

    public AsmClass getSuperClass() {
        return this.superClass;
    }

    void addInterface(AsmClass implementedInterface) {
        this.addEdge(new AsmEdge(this, implementedInterface, SourceCodeEdgeUsage.IMPLEMENTS));
    }

    Set<AsmClass> getInterfaces() {
        return this.getImplementedInterfaces();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof AsmClass) {
            return this.internalName.equals(((AsmClass)object).internalName);
        }
        return false;
    }

    public int hashCode() {
        return this.internalName.hashCode();
    }
}

