/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.declaration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.model.JavaTree;
import org.sonar.java.resolve.Symbol;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

public class MethodTreeImpl
extends JavaTree
implements MethodTree {
    private final ModifiersTree modifiers;
    @Nullable
    private final Tree returnType;
    private final IdentifierTree simpleName;
    private final List<VariableTree> parameters;
    @Nullable
    private final BlockTree block;
    private final List<ExpressionTree> throwsClauses;
    private final ExpressionTree defaultValue;
    private Symbol.MethodSymbol symbol;

    public MethodTreeImpl(AstNode astNode, ModifiersTree modifiers, @Nullable Tree returnType, IdentifierTree simpleName, List<VariableTree> parameters, @Nullable BlockTree block, List<ExpressionTree> throwsClauses, @Nullable ExpressionTree defaultValue) {
        super(astNode);
        this.modifiers = (ModifiersTree)Preconditions.checkNotNull((Object)modifiers);
        this.returnType = returnType;
        this.simpleName = (IdentifierTree)Preconditions.checkNotNull((Object)simpleName);
        this.parameters = (List)Preconditions.checkNotNull(parameters);
        this.block = block;
        this.throwsClauses = (List)Preconditions.checkNotNull(throwsClauses);
        this.defaultValue = defaultValue;
    }

    @Override
    public Tree.Kind getKind() {
        return this.returnType == null ? Tree.Kind.CONSTRUCTOR : Tree.Kind.METHOD;
    }

    @Override
    public ModifiersTree modifiers() {
        return this.modifiers;
    }

    @Override
    public List<Tree> typeParameters() {
        return ImmutableList.of();
    }

    @Override
    @Nullable
    public Tree returnType() {
        return this.returnType;
    }

    @Override
    public IdentifierTree simpleName() {
        return this.simpleName;
    }

    @Override
    public List<VariableTree> parameters() {
        return this.parameters;
    }

    @Override
    public List<ExpressionTree> throwsClauses() {
        return this.throwsClauses;
    }

    @Override
    @Nullable
    public BlockTree block() {
        return this.block;
    }

    @Override
    @Nullable
    public ExpressionTree defaultValue() {
        return this.defaultValue;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitMethod(this);
    }

    public Symbol.MethodSymbol getSymbol() {
        return this.symbol;
    }

    public void setSymbol(Symbol.MethodSymbol symbol) {
        Preconditions.checkState((this.symbol == null ? 1 : 0) != 0);
        this.symbol = symbol;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator[])new Iterator[]{Iterators.forArray((Object[])new Tree[]{this.modifiers, this.returnType, this.simpleName}), this.parameters.iterator(), Iterators.singletonIterator((Object)this.block), this.throwsClauses.iterator(), Iterators.singletonIterator((Object)this.defaultValue)});
    }
}

