/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class ArrayAccessExpressionTreeImpl
extends AbstractTypedTree
implements ArrayAccessExpressionTree {
    private final ExpressionTree expression;
    private final ExpressionTree index;

    public ArrayAccessExpressionTreeImpl(AstNode astNode, ExpressionTree expression, ExpressionTree index) {
        super(astNode);
        this.expression = (ExpressionTree)Preconditions.checkNotNull((Object)expression);
        this.index = (ExpressionTree)Preconditions.checkNotNull((Object)index);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.ARRAY_ACCESS_EXPRESSION;
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public SyntaxToken openBracketToken() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ExpressionTree index() {
        return this.index;
    }

    @Override
    public SyntaxToken closeBracketToken() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitArrayAccessExpression(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.expression, this.index});
    }
}

