/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import java.util.List;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class CaseGroupTreeImpl
extends JavaTree
implements CaseGroupTree {
    private final List<CaseLabelTree> labels;
    private final List<StatementTree> body;

    public CaseGroupTreeImpl(AstNode astNode, List<CaseLabelTree> labels, List<StatementTree> body) {
        super(astNode);
        this.labels = (List)Preconditions.checkNotNull(labels);
        this.body = (List)Preconditions.checkNotNull(body);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.CASE_GROUP;
    }

    @Override
    public List<CaseLabelTree> labels() {
        return this.labels;
    }

    @Override
    public List<StatementTree> body() {
        return this.body;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitCaseGroup(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat(this.labels.iterator(), this.body.iterator());
    }
}

