/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

public class CatchTreeImpl
extends JavaTree
implements CatchTree {
    private final VariableTree parameter;
    private final BlockTree block;

    public CatchTreeImpl(AstNode astNode, VariableTree parameter, BlockTree block) {
        super(astNode);
        this.parameter = (VariableTree)Preconditions.checkNotNull((Object)parameter);
        this.block = (BlockTree)Preconditions.checkNotNull((Object)block);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.CATCH;
    }

    @Override
    public SyntaxToken catchKeyword() {
        return new InternalSyntaxToken(this.astNode.getFirstChild(new AstNodeType[]{JavaKeyword.CATCH}).getToken());
    }

    @Override
    public SyntaxToken openParenToken() {
        return new InternalSyntaxToken(this.astNode.getFirstChild(new AstNodeType[]{JavaPunctuator.LPAR}).getToken());
    }

    @Override
    public VariableTree parameter() {
        return this.parameter;
    }

    @Override
    public SyntaxToken closeParenToken() {
        return new InternalSyntaxToken(this.astNode.getFirstChild(new AstNodeType[]{JavaPunctuator.RPAR}).getToken());
    }

    @Override
    public BlockTree block() {
        return this.block;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitCatch(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.parameter, this.block});
    }
}

