/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.TypePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.java.bytecode.ClassLoaderBuilder;
import org.sonar.java.resolve.Convert;
import org.sonar.java.resolve.Resolve;
import org.sonar.java.resolve.Scope;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Symbols;
import org.sonar.java.resolve.Type;

public class BytecodeCompleter
implements Symbol.Completer {
    private static final Logger LOG = LoggerFactory.getLogger(BytecodeCompleter.class);
    private static final int ACCEPTABLE_BYTECODE_FLAGS = 28671;
    private Symbols symbols;
    private final List<File> projectClasspath;
    private final Map<String, Symbol.TypeSymbol> classes = new HashMap<String, Symbol.TypeSymbol>();
    private final Map<String, Symbol.PackageSymbol> packages = new HashMap<String, Symbol.PackageSymbol>();
    private ClassLoader classLoader;

    public BytecodeCompleter(List<File> projectClasspath) {
        this.projectClasspath = projectClasspath;
    }

    public void init(Symbols symbols) {
        this.symbols = symbols;
    }

    public Symbol.TypeSymbol registerClass(Symbol.TypeSymbol classSymbol) {
        String flatName = this.formFullName(classSymbol);
        Preconditions.checkState((!this.classes.containsKey(flatName) ? 1 : 0) != 0, (Object)("Registering class 2 times : " + flatName));
        this.classes.put(flatName, classSymbol);
        return classSymbol;
    }

    @Override
    public void complete(Symbol symbol) {
        LOG.debug("Completing symbol : " + symbol.name);
        String bytecodeName = this.formFullName(symbol);
        Symbol.TypeSymbol classSymbol = this.getClassSymbol(bytecodeName);
        Preconditions.checkState((classSymbol == symbol ? 1 : 0) != 0);
        InputStream inputStream = null;
        ClassReader classReader = null;
        try {
            inputStream = this.inputStreamFor(bytecodeName);
            classReader = new ClassReader(inputStream);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            Closeables.closeQuietly((Closeable)inputStream);
        }
        if (classReader != null) {
            classReader.accept((ClassVisitor)new BytecodeVisitor((Symbol.TypeSymbol)symbol), 7);
        }
    }

    private InputStream inputStreamFor(String fullname) {
        return this.getClassLoader().getResourceAsStream(Convert.bytecodeName(fullname) + ".class");
    }

    private ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = ClassLoaderBuilder.create(this.projectClasspath);
        }
        return this.classLoader;
    }

    public String formFullName(Symbol symbol) {
        return this.formFullName(symbol.name, symbol.owner);
    }

    public String formFullName(String name, Symbol site) {
        String result = name;
        for (Symbol owner = site; owner != this.symbols.defaultPackage; owner = owner.owner()) {
            String separator = ".";
            if (owner.kind == 2) {
                separator = "$";
            }
            result = owner.name + separator + result;
        }
        return result;
    }

    @VisibleForTesting
    Symbol.TypeSymbol getClassSymbol(String bytecodeName) {
        return this.getClassSymbol(bytecodeName, 0);
    }

    private Symbol.TypeSymbol getClassSymbol(String bytecodeName, int flags) {
        String flatName = Convert.flatName(bytecodeName);
        Symbol.TypeSymbol symbol = this.classes.get(flatName);
        if (symbol == null) {
            String shortName = Convert.shortName(flatName);
            String packageName = Convert.packagePart(flatName);
            String enclosingClassName = Convert.enclosingClassName(shortName);
            symbol = StringUtils.isNotEmpty((String)enclosingClassName) ? new Symbol.TypeSymbol(this.filterBytecodeFlags(flags), Convert.innerClassName(shortName), this.getClassSymbol(Convert.fullName(packageName, enclosingClassName))) : new Symbol.TypeSymbol(this.filterBytecodeFlags(flags), shortName, this.enterPackage(packageName));
            symbol.members = new Scope(symbol);
            if (this.getClassLoader().getResource(Convert.bytecodeName(flatName) + ".class") != null) {
                symbol.completer = this;
            } else {
                LOG.error("Class not found: " + bytecodeName);
                ((Type.ClassType)symbol.type).interfaces = ImmutableList.of();
            }
            this.classes.put(flatName, symbol);
        }
        return symbol;
    }

    private int filterBytecodeFlags(int flags) {
        return flags & 0x6FFF;
    }

    public Symbol loadClass(String fullname) {
        InputStream inputStream = this.inputStreamFor(fullname);
        String bytecodeName = Convert.bytecodeName(fullname);
        if (inputStream == null) {
            return new Resolve.SymbolNotFound();
        }
        try {
            ClassReader classReader = new ClassReader(inputStream);
            String className = classReader.getClassName();
            if (!className.equals(bytecodeName)) {
                Resolve.SymbolNotFound symbolNotFound = new Resolve.SymbolNotFound();
                return symbolNotFound;
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            Closeables.closeQuietly((Closeable)inputStream);
        }
        return this.getClassSymbol(fullname);
    }

    public Symbol.PackageSymbol enterPackage(String fullname) {
        if (StringUtils.isBlank((String)fullname)) {
            return this.symbols.defaultPackage;
        }
        Symbol.PackageSymbol result = this.packages.get(fullname);
        if (result == null) {
            result = new Symbol.PackageSymbol(fullname, this.symbols.defaultPackage);
            this.packages.put(fullname, result);
        }
        return result;
    }

    public void done() {
        if (this.classLoader != null && this.classLoader instanceof Closeable) {
            Closeables.closeQuietly((Closeable)((Closeable)((Object)this.classLoader)));
        }
    }

    static boolean isSynthetic(int flags) {
        return (flags & 0x1000) != 0;
    }

    private class BytecodeVisitor
    extends ClassVisitor {
        private final Symbol.TypeSymbol classSymbol;
        private String className;

        private BytecodeVisitor(Symbol.TypeSymbol classSymbol) {
            super(327680);
            this.classSymbol = classSymbol;
        }

        private Symbol.TypeSymbol getClassSymbol(String bytecodeName) {
            return BytecodeCompleter.this.getClassSymbol(Convert.flatName(bytecodeName));
        }

        private Symbol.TypeSymbol getClassSymbol(String bytecodeName, int flags) {
            return BytecodeCompleter.this.getClassSymbol(Convert.flatName(bytecodeName), flags);
        }

        public void visit(int version, int flags, String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
            Preconditions.checkState((boolean)name.endsWith(this.classSymbol.name), (Object)("Name : '" + name + "' should ends with " + this.classSymbol.name));
            Preconditions.checkState((!BytecodeCompleter.isSynthetic(flags) ? 1 : 0) != 0, (Object)(name + " is synthetic"));
            this.className = name;
            this.classSymbol.flags = BytecodeCompleter.this.filterBytecodeFlags(flags);
            this.classSymbol.members = new Scope(this.classSymbol);
            if (superName == null) {
                Preconditions.checkState((boolean)"java/lang/Object".equals(this.className), (Object)("superName must be null only for java/lang/Object, but not for " + this.className));
            } else {
                ((Type.ClassType)this.classSymbol.type).supertype = this.getClassSymbol((String)superName).type;
            }
            ((Type.ClassType)this.classSymbol.type).interfaces = this.getCompletedClassSymbolsType(interfaces);
        }

        public void visitSource(@Nullable String source, @Nullable String debug) {
            throw new IllegalStateException();
        }

        public void visitOuterClass(String owner, String name, String desc) {
            throw new IllegalStateException();
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return null;
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return null;
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitInnerClass(String name, @Nullable String outerName, @Nullable String innerName, int flags) {
            if (!BytecodeCompleter.isSynthetic(flags) && innerName != null && outerName != null) {
                if (this.className.equals(outerName)) {
                    this.defineInnerClass(name, flags);
                } else if (this.className.equals(name)) {
                    this.defineOuterClass(outerName, innerName, flags);
                }
            }
        }

        private void defineInnerClass(String bytecodeName, int flags) {
            Symbol.TypeSymbol innerClass = this.getClassSymbol(bytecodeName, flags);
            Preconditions.checkState((innerClass.owner == this.classSymbol ? 1 : 0) != 0, (Object)("Innerclass : " + innerClass.owner.getName() + " and classSymbol : " + this.classSymbol.getName() + " are not the same."));
            this.classSymbol.members.enter(innerClass);
        }

        private void defineOuterClass(String outerName, String innerName, int flags) {
            Symbol.TypeSymbol outerClassSymbol = this.getClassSymbol(outerName, flags);
            Preconditions.checkState((outerClassSymbol.completer == null || outerClassSymbol.completer instanceof BytecodeCompleter ? 1 : 0) != 0);
            this.classSymbol.name = innerName;
            this.classSymbol.owner = outerClassSymbol;
        }

        public FieldVisitor visitField(int flags, String name, String desc, @Nullable String signature, @Nullable Object value) {
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkNotNull((Object)desc);
            if (!BytecodeCompleter.isSynthetic(flags)) {
                Symbol.VariableSymbol symbol = new Symbol.VariableSymbol(BytecodeCompleter.this.filterBytecodeFlags(flags), name, this.convertAsmType(org.objectweb.asm.Type.getType((String)desc)), (Symbol)this.classSymbol);
                this.classSymbol.members.enter(symbol);
            }
            return null;
        }

        public MethodVisitor visitMethod(int flags, String name, String desc, @Nullable String signature, @Nullable String[] exceptions) {
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkNotNull((Object)desc);
            if (!BytecodeCompleter.isSynthetic(flags)) {
                Preconditions.checkState(((flags & 0x40) == 0 ? 1 : 0) != 0, (Object)("bridge method not marked as synthetic in class " + this.className));
                Type.MethodType type = new Type.MethodType(this.convertAsmTypes(org.objectweb.asm.Type.getArgumentTypes((String)desc)), this.convertAsmType(org.objectweb.asm.Type.getReturnType((String)desc)), this.getCompletedClassSymbolsType(exceptions), this.classSymbol);
                Symbol.MethodSymbol methodSymbol = new Symbol.MethodSymbol(BytecodeCompleter.this.filterBytecodeFlags(flags), name, type, (Symbol)this.classSymbol);
                this.classSymbol.members.enter(methodSymbol);
            }
            return null;
        }

        private List<Type> convertAsmTypes(org.objectweb.asm.Type[] asmTypes) {
            ImmutableList.Builder result = ImmutableList.builder();
            for (org.objectweb.asm.Type asmType : asmTypes) {
                result.add((Object)this.convertAsmType(asmType));
            }
            return result.build();
        }

        private Type convertAsmType(org.objectweb.asm.Type asmType) {
            Type result;
            switch (asmType.getSort()) {
                case 10: {
                    result = this.getClassSymbol((String)asmType.getInternalName()).type;
                    break;
                }
                case 3: {
                    result = ((BytecodeCompleter)BytecodeCompleter.this).symbols.byteType;
                    break;
                }
                case 2: {
                    result = ((BytecodeCompleter)BytecodeCompleter.this).symbols.charType;
                    break;
                }
                case 4: {
                    result = ((BytecodeCompleter)BytecodeCompleter.this).symbols.shortType;
                    break;
                }
                case 5: {
                    result = ((BytecodeCompleter)BytecodeCompleter.this).symbols.intType;
                    break;
                }
                case 7: {
                    result = ((BytecodeCompleter)BytecodeCompleter.this).symbols.longType;
                    break;
                }
                case 6: {
                    result = ((BytecodeCompleter)BytecodeCompleter.this).symbols.floatType;
                    break;
                }
                case 8: {
                    result = ((BytecodeCompleter)BytecodeCompleter.this).symbols.doubleType;
                    break;
                }
                case 1: {
                    result = ((BytecodeCompleter)BytecodeCompleter.this).symbols.booleanType;
                    break;
                }
                case 9: {
                    result = new Type.ArrayType(this.convertAsmType(asmType.getElementType()), ((BytecodeCompleter)BytecodeCompleter.this).symbols.arrayClass);
                    break;
                }
                case 0: {
                    result = ((BytecodeCompleter)BytecodeCompleter.this).symbols.voidType;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(asmType.toString());
                }
            }
            return result;
        }

        public void visitEnd() {
            if (this.classSymbol.owner == null) {
                String flatName = this.className.replace('/', '.');
                this.classSymbol.name = flatName.substring(flatName.lastIndexOf(46) + 1);
                this.classSymbol.owner = BytecodeCompleter.this.enterPackage(flatName);
                Symbol.PackageSymbol owner = (Symbol.PackageSymbol)this.classSymbol.owner;
                if (owner.members == null) {
                    owner.members = new Scope(owner);
                }
                owner.members.enter(this.classSymbol);
            }
        }

        private List<Type> getCompletedClassSymbolsType(@Nullable String[] bytecodeNames) {
            if (bytecodeNames == null) {
                return ImmutableList.of();
            }
            ImmutableList.Builder types = ImmutableList.builder();
            for (String bytecodeName : bytecodeNames) {
                types.add((Object)this.getClassSymbol((String)bytecodeName).type);
            }
            return types.build();
        }
    }
}

