/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.JavaTree;
import org.sonar.java.resolve.Resolve;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Symbols;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.EnumConstantTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

public class ExpressionVisitor
extends BaseTreeVisitor {
    private final Map<Tree.Kind, Type> typesOfLiterals = Maps.newEnumMap(Tree.Kind.class);
    private final SemanticModel semanticModel;
    private final Symbols symbols;
    private final Resolve resolve;
    private final Map<Tree, Type> types = Maps.newHashMap();

    public ExpressionVisitor(SemanticModel semanticModel, Symbols symbols, Resolve resolve) {
        this.semanticModel = semanticModel;
        this.symbols = symbols;
        this.resolve = resolve;
        this.typesOfLiterals.put(Tree.Kind.BOOLEAN_LITERAL, symbols.booleanType);
        this.typesOfLiterals.put(Tree.Kind.NULL_LITERAL, symbols.nullType);
        this.typesOfLiterals.put(Tree.Kind.CHAR_LITERAL, symbols.charType);
        this.typesOfLiterals.put(Tree.Kind.STRING_LITERAL, symbols.stringType);
        this.typesOfLiterals.put(Tree.Kind.FLOAT_LITERAL, symbols.floatType);
        this.typesOfLiterals.put(Tree.Kind.DOUBLE_LITERAL, symbols.doubleType);
        this.typesOfLiterals.put(Tree.Kind.LONG_LITERAL, symbols.longType);
        this.typesOfLiterals.put(Tree.Kind.INT_LITERAL, symbols.intType);
    }

    @Override
    public void visitExpressionStatement(ExpressionStatementTree tree) {
        super.visitExpressionStatement(tree);
        this.registerType(tree, this.getType(tree.expression()));
    }

    @Override
    public void visitMethodInvocation(MethodInvocationTree tree) {
        IdentifierTree identifier;
        Type type;
        super.visitMethodInvocation(tree);
        ExpressionTree methodSelect = tree.methodSelect();
        Resolve.Env env = this.semanticModel.getEnv(tree);
        if (methodSelect.is(Tree.Kind.MEMBER_SELECT)) {
            MemberSelectExpressionTree mset = (MemberSelectExpressionTree)methodSelect;
            type = this.getType(mset.expression());
            identifier = mset.identifier();
        } else if (methodSelect.is(Tree.Kind.IDENTIFIER)) {
            type = env.enclosingClass.type;
            identifier = (IdentifierTree)methodSelect;
        } else {
            throw new IllegalStateException("Method select in method invocation is not of the expected type " + methodSelect);
        }
        String name = identifier.name();
        if (type == null) {
            type = this.symbols.unknownType;
        }
        Symbol symbol = this.resolve.findMethod(env, type.symbol, name, (List<Type>)ImmutableList.of());
        this.associateReference(identifier, symbol);
        type = this.getTypeOfSymbol(symbol);
        if (type == null) {
            type = this.symbols.unknownType;
        }
        this.registerType(tree, type);
    }

    @Override
    public void visitInstanceOf(InstanceOfTree tree) {
        super.visitInstanceOf(tree);
        this.registerType(tree, this.symbols.booleanType);
    }

    @Override
    public void visitParameterizedType(ParameterizedTypeTree tree) {
        super.visitParameterizedType(tree);
        this.registerType(tree, this.symbols.unknownType);
    }

    @Override
    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        super.visitConditionalExpression(tree);
        this.registerType(tree, this.symbols.unknownType);
    }

    @Override
    public void visitLambdaExpression(LambdaExpressionTree tree) {
        super.visitLambdaExpression(tree);
        this.registerType(tree, this.symbols.unknownType);
    }

    @Override
    public void visitNewArray(NewArrayTree tree) {
        super.visitNewArray(tree);
        Type type = this.getType(tree.type());
        int dimensions = tree.dimensions().size();
        type = new Type.ArrayType(type, this.symbols.arrayClass);
        for (int i = 1; i < dimensions; ++i) {
            type = new Type.ArrayType(type, this.symbols.arrayClass);
        }
        this.registerType(tree, type);
    }

    @Override
    public void visitParenthesized(ParenthesizedTree tree) {
        super.visitParenthesized(tree);
        this.registerType(tree, this.getType(tree.expression()));
    }

    @Override
    public void visitArrayAccessExpression(ArrayAccessExpressionTree tree) {
        super.visitArrayAccessExpression(tree);
        Type type = this.getType(tree.expression());
        if (type != null && type.tag == 11) {
            this.registerType(tree, ((Type.ArrayType)type).elementType);
        } else {
            this.registerType(tree, this.symbols.unknownType);
        }
    }

    @Override
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        super.visitBinaryExpression(tree);
        Resolve.Env env = this.semanticModel.getEnv(tree);
        Type left = this.getType(tree.leftOperand());
        Type right = this.getType(tree.rightOperand());
        if (left == null || right == null) {
            this.registerType(tree, this.symbols.unknownType);
            return;
        }
        Symbol symbol = this.resolve.findMethod(env, tree.operatorToken().text(), (List<Type>)ImmutableList.of((Object)left, (Object)right));
        if (symbol.kind != 16) {
            this.registerType(tree, this.symbols.unknownType);
            return;
        }
        this.registerType(tree, ((Type.MethodType)symbol.type).resultType);
    }

    @Override
    public void visitNewClass(NewClassTree tree) {
        super.visitNewClass(tree);
        if (tree.classBody() != null) {
            this.registerType(tree, this.symbols.unknownType);
        } else {
            this.registerType(tree, this.getType(tree.identifier()));
        }
    }

    @Override
    public void visitPrimitiveType(PrimitiveTypeTree tree) {
        Type type = this.resolve.findIdent((Resolve.Env)this.semanticModel.getEnv((Tree)tree), (String)tree.keyword().text(), (int)2).type;
        this.registerType(tree, type);
    }

    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        super.visitAssignmentExpression(tree);
        Type type = this.getType(tree.variable());
        this.registerType(tree, type);
    }

    @Override
    public void visitLiteral(LiteralTree tree) {
        super.visitLiteral(tree);
        Type type = this.typesOfLiterals.get((Object)((JavaTree)((Object)tree)).getKind());
        this.registerType(tree, type);
    }

    @Override
    public void visitUnaryExpression(UnaryExpressionTree tree) {
        super.visitUnaryExpression(tree);
        this.registerType(tree, this.getType(tree.expression()));
    }

    @Override
    public void visitArrayType(ArrayTypeTree tree) {
        super.visitArrayType(tree);
        this.registerType(tree, new Type.ArrayType(this.getType(tree.type()), this.symbols.arrayClass));
    }

    @Override
    public void visitTypeCast(TypeCastTree tree) {
        super.visitTypeCast(tree);
        this.registerType(tree, this.getType(tree.type()));
    }

    @Override
    public void visitEnumConstant(EnumConstantTree tree) {
        this.scan(tree.modifiers());
        NewClassTree newClassTree = (NewClassTree)tree.initializer();
        this.scan(newClassTree.enclosingExpression());
        this.scan(newClassTree.typeArguments());
        this.scan(newClassTree.arguments());
        this.scan(newClassTree.classBody());
    }

    @Override
    public void visitIdentifier(IdentifierTree tree) {
        Symbol symbol = this.resolve.findIdent(this.semanticModel.getEnv(tree), tree.name(), 7);
        this.associateReference(tree, symbol);
        this.registerType(tree, this.getTypeOfSymbol(symbol));
    }

    @Override
    public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
        this.resolveQualifiedIdentifier(tree);
    }

    @Override
    public void visitAnnotation(AnnotationTree tree) {
        super.visitAnnotation(tree);
        this.registerType(tree, this.symbols.unknownType);
    }

    private void resolveQualifiedIdentifier(Tree tree) {
        final Resolve.Env env = this.semanticModel.getEnv(tree);
        class FQV
        extends BaseTreeVisitor {
            private Symbol site;

            FQV() {
            }

            @Override
            public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
                this.scan(tree.expression());
                String name = tree.identifier().name();
                if (JavaKeyword.CLASS.getValue().equals(name)) {
                    ExpressionVisitor.this.registerType(tree, ((ExpressionVisitor)ExpressionVisitor.this).symbols.classType);
                    return;
                }
                if (this.site.kind >= 64) {
                    ExpressionVisitor.this.registerType(tree, ((ExpressionVisitor)ExpressionVisitor.this).symbols.unknownType);
                    return;
                }
                if (this.site.kind == 4) {
                    Type siteType = ((Symbol.VariableSymbol)this.site).type;
                    if (siteType == null) {
                        ExpressionVisitor.this.registerType(tree, ((ExpressionVisitor)ExpressionVisitor.this).symbols.unknownType);
                        return;
                    }
                    this.site = ExpressionVisitor.this.resolve.findIdentInType(env, siteType.symbol, name, 6);
                } else if (this.site.kind == 2) {
                    this.site = ExpressionVisitor.this.resolve.findIdentInType(env, (Symbol.TypeSymbol)this.site, name, 6);
                } else if (this.site.kind == 1) {
                    this.site = ExpressionVisitor.this.resolve.findIdentInPackage(env, this.site, name, 5);
                } else {
                    if (this.site.kind == 16) {
                        ExpressionVisitor.this.registerType(tree, ((ExpressionVisitor)ExpressionVisitor.this).symbols.unknownType);
                        return;
                    }
                    throw new IllegalStateException("Unexpected Symbol kind: " + this.site.kind);
                }
                ExpressionVisitor.this.associateReference(tree.identifier(), this.site);
                ExpressionVisitor.this.registerType(tree, ExpressionVisitor.this.getTypeOfSymbol(this.site));
            }

            @Override
            public void visitArrayType(ArrayTypeTree tree) {
                super.visitArrayType(tree);
                ExpressionVisitor.this.registerType(tree, new Type.ArrayType(ExpressionVisitor.this.getType(tree.type()), ((ExpressionVisitor)ExpressionVisitor.this).symbols.arrayClass));
            }

            @Override
            public void visitArrayAccessExpression(ArrayAccessExpressionTree tree) {
                super.visitArrayAccessExpression(tree);
                Type arrayType = ExpressionVisitor.this.getType(tree.expression());
                if (arrayType != null && arrayType.tag == 11) {
                    this.site = arrayType.symbol;
                    ExpressionVisitor.this.registerType(tree, ((Type.ArrayType)arrayType).elementType);
                } else {
                    ExpressionVisitor.this.registerType(tree, ((ExpressionVisitor)ExpressionVisitor.this).symbols.unknownType);
                }
            }

            @Override
            public void visitIdentifier(IdentifierTree tree) {
                this.site = ExpressionVisitor.this.resolve.findIdent(ExpressionVisitor.this.semanticModel.getEnv(tree), tree.name(), 7);
                ExpressionVisitor.this.associateReference(tree, this.site);
                ExpressionVisitor.this.registerType(tree, ExpressionVisitor.this.getTypeOfSymbol(this.site));
            }

            @Override
            public void visitLiteral(LiteralTree tree) {
                Type literalType = (Type)ExpressionVisitor.this.typesOfLiterals.get((Object)((JavaTree)((Object)tree)).getKind());
                this.site = literalType.symbol;
                ExpressionVisitor.this.registerType(tree, literalType);
            }

            @Override
            public void visitPrimitiveType(PrimitiveTypeTree tree) {
                this.site = ExpressionVisitor.this.resolve.findIdent(ExpressionVisitor.this.semanticModel.getEnv(tree), tree.keyword().text(), 2);
                ExpressionVisitor.this.registerType(tree, this.site.type);
            }
        }
        FQV visitor = new FQV();
        tree.accept(visitor);
    }

    private Type getTypeOfSymbol(Symbol symbol) {
        if (symbol.kind < 64) {
            return symbol.type;
        }
        return this.symbols.unknownType;
    }

    @VisibleForTesting
    Type getType(Tree tree) {
        return this.types.get(tree);
    }

    private void registerType(Tree tree, Type type) {
        if (AbstractTypedTree.class.isAssignableFrom(tree.getClass())) {
            ((AbstractTypedTree)tree).setType(type);
        }
        this.types.put(tree, type);
    }

    private void associateReference(IdentifierTree tree, Symbol symbol) {
        if (symbol.kind < 64) {
            this.semanticModel.associateReference(tree, symbol);
        }
    }
}

