/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sonar.java.resolve.BytecodeCompleter;
import org.sonar.java.resolve.Symbol;

public class Scope {
    final Symbol owner;
    final Scope next;
    protected ArrayListMultimap<String, Symbol> symbols = ArrayListMultimap.create();

    public Scope(Symbol owner) {
        this.owner = owner;
        this.next = null;
    }

    public Scope(Scope next) {
        this.owner = next.owner;
        this.next = next;
    }

    public void enter(Symbol symbol) {
        this.symbols.put((Object)symbol.name, (Object)symbol);
    }

    public List<Symbol> lookup(String name) {
        Scope scope = this;
        while (scope != null && !scope.symbols.containsKey((Object)name)) {
            scope = scope.next;
        }
        return scope == null ? ImmutableList.of() : scope.symbols.get((Object)name);
    }

    public Collection<Symbol> scopeSymbols() {
        return ImmutableList.copyOf((Collection)this.symbols.values());
    }

    public static class StaticStarImportScope
    extends Scope {
        private final BytecodeCompleter bytecodeCompleter;

        public StaticStarImportScope(Symbol owner, BytecodeCompleter bytecodeCompleter) {
            super(owner);
            this.bytecodeCompleter = bytecodeCompleter;
        }

        @Override
        public List<Symbol> lookup(String name) {
            ArrayList symbolsList = Lists.newArrayList();
            for (Symbol site : this.symbols.values()) {
                if ((site.kind & 1) != 0) {
                    Symbol symbol = this.bytecodeCompleter.loadClass(this.bytecodeCompleter.formFullName(name, site));
                    if (symbol.kind < 64) {
                        symbolsList.add(symbol);
                    }
                }
                if ((site.kind & 2) == 0) continue;
                List<Symbol> resolved = ((Symbol.TypeSymbol)site).members().lookup(name);
                for (Symbol symbol : resolved) {
                    if (symbol.kind >= 64 || (symbol.flags & 8) == 0) continue;
                    symbolsList.add(symbol);
                }
            }
            return symbolsList;
        }
    }

    public static class StarImportScope
    extends Scope {
        private final BytecodeCompleter bytecodeCompleter;

        public StarImportScope(Symbol owner, BytecodeCompleter bytecodeCompleter) {
            super(owner);
            this.bytecodeCompleter = bytecodeCompleter;
        }

        @Override
        public List<Symbol> lookup(String name) {
            ArrayList symbolsList = Lists.newArrayList();
            for (Symbol site : this.symbols.values()) {
                Symbol symbol = this.bytecodeCompleter.loadClass(this.bytecodeCompleter.formFullName(name, site));
                if (symbol.kind >= 64) continue;
                symbolsList.add(symbol);
            }
            return symbolsList;
        }
    }
}

