/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.java.signature.MethodSignaturePrinter;
import org.sonar.java.signature.MethodSignatureScanner;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

public class JavaFilesCache
extends BaseTreeVisitor
implements JavaFileScanner {
    @VisibleForTesting
    Map<String, File> resourcesCache = Maps.newHashMap();
    @VisibleForTesting
    Map<String, Integer> methodStartLines = Maps.newHashMap();
    @VisibleForTesting
    Set<Integer> ignoredLines = Sets.newHashSet();
    private File currentFile;
    private Deque<String> currentClassKey = new LinkedList<String>();
    private Deque<Tree> parent = new LinkedList<Tree>();
    private Deque<Integer> anonymousInnerClassCounter = new LinkedList<Integer>();
    private String currentPackage;

    public Map<String, File> getResourcesCache() {
        return this.resourcesCache;
    }

    public Map<String, Integer> getMethodStartLines() {
        return this.methodStartLines;
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        JavaTree.CompilationUnitTreeImpl tree = (JavaTree.CompilationUnitTreeImpl)context.getTree();
        this.currentPackage = tree.packageNameAsString().replace('.', '/');
        this.currentFile = context.getFile();
        this.currentClassKey.clear();
        this.parent.clear();
        this.anonymousInnerClassCounter.clear();
        this.ignoredLines.clear();
        this.scan(tree);
    }

    @Override
    public void visitClass(ClassTree tree) {
        String className = "";
        if (tree.simpleName() != null) {
            className = tree.simpleName().name();
        }
        String key = this.getClassKey(className);
        this.currentClassKey.push(key);
        this.parent.push(tree);
        this.anonymousInnerClassCounter.push(0);
        this.resourcesCache.put(key, this.currentFile);
        this.isSuppressWarning(tree);
        super.visitClass(tree);
        this.currentClassKey.pop();
        this.parent.pop();
        this.anonymousInnerClassCounter.pop();
    }

    private String getClassKey(String className) {
        String key = className;
        if (StringUtils.isNotEmpty((String)this.currentPackage)) {
            key = this.currentPackage + "/" + className;
        }
        if ("".equals(className) || this.parent.peek() != null && this.parent.peek().is(Tree.Kind.METHOD)) {
            int count = this.anonymousInnerClassCounter.pop() + 1;
            key = this.currentClassKey.peek() + "$" + count + className;
            this.anonymousInnerClassCounter.push(count);
        } else if (this.currentClassKey.peek() != null) {
            key = this.currentClassKey.peek() + "$" + className;
        }
        return key;
    }

    @Override
    public void visitMethod(MethodTree tree) {
        this.parent.push(tree);
        String methodKey = this.currentClassKey.peek() + "#" + MethodSignaturePrinter.print(MethodSignatureScanner.scan(tree));
        this.methodStartLines.put(methodKey, ((JavaTree)((Object)tree.simpleName())).getLine());
        this.isSuppressWarning(tree);
        super.visitMethod(tree);
        this.parent.pop();
    }

    private void isSuppressWarning(ClassTree tree) {
        int endLine = ((InternalSyntaxToken)tree.closeBraceToken()).getLine();
        this.isSuppressWarning(tree.modifiers().annotations(), endLine);
    }

    private void isSuppressWarning(MethodTree tree) {
        int endLine = ((JavaTree)((Object)tree.simpleName())).getLine();
        if (tree.block() != null) {
            endLine = ((InternalSyntaxToken)tree.block().closeBraceToken()).getLine();
        }
        this.isSuppressWarning(tree.modifiers().annotations(), endLine);
    }

    private void isSuppressWarning(List<AnnotationTree> annotationTrees, int endLine) {
        boolean hasSuppressAllWarnings = false;
        int startLine = 0;
        for (AnnotationTree annotationTree : annotationTrees) {
            if (!this.isSuppressAllWarnings(annotationTree)) continue;
            startLine = ((JavaTree)((Object)annotationTree)).getLine();
            hasSuppressAllWarnings = true;
        }
        if (hasSuppressAllWarnings) {
            for (int i = startLine; i <= endLine; ++i) {
                this.ignoredLines.add(i);
            }
        }
    }

    private boolean isSuppressAllWarnings(AnnotationTree annotationTree) {
        boolean suppressWarningsType = false;
        Tree type = annotationTree.annotationType();
        if (type.is(Tree.Kind.IDENTIFIER)) {
            suppressWarningsType = "SuppressWarnings".equals(((IdentifierTree)type).name());
        } else if (type.is(Tree.Kind.MEMBER_SELECT)) {
            MemberSelectExpressionTree mset = (MemberSelectExpressionTree)type;
            boolean bl = suppressWarningsType = "SuppressWarnings".equals(mset.identifier().name()) && mset.expression().is(Tree.Kind.MEMBER_SELECT) && "lang".equals(((MemberSelectExpressionTree)mset.expression()).identifier().name());
        }
        if (suppressWarningsType) {
            for (ExpressionTree expression : annotationTree.arguments()) {
                if (!expression.is(Tree.Kind.STRING_LITERAL) || !"\"all\"".equals(((LiteralTree)expression).value())) continue;
                return true;
            }
        }
        return false;
    }

    public Set<Integer> ignoredLines() {
        return this.ignoredLines;
    }
}

