/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.parser;

import com.sonar.sslr.api.AstNode;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.Tree;

public class PrinterVisitor
extends BaseTreeVisitor {
    private static final int INDENT_SPACES = 2;
    private final StringBuilder sb = new StringBuilder();
    private int indentLevel = 0;

    public static String print(Tree tree) {
        PrinterVisitor pv = new PrinterVisitor();
        pv.scan(tree);
        return pv.sb.toString();
    }

    public static String print(List<? extends Tree> trees) {
        StringBuilder result = new StringBuilder();
        for (Tree tree : trees) {
            result.append(PrinterVisitor.print(tree));
        }
        return result.toString();
    }

    private StringBuilder indent() {
        return this.sb.append(StringUtils.leftPad((String)"", (int)(2 * this.indentLevel)));
    }

    @Override
    protected void scan(List<? extends Tree> trees) {
        if (!trees.isEmpty()) {
            this.sb.deleteCharAt(this.sb.length() - 1);
            this.sb.append(" : [\n");
            super.scan(trees);
            this.indent().append("]\n");
        }
    }

    @Override
    protected void scan(@Nullable Tree tree) {
        if (tree != null) {
            Tree.Kind kind = ((JavaTree)tree).getKind();
            String nodeName = ((JavaTree)tree).getClass().getSimpleName();
            if (kind != null) {
                nodeName = kind.getAssociatedInterface().getSimpleName();
            }
            this.indent().append(nodeName);
            AstNode node = ((JavaTree)tree).getAstNode();
            if (node != null && node.hasToken()) {
                this.sb.append(" ").append(node.getTokenLine());
            }
            this.sb.append("\n");
        }
        ++this.indentLevel;
        super.scan(tree);
        --this.indentLevel;
    }
}

