/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.declaration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.declaration.ModifiersTreeImpl;
import org.sonar.java.model.expression.IdentifierTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.InferedTypeTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

public class VariableTreeImpl
extends JavaTree
implements VariableTree {
    private ModifiersTree modifiers;
    private Tree type;
    private IdentifierTree simpleName;
    @Nullable
    private ExpressionTree initializer;
    private Symbol.VariableSymbol symbol;
    private int dims;
    private boolean vararg = false;

    public VariableTreeImpl(IdentifierTreeImpl simpleName, int dims, List<AstNode> additionalChildren) {
        super(Tree.Kind.VARIABLE);
        this.modifiers = ModifiersTreeImpl.emptyModifiers();
        this.simpleName = simpleName;
        this.dims = dims;
        this.initializer = null;
        this.addChild((AstNode)this.modifiers);
        this.addChild(simpleName);
        for (AstNode child : additionalChildren) {
            this.addChild(child);
        }
    }

    public VariableTreeImpl(InternalSyntaxToken equalToken, ExpressionTree initializer, AstNode ... children) {
        super(Tree.Kind.VARIABLE);
        this.initializer = initializer;
        for (AstNode child : children) {
            this.addChild(child);
        }
    }

    public VariableTreeImpl(IdentifierTreeImpl simpleName) {
        this(simpleName, 0, (List<AstNode>)ImmutableList.of());
        this.type = new InferedTypeTree();
    }

    public VariableTreeImpl(Tree.Kind kind, ModifiersTree modifiers, IdentifierTree simpleName, @Nullable ExpressionTree initializer) {
        super(kind);
        this.modifiers = (ModifiersTree)Preconditions.checkNotNull((Object)modifiers);
        this.simpleName = (IdentifierTree)Preconditions.checkNotNull((Object)simpleName);
        this.dims = -1;
        this.initializer = initializer;
    }

    public VariableTreeImpl(AstNode astNode, ModifiersTree modifiers, Tree type, IdentifierTree simpleName, @Nullable ExpressionTree initializer) {
        super(astNode);
        this.modifiers = (ModifiersTree)Preconditions.checkNotNull((Object)modifiers);
        this.type = (Tree)Preconditions.checkNotNull((Object)type);
        this.simpleName = (IdentifierTree)Preconditions.checkNotNull((Object)simpleName);
        this.dims = -1;
        this.initializer = initializer;
    }

    public VariableTreeImpl completeType(Tree type) {
        int i;
        Tree actualType = type;
        int n = i = this.isVararg() ? 1 + this.dims() : this.dims();
        while (i > 0) {
            actualType = new JavaTree.ArrayTypeTreeImpl(null, actualType);
            --i;
        }
        this.type = actualType;
        return this;
    }

    public VariableTreeImpl completeModifiers(ModifiersTreeImpl modifiers) {
        this.modifiers = modifiers;
        return this;
    }

    public VariableTreeImpl completeModifiersAndType(ModifiersTreeImpl modifiers, Tree type) {
        return this.completeModifiers(modifiers).completeType(type);
    }

    public VariableTreeImpl completeTypeAndInitializer(Tree type, ExpressionTree initializer) {
        this.initializer = initializer;
        return this.completeType(type);
    }

    public VariableTreeImpl completeIdentifierAndDims(IdentifierTreeImpl simpleName, int dims) {
        this.simpleName = simpleName;
        this.dims = dims;
        return this;
    }

    public int dims() {
        return this.dims;
    }

    public void setVararg(boolean vararg) {
        this.vararg = vararg;
    }

    public boolean isVararg() {
        return this.vararg;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.VARIABLE;
    }

    @Override
    public ModifiersTree modifiers() {
        return this.modifiers;
    }

    @Override
    public Tree type() {
        return this.type;
    }

    @Override
    public IdentifierTree simpleName() {
        return this.simpleName;
    }

    @Override
    @Nullable
    public ExpressionTree initializer() {
        return this.initializer;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitVariable(this);
    }

    public Symbol.VariableSymbol getSymbol() {
        return this.symbol;
    }

    public void setSymbol(Symbol.VariableSymbol symbol) {
        Preconditions.checkState((this.symbol == null ? 1 : 0) != 0);
        this.symbol = symbol;
    }

    @Override
    public int getLine() {
        return ((IdentifierTreeImpl)this.simpleName()).getLine();
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.modifiers, this.type, this.simpleName, this.initializer});
    }
}

