/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class ArrayAccessExpressionTreeImpl
extends AbstractTypedTree
implements ArrayAccessExpressionTree {
    private ExpressionTree expression;
    private final InternalSyntaxToken openBracketToken;
    private final ExpressionTree index;
    private final InternalSyntaxToken closeBracketToken;

    public ArrayAccessExpressionTreeImpl(ExpressionTree expression, InternalSyntaxToken openBracketToken, ExpressionTree index, InternalSyntaxToken closeBracketToken) {
        this(openBracketToken, index, closeBracketToken);
        this.complete(expression);
    }

    public ArrayAccessExpressionTreeImpl(InternalSyntaxToken openBracketToken, ExpressionTree index, InternalSyntaxToken closeBracketToken) {
        super(Tree.Kind.ARRAY_ACCESS_EXPRESSION);
        this.openBracketToken = openBracketToken;
        this.index = index;
        this.closeBracketToken = closeBracketToken;
        this.addChild(openBracketToken);
        this.addChild((AstNode)index);
        this.addChild(closeBracketToken);
    }

    public ArrayAccessExpressionTreeImpl complete(ExpressionTree expression) {
        this.expression = expression;
        this.prependChildren((AstNode)expression);
        return this;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.ARRAY_ACCESS_EXPRESSION;
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public SyntaxToken openBracketToken() {
        return this.openBracketToken;
    }

    @Override
    public ExpressionTree index() {
        return this.index;
    }

    @Override
    public SyntaxToken closeBracketToken() {
        return this.closeBracketToken;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitArrayAccessExpression(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.expression, this.index});
    }
}

