/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class BinaryExpressionTreeImpl
extends AbstractTypedTree
implements BinaryExpressionTree {
    private final Tree.Kind kind;
    private final ExpressionTree leftOperand;
    private final InternalSyntaxToken operator;
    private final ExpressionTree rightOperand;

    public BinaryExpressionTreeImpl(Tree.Kind kind, ExpressionTree leftOperand, InternalSyntaxToken operator, ExpressionTree rightOperand) {
        super(kind);
        this.kind = (Tree.Kind)((Object)Preconditions.checkNotNull((Object)((Object)kind)));
        this.leftOperand = (ExpressionTree)Preconditions.checkNotNull((Object)leftOperand);
        this.operator = operator;
        this.rightOperand = (ExpressionTree)Preconditions.checkNotNull((Object)rightOperand);
        this.addChild((AstNode)leftOperand);
        this.addChild(operator);
        this.addChild((AstNode)rightOperand);
    }

    public BinaryExpressionTreeImpl(AstNode astNode, ExpressionTree leftOperand, Tree.Kind kind, ExpressionTree rightOperand) {
        super(astNode);
        this.kind = (Tree.Kind)((Object)Preconditions.checkNotNull((Object)((Object)kind)));
        this.leftOperand = (ExpressionTree)Preconditions.checkNotNull((Object)leftOperand);
        this.operator = InternalSyntaxToken.createLegacy(super.getAstNode());
        this.rightOperand = (ExpressionTree)Preconditions.checkNotNull((Object)rightOperand);
    }

    @Override
    public ExpressionTree leftOperand() {
        return this.leftOperand;
    }

    @Override
    public SyntaxToken operatorToken() {
        return this.operator;
    }

    @Override
    public ExpressionTree rightOperand() {
        return this.rightOperand;
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitBinaryExpression(this);
    }

    @Override
    public AstNode getAstNode() {
        if (this.isLegacy()) {
            return super.getAstNode().getParent();
        }
        return super.getAstNode();
    }

    @Override
    public int getLine() {
        return this.getAstNode().getTokenLine();
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.leftOperand, this.rightOperand});
    }
}

