/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class ConditionalExpressionTreeImpl
extends AbstractTypedTree
implements ConditionalExpressionTree {
    private ExpressionTree condition;
    private final InternalSyntaxToken queryToken;
    private final ExpressionTree trueExpression;
    private final InternalSyntaxToken colonToken;
    private final ExpressionTree falseExpression;

    public ConditionalExpressionTreeImpl(InternalSyntaxToken queryToken, ExpressionTree trueExpression, InternalSyntaxToken colonToken, ExpressionTree falseExpression) {
        super(Tree.Kind.CONDITIONAL_EXPRESSION);
        this.queryToken = queryToken;
        this.trueExpression = (ExpressionTree)Preconditions.checkNotNull((Object)trueExpression);
        this.colonToken = colonToken;
        this.falseExpression = (ExpressionTree)Preconditions.checkNotNull((Object)falseExpression);
        this.addChild(queryToken);
        this.addChild((AstNode)trueExpression);
        this.addChild(colonToken);
        this.addChild((AstNode)falseExpression);
    }

    public ConditionalExpressionTreeImpl complete(ExpressionTree condition) {
        Preconditions.checkState((this.condition == null ? 1 : 0) != 0);
        this.condition = condition;
        this.prependChildren((AstNode)condition);
        return this;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.CONDITIONAL_EXPRESSION;
    }

    @Override
    public ExpressionTree condition() {
        return this.condition;
    }

    @Override
    public SyntaxToken questionToken() {
        return this.queryToken;
    }

    @Override
    public ExpressionTree trueExpression() {
        return this.trueExpression;
    }

    @Override
    public SyntaxToken colonToken() {
        return this.colonToken;
    }

    @Override
    public ExpressionTree falseExpression() {
        return this.falseExpression;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitConditionalExpression(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.condition, this.trueExpression, this.falseExpression});
    }
}

