/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import com.google.common.base.Preconditions;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import java.util.List;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class IdentifierTreeImpl
extends AbstractTypedTree
implements IdentifierTree {
    private final InternalSyntaxToken nameToken;

    public IdentifierTreeImpl(InternalSyntaxToken nameToken) {
        super(Tree.Kind.IDENTIFIER, nameToken.getToken());
        this.nameToken = (InternalSyntaxToken)Preconditions.checkNotNull((Object)nameToken);
        this.addChild(nameToken);
    }

    public IdentifierTreeImpl(InternalSyntaxToken nameToken, List<AstNode> children) {
        super(Tree.Kind.IDENTIFIER, nameToken.getToken());
        this.nameToken = (InternalSyntaxToken)Preconditions.checkNotNull((Object)nameToken);
        for (AstNode child : children) {
            this.addChild(child);
        }
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.IDENTIFIER;
    }

    @Override
    public SyntaxToken identifierToken() {
        return this.nameToken;
    }

    @Override
    public String name() {
        return this.identifierToken().text();
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitIdentifier(this);
    }

    public String toString() {
        return this.name();
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        throw new UnsupportedOperationException();
    }
}

