/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeArguments;

public class MethodInvocationTreeImpl
extends AbstractTypedTree
implements MethodInvocationTree {
    private final ExpressionTree methodSelect;
    private final List<ExpressionTree> arguments;
    @Nullable
    private TypeArguments typeArguments;

    public MethodInvocationTreeImpl(ExpressionTree methodSelect, @Nullable TypeArguments typeArguments, List<ExpressionTree> arguments, AstNode ... children) {
        super(Tree.Kind.METHOD_INVOCATION);
        this.methodSelect = (ExpressionTree)Preconditions.checkNotNull((Object)methodSelect);
        this.typeArguments = typeArguments;
        this.arguments = (List)Preconditions.checkNotNull(arguments);
        for (AstNode child : children) {
            this.addChild(child);
        }
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.METHOD_INVOCATION;
    }

    @Override
    public TypeArguments typeArguments() {
        return this.typeArguments;
    }

    @Override
    public ExpressionTree methodSelect() {
        return this.methodSelect;
    }

    @Override
    public SyntaxToken openParenToken() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ExpressionTree> arguments() {
        return this.arguments;
    }

    @Override
    public SyntaxToken closeParenToken() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitMethodInvocation(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.methodSelect), (Iterator)Iterators.singletonIterator((Object)this.typeArguments), this.arguments.iterator());
    }
}

