/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.AssertStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class AssertStatementTreeImpl
extends JavaTree
implements AssertStatementTree {
    private ExpressionTree condition;
    @Nullable
    private final ExpressionTree detail;

    public AssertStatementTreeImpl(ExpressionTree condition, AstNode assertToken, AstNode expression, AstNode semicolonToken) {
        super(Tree.Kind.ASSERT_STATEMENT);
        this.condition = (ExpressionTree)Preconditions.checkNotNull((Object)condition);
        this.detail = null;
        this.addChild(assertToken);
        this.addChild(expression);
        this.addChild(semicolonToken);
    }

    public AssertStatementTreeImpl(ExpressionTree detail, AstNode colonToken, AstNode expression) {
        super(Tree.Kind.ASSERT_STATEMENT);
        this.detail = (ExpressionTree)Preconditions.checkNotNull((Object)detail);
        this.addChild(colonToken);
        this.addChild(expression);
    }

    public AssertStatementTreeImpl complete(ExpressionTree condition, AstNode assertToken, AstNode expression, AstNode semicolonToken) {
        this.condition = (ExpressionTree)Preconditions.checkNotNull((Object)condition);
        this.prependChildren(assertToken, expression);
        this.addChild(semicolonToken);
        return this;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.ASSERT_STATEMENT;
    }

    @Override
    public SyntaxToken assertKeyword() {
        return InternalSyntaxToken.createLegacy(this.getAstNode().getFirstChild(new AstNodeType[]{JavaKeyword.ASSERT}));
    }

    @Override
    public ExpressionTree condition() {
        return this.condition;
    }

    @Override
    @Nullable
    public SyntaxToken colonToken() {
        return this.detail == null ? null : InternalSyntaxToken.createLegacy(this.getAstNode().getFirstChild(new AstNodeType[]{JavaPunctuator.COLON}));
    }

    @Override
    @Nullable
    public ExpressionTree detail() {
        return this.detail;
    }

    @Override
    public SyntaxToken semicolonToken() {
        return InternalSyntaxToken.createLegacy(this.getAstNode().getFirstChild(new AstNodeType[]{JavaPunctuator.SEMI}));
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitAssertStatement(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.condition, this.detail});
    }
}

