/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class IfStatementTreeImpl
extends JavaTree
implements IfStatementTree {
    private InternalSyntaxToken ifKeyword;
    private InternalSyntaxToken openParenToken;
    private ExpressionTree condition;
    private InternalSyntaxToken closeParenToken;
    private StatementTree thenStatement;
    @Nullable
    private final InternalSyntaxToken elseKeyword;
    @Nullable
    private final StatementTree elseStatement;

    public IfStatementTreeImpl(InternalSyntaxToken elseKeyword, StatementTree elseStatement, AstNode ... children) {
        super(Tree.Kind.IF_STATEMENT);
        this.elseKeyword = elseKeyword;
        this.elseStatement = (StatementTree)Preconditions.checkNotNull((Object)elseStatement);
        for (AstNode child : children) {
            this.addChild(child);
        }
    }

    public IfStatementTreeImpl(InternalSyntaxToken ifKeyword, InternalSyntaxToken openParenToken, ExpressionTree condition, InternalSyntaxToken closeParenToken, StatementTree thenStatement, AstNode ... children) {
        super(Tree.Kind.IF_STATEMENT);
        this.ifKeyword = ifKeyword;
        this.openParenToken = openParenToken;
        this.condition = (ExpressionTree)Preconditions.checkNotNull((Object)condition);
        this.closeParenToken = closeParenToken;
        this.thenStatement = (StatementTree)Preconditions.checkNotNull((Object)thenStatement);
        this.elseStatement = null;
        this.elseKeyword = null;
        for (AstNode child : children) {
            this.addChild(child);
        }
    }

    public IfStatementTreeImpl complete(InternalSyntaxToken ifKeyword, InternalSyntaxToken openParenToken, ExpressionTree condition, InternalSyntaxToken closeParenToken, StatementTree thenStatement, AstNode ... children) {
        Preconditions.checkState((this.condition == null ? 1 : 0) != 0, (Object)"Already completed");
        this.ifKeyword = ifKeyword;
        this.openParenToken = openParenToken;
        this.condition = (ExpressionTree)Preconditions.checkNotNull((Object)condition);
        this.closeParenToken = closeParenToken;
        this.thenStatement = (StatementTree)Preconditions.checkNotNull((Object)thenStatement);
        this.prependChildren(children);
        return this;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.IF_STATEMENT;
    }

    @Override
    public SyntaxToken ifKeyword() {
        return this.ifKeyword;
    }

    @Override
    public SyntaxToken openParenToken() {
        return this.openParenToken;
    }

    @Override
    public ExpressionTree condition() {
        return this.condition;
    }

    @Override
    public SyntaxToken closeParenToken() {
        return this.closeParenToken;
    }

    @Override
    public StatementTree thenStatement() {
        return this.thenStatement;
    }

    @Override
    @Nullable
    public SyntaxToken elseKeyword() {
        return this.elseKeyword;
    }

    @Override
    @Nullable
    public StatementTree elseStatement() {
        return this.elseStatement;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitIfStatement(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.condition, this.thenStatement, this.elseStatement});
    }
}

