/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class ThrowStatementTreeImpl
extends JavaTree
implements ThrowStatementTree {
    private final ExpressionTree expression;

    public ThrowStatementTreeImpl(ExpressionTree expression, AstNode ... children) {
        super(Tree.Kind.THROW_STATEMENT);
        this.expression = (ExpressionTree)Preconditions.checkNotNull((Object)expression);
        for (AstNode child : children) {
            this.addChild(child);
        }
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.THROW_STATEMENT;
    }

    @Override
    public SyntaxToken throwKeyword() {
        return InternalSyntaxToken.createLegacy(this.getAstNode().getFirstChild(new AstNodeType[]{JavaKeyword.THROW}));
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public SyntaxToken semicolonToken() {
        return InternalSyntaxToken.createLegacy(this.getAstNode().getFirstChild(new AstNodeType[]{JavaPunctuator.SEMI}));
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitThrowStatement(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.singletonIterator((Object)this.expression);
    }
}

