/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.BatchExtension;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.source.Highlightable;
import org.sonar.api.source.Symbolizable;
import org.sonar.java.JavaClasspath;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannersFactory;

public class SonarComponents
implements BatchExtension {
    private final FileLinesContextFactory fileLinesContextFactory;
    private final ResourcePerspectives resourcePerspectives;
    private final JavaFileScannersFactory[] fileScannersFactories;
    private final JavaClasspath javaClasspath;
    private final Project project;

    public SonarComponents(FileLinesContextFactory fileLinesContextFactory, ResourcePerspectives resourcePerspectives, Project project, JavaClasspath javaClasspath) {
        this(fileLinesContextFactory, resourcePerspectives, project, javaClasspath, null);
    }

    public SonarComponents(FileLinesContextFactory fileLinesContextFactory, ResourcePerspectives resourcePerspectives, Project project, JavaClasspath javaClasspath, @Nullable JavaFileScannersFactory[] fileScannersFactories) {
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.resourcePerspectives = resourcePerspectives;
        this.project = project;
        this.javaClasspath = javaClasspath;
        this.fileScannersFactories = fileScannersFactories;
    }

    public Iterable<JavaFileScanner> createJavaFileScanners() {
        Object result = ImmutableList.of();
        if (this.fileScannersFactories != null) {
            for (JavaFileScannersFactory factory : this.fileScannersFactories) {
                result = Iterables.concat((Iterable)result, factory.createJavaFileScanners());
            }
        }
        return result;
    }

    public Resource resourceFromIOFile(File file) {
        return org.sonar.api.resources.File.fromIOFile((File)file, (Project)this.project);
    }

    public FileLinesContext fileLinesContextFor(File file) {
        return this.fileLinesContextFactory.createFor(this.resourceFromIOFile(file));
    }

    public Symbolizable symbolizableFor(File file) {
        return (Symbolizable)this.resourcePerspectives.as(Symbolizable.class, this.resourceFromIOFile(file));
    }

    public Highlightable highlightableFor(File file) {
        return (Highlightable)this.resourcePerspectives.as(Highlightable.class, this.resourceFromIOFile(file));
    }

    public List<File> getJavaClasspath() {
        if (this.javaClasspath == null) {
            return Lists.newArrayList();
        }
        return this.javaClasspath.getElements();
    }

    public ResourcePerspectives getResourcePerspectives() {
        return this.resourcePerspectives;
    }
}

