/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.parser;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.ArgumentListTreeImpl;
import org.sonar.java.ast.parser.BlockStatementListTreeImpl;
import org.sonar.java.ast.parser.BoundListTreeImpl;
import org.sonar.java.ast.parser.FormalParametersListTreeImpl;
import org.sonar.java.ast.parser.JavaLexer;
import org.sonar.java.ast.parser.LambdaParameterListTreeImpl;
import org.sonar.java.ast.parser.QualifiedIdentifierListTreeImpl;
import org.sonar.java.ast.parser.ResourceListTreeImpl;
import org.sonar.java.ast.parser.StatementExpressionListTreeImpl;
import org.sonar.java.ast.parser.TypeParameterListTreeImpl;
import org.sonar.java.ast.parser.TypeUnionListTreeImpl;
import org.sonar.java.ast.parser.VariableDeclaratorListTreeImpl;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.KindMaps;
import org.sonar.java.model.TypeParameterTreeImpl;
import org.sonar.java.model.declaration.AnnotationTreeImpl;
import org.sonar.java.model.declaration.ClassTreeImpl;
import org.sonar.java.model.declaration.EnumConstantTreeImpl;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.java.model.declaration.ModifierKeywordTreeImpl;
import org.sonar.java.model.declaration.ModifiersTreeImpl;
import org.sonar.java.model.declaration.VariableTreeImpl;
import org.sonar.java.model.expression.ArrayAccessExpressionTreeImpl;
import org.sonar.java.model.expression.AssignmentExpressionTreeImpl;
import org.sonar.java.model.expression.BinaryExpressionTreeImpl;
import org.sonar.java.model.expression.ConditionalExpressionTreeImpl;
import org.sonar.java.model.expression.IdentifierTreeImpl;
import org.sonar.java.model.expression.InstanceOfTreeImpl;
import org.sonar.java.model.expression.InternalPostfixUnaryExpression;
import org.sonar.java.model.expression.InternalPrefixUnaryExpression;
import org.sonar.java.model.expression.LambdaExpressionTreeImpl;
import org.sonar.java.model.expression.LiteralTreeImpl;
import org.sonar.java.model.expression.MemberSelectExpressionTreeImpl;
import org.sonar.java.model.expression.MethodInvocationTreeImpl;
import org.sonar.java.model.expression.MethodReferenceTreeImpl;
import org.sonar.java.model.expression.NewArrayTreeImpl;
import org.sonar.java.model.expression.NewClassTreeImpl;
import org.sonar.java.model.expression.ParenthesizedTreeImpl;
import org.sonar.java.model.expression.TypeArgumentListTreeImpl;
import org.sonar.java.model.expression.TypeCastExpressionTreeImpl;
import org.sonar.java.model.statement.AssertStatementTreeImpl;
import org.sonar.java.model.statement.BlockTreeImpl;
import org.sonar.java.model.statement.BreakStatementTreeImpl;
import org.sonar.java.model.statement.CaseGroupTreeImpl;
import org.sonar.java.model.statement.CaseLabelTreeImpl;
import org.sonar.java.model.statement.CatchTreeImpl;
import org.sonar.java.model.statement.ContinueStatementTreeImpl;
import org.sonar.java.model.statement.DoWhileStatementTreeImpl;
import org.sonar.java.model.statement.EmptyStatementTreeImpl;
import org.sonar.java.model.statement.ExpressionStatementTreeImpl;
import org.sonar.java.model.statement.ForEachStatementImpl;
import org.sonar.java.model.statement.ForStatementTreeImpl;
import org.sonar.java.model.statement.IfStatementTreeImpl;
import org.sonar.java.model.statement.LabeledStatementTreeImpl;
import org.sonar.java.model.statement.ReturnStatementTreeImpl;
import org.sonar.java.model.statement.SwitchStatementTreeImpl;
import org.sonar.java.model.statement.SynchronizedStatementTreeImpl;
import org.sonar.java.model.statement.ThrowStatementTreeImpl;
import org.sonar.java.model.statement.TryStatementTreeImpl;
import org.sonar.java.model.statement.WhileStatementTreeImpl;
import org.sonar.java.parser.sslr.Optional;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ModifierTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeArguments;
import org.sonar.plugins.java.api.tree.VariableTree;

public class TreeFactory {
    private final KindMaps kindMaps = new KindMaps();
    public static final AstNodeType WRAPPER_AST_NODE = new AstNodeType(){

        public String toString() {
            return "WRAPPER_AST_NODE";
        }
    };

    public ModifiersTreeImpl modifiers(Optional<List<ModifierTree>> modifierNodes) {
        if (!modifierNodes.isPresent()) {
            return ModifiersTreeImpl.emptyModifiers();
        }
        return new ModifiersTreeImpl(modifierNodes.get());
    }

    public ModifierKeywordTreeImpl modifierKeyword(AstNode astNode) {
        JavaKeyword keyword = (JavaKeyword)astNode.getType();
        return new ModifierKeywordTreeImpl(this.kindMaps.getModifier(keyword), astNode);
    }

    public ExpressionTree literal(AstNode astNode) {
        InternalSyntaxToken token = InternalSyntaxToken.create(astNode);
        return new LiteralTreeImpl(this.kindMaps.getLiteral(astNode.getType()), token);
    }

    public JavaTree.CompilationUnitTreeImpl newCompilationUnit(AstNode spacing, Optional<ExpressionTree> packageDeclaration, Optional<List<JavaTree.ImportTreeImpl>> importDeclarations, Optional<List<AstNode>> typeDeclarations, AstNode eof) {
        ArrayList children = Lists.newArrayList();
        children.add(spacing);
        ImmutableList.Builder packageAnnotations = ImmutableList.builder();
        if (packageDeclaration.isPresent()) {
            children.add((AstNode)packageDeclaration.get());
            for (AstNode child : ((AstNode)packageDeclaration.get()).getChildren()) {
                if (!child.is(new AstNodeType[]{Tree.Kind.ANNOTATION})) continue;
                packageAnnotations.add((Object)((AnnotationTree)child));
            }
        }
        if (importDeclarations.isPresent()) {
            children.addAll((Collection)importDeclarations.get());
        }
        ImmutableList.Builder types = ImmutableList.builder();
        if (typeDeclarations.isPresent()) {
            children.addAll((Collection)typeDeclarations.get());
            for (AstNode child : typeDeclarations.get()) {
                if (child.is(new AstNodeType[]{JavaPunctuator.SEMI})) continue;
                types.add((Object)((Tree)child));
            }
        }
        children.add(eof);
        return new JavaTree.CompilationUnitTreeImpl(packageDeclaration.orNull(), importDeclarations.or((List<JavaTree.ImportTreeImpl>)ImmutableList.of()), (List<Tree>)types.build(), (List<AnnotationTree>)packageAnnotations.build(), children);
    }

    public ExpressionTree newPackageDeclaration(Optional<List<AnnotationTreeImpl>> annotations, AstNode packageTokenAstNode, ExpressionTree qualifiedIdentifier, AstNode semicolonTokenAstNode) {
        JavaTree partial = (JavaTree)((Object)qualifiedIdentifier);
        ArrayList children = Lists.newArrayList();
        if (annotations.isPresent()) {
            children.addAll((Collection)annotations.get());
        }
        children.add(packageTokenAstNode);
        partial.prependChildren(children);
        partial.addChild(semicolonTokenAstNode);
        return (ExpressionTree)((Object)partial);
    }

    public JavaTree.ImportTreeImpl newImportDeclaration(AstNode importTokenAstNode, Optional<AstNode> staticTokenAstNode, ExpressionTree qualifiedIdentifier, Optional<Tuple<AstNode, AstNode>> dotStar, AstNode semicolonTokenAstNode) {
        ExpressionTree target = qualifiedIdentifier;
        if (dotStar.isPresent()) {
            IdentifierTreeImpl identifier = new IdentifierTreeImpl(InternalSyntaxToken.create(dotStar.get().second()));
            target = new MemberSelectExpressionTreeImpl(qualifiedIdentifier, (IdentifierTree)identifier, (AstNode)qualifiedIdentifier, dotStar.get().first(), identifier);
        }
        InternalSyntaxToken importToken = InternalSyntaxToken.create(importTokenAstNode);
        InternalSyntaxToken staticToken = null;
        if (staticTokenAstNode.isPresent()) {
            staticToken = InternalSyntaxToken.create(staticTokenAstNode.get());
        }
        InternalSyntaxToken semiColonToken = InternalSyntaxToken.create(semicolonTokenAstNode);
        return new JavaTree.ImportTreeImpl(importToken, staticToken, target, semiColonToken);
    }

    public ClassTreeImpl newTypeDeclaration(ModifiersTreeImpl modifiers, ClassTreeImpl partial) {
        partial.prependChildren(new AstNode[]{modifiers});
        return partial.completeModifiers(modifiers);
    }

    public ExpressionTree newType(ExpressionTree basicOrClassType, Optional<List<AstNode>> dims) {
        if (!dims.isPresent()) {
            return basicOrClassType;
        }
        ExpressionTree result = basicOrClassType;
        for (AstNode dim : dims.get()) {
            ArrayList children = Lists.newArrayList();
            children.add((AstNode)result);
            children.addAll(dim.getChildren());
            result = new JavaTree.ArrayTypeTreeImpl(result, children);
        }
        return result;
    }

    public TypeArgumentListTreeImpl newTypeArgumentList(AstNode openBracketTokenAstNode, Tree typeArgument, Optional<List<AstNode>> rests, AstNode closeBracketTokenAstNode) {
        InternalSyntaxToken openBracketToken = InternalSyntaxToken.create(openBracketTokenAstNode);
        InternalSyntaxToken closeBracketToken = InternalSyntaxToken.create(closeBracketTokenAstNode);
        ImmutableList.Builder typeArguments = ImmutableList.builder();
        ArrayList children = Lists.newArrayList();
        typeArguments.add((Object)typeArgument);
        children.add((AstNode)typeArgument);
        if (rests.isPresent()) {
            for (AstNode rest : rests.get()) {
                for (AstNode child : rest.getChildren()) {
                    if (!child.is(new AstNodeType[]{JavaPunctuator.COMMA})) {
                        typeArguments.add((Object)((Tree)child));
                    }
                    children.add(child);
                }
            }
        }
        return new TypeArgumentListTreeImpl(openBracketToken, (List<Tree>)typeArguments.build(), children, closeBracketToken);
    }

    public TypeArgumentListTreeImpl newDiamondTypeArgument(AstNode openBracketTokenAstNode, AstNode closeBracketTokenAstNode) {
        InternalSyntaxToken openBracketToken = InternalSyntaxToken.create(openBracketTokenAstNode);
        InternalSyntaxToken closeBracketToken = InternalSyntaxToken.create(closeBracketTokenAstNode);
        return new TypeArgumentListTreeImpl(openBracketToken, (List<Tree>)ImmutableList.of(), (List<AstNode>)ImmutableList.of(), closeBracketToken);
    }

    public Tree completeTypeArgument(Optional<List<AnnotationTreeImpl>> annotations, Tree partial) {
        if (annotations.isPresent()) {
            ((JavaTree)partial).prependChildren(annotations.get());
        }
        return partial;
    }

    public ExpressionTree newBasicTypeArgument(ExpressionTree type) {
        return type;
    }

    public JavaTree.WildcardTreeImpl completeWildcardTypeArgument(AstNode queryTokenAstNode, Optional<JavaTree.WildcardTreeImpl> partial) {
        InternalSyntaxToken queryToken = InternalSyntaxToken.create(queryTokenAstNode);
        return partial.isPresent() ? partial.get().complete(queryToken) : new JavaTree.WildcardTreeImpl(Tree.Kind.UNBOUNDED_WILDCARD, queryToken);
    }

    public JavaTree.WildcardTreeImpl newWildcardTypeArguments(AstNode extendsOrSuperTokenAstNode, Optional<List<AnnotationTreeImpl>> annotations, ExpressionTree type) {
        InternalSyntaxToken extendsOrSuperToken = InternalSyntaxToken.create(extendsOrSuperTokenAstNode);
        return new JavaTree.WildcardTreeImpl(JavaKeyword.EXTENDS.getValue().equals(extendsOrSuperToken.text()) ? Tree.Kind.EXTENDS_WILDCARD : Tree.Kind.SUPER_WILDCARD, extendsOrSuperToken, annotations.isPresent() ? annotations.get() : ImmutableList.of(), type);
    }

    public TypeParameterListTreeImpl newTypeParameterList(AstNode openBracketTokenAstNode, TypeParameterTreeImpl typeParameter, Optional<List<AstNode>> rests, AstNode closeBracketTokenAstNode) {
        InternalSyntaxToken openBracketToken = InternalSyntaxToken.create(openBracketTokenAstNode);
        InternalSyntaxToken closeBracketToken = InternalSyntaxToken.create(closeBracketTokenAstNode);
        ImmutableList.Builder typeParameters = ImmutableList.builder();
        ArrayList children = Lists.newArrayList();
        typeParameters.add((Object)typeParameter);
        children.add(typeParameter);
        if (rests.isPresent()) {
            for (AstNode rest : rests.get()) {
                for (AstNode child : rest.getChildren()) {
                    if (!child.is(new AstNodeType[]{JavaPunctuator.COMMA})) {
                        typeParameters.add((Object)((TypeParameterTreeImpl)child));
                    }
                    children.add(child);
                }
            }
        }
        return new TypeParameterListTreeImpl(openBracketToken, (List<TypeParameterTreeImpl>)typeParameters.build(), children, closeBracketToken);
    }

    public TypeParameterTreeImpl completeTypeParameter(Optional<List<AnnotationTreeImpl>> annotations, AstNode identifierAstNode, Optional<TypeParameterTreeImpl> partial) {
        IdentifierTreeImpl identifier = new IdentifierTreeImpl(InternalSyntaxToken.create(identifierAstNode));
        if (annotations.isPresent()) {
            identifier.prependChildren(annotations.get());
        }
        return partial.isPresent() ? partial.get().complete(identifier) : new TypeParameterTreeImpl(identifier);
    }

    public TypeParameterTreeImpl newTypeParameter(AstNode extendsTokenAstNode, BoundListTreeImpl bounds) {
        return new TypeParameterTreeImpl(InternalSyntaxToken.create(extendsTokenAstNode), bounds);
    }

    public BoundListTreeImpl newBounds(ExpressionTree classType, Optional<List<AstNode>> rests) {
        ImmutableList.Builder classTypes = ImmutableList.builder();
        ArrayList children = Lists.newArrayList();
        classTypes.add((Object)classType);
        children.add((AstNode)classType);
        if (rests.isPresent()) {
            for (AstNode rest : rests.get()) {
                for (AstNode child : rest.getChildren()) {
                    if (!child.is(new AstNodeType[]{JavaPunctuator.AND})) {
                        classTypes.add((Object)((Tree)child));
                    }
                    children.add(child);
                }
            }
        }
        return new BoundListTreeImpl((List<Tree>)classTypes.build(), children);
    }

    public ClassTreeImpl completeClassDeclaration(AstNode classTokenAstNode, AstNode identifierAstNode, Optional<TypeParameterListTreeImpl> typeParameters, Optional<Tuple<AstNode, ExpressionTree>> extendsClause, Optional<Tuple<AstNode, QualifiedIdentifierListTreeImpl>> implementsClause, ClassTreeImpl partial) {
        IdentifierTreeImpl identifier = new IdentifierTreeImpl(InternalSyntaxToken.create(identifierAstNode));
        ArrayList children = Lists.newArrayList();
        children.add(classTokenAstNode);
        children.add(identifier);
        partial.completeIdentifier(identifier);
        if (typeParameters.isPresent()) {
            children.add(typeParameters.get());
            partial.completeTypeParameters(typeParameters.get());
        }
        if (extendsClause.isPresent()) {
            children.add(extendsClause.get().first());
            children.add((AstNode)extendsClause.get().second());
            partial.completeSuperclass(extendsClause.get().second());
        }
        if (implementsClause.isPresent()) {
            children.add(implementsClause.get().first());
            children.add(implementsClause.get().second());
            partial.completeInterfaces(implementsClause.get().second());
        }
        partial.prependChildren(children);
        return partial;
    }

    private ClassTreeImpl newClassBody(Tree.Kind kind, AstNode openBraceTokenAstNode, Optional<List<AstNode>> members, AstNode closeBraceTokenAstNode) {
        ArrayList children = Lists.newArrayList();
        ImmutableList.Builder builder = ImmutableList.builder();
        children.add(openBraceTokenAstNode);
        if (members.isPresent()) {
            for (AstNode member : members.get()) {
                children.add(member);
                if (member instanceof VariableDeclaratorListTreeImpl) {
                    for (VariableTreeImpl variable : (VariableDeclaratorListTreeImpl)member) {
                        builder.add((Object)variable);
                    }
                    continue;
                }
                if (!(member instanceof Tree)) continue;
                builder.add((Object)((Tree)member));
            }
        }
        children.add(closeBraceTokenAstNode);
        return new ClassTreeImpl(kind, (List<Tree>)builder.build(), (List<AstNode>)children);
    }

    public ClassTreeImpl newClassBody(AstNode openBraceTokenAstNode, Optional<List<AstNode>> members, AstNode closeBraceTokenAstNode) {
        return this.newClassBody(Tree.Kind.CLASS, openBraceTokenAstNode, members, closeBraceTokenAstNode);
    }

    public ClassTreeImpl newEnumDeclaration(AstNode enumTokenAstNode, AstNode identifierAstNode, Optional<Tuple<AstNode, QualifiedIdentifierListTreeImpl>> implementsClause, AstNode openBraceTokenAstNode, Optional<List<EnumConstantTreeImpl>> enumConstants, Optional<AstNode> semicolonTokenAstNode, Optional<List<AstNode>> enumDeclarations, AstNode closeBraceTokenAstNode) {
        ImmutableList.Builder members = ImmutableList.builder();
        if (enumConstants.isPresent()) {
            for (EnumConstantTreeImpl enumConstant : enumConstants.get()) {
                members.add((Object)enumConstant);
            }
        }
        if (semicolonTokenAstNode.isPresent()) {
            members.add((Object)semicolonTokenAstNode.get());
        }
        if (enumDeclarations.isPresent()) {
            for (AstNode enumDeclaration : enumDeclarations.get()) {
                members.add((Object)enumDeclaration);
            }
        }
        ClassTreeImpl result = this.newClassBody(Tree.Kind.ENUM, openBraceTokenAstNode, Optional.of(members.build()), closeBraceTokenAstNode);
        ArrayList children = Lists.newArrayList();
        children.add(enumTokenAstNode);
        IdentifierTreeImpl identifier = new IdentifierTreeImpl(InternalSyntaxToken.create(identifierAstNode));
        result.completeIdentifier(identifier);
        children.add(identifier);
        if (implementsClause.isPresent()) {
            children.add(implementsClause.get().first());
            children.add(implementsClause.get().second());
            result.completeInterfaces(implementsClause.get().second());
        }
        result.prependChildren(children);
        return result;
    }

    public EnumConstantTreeImpl newEnumConstant(Optional<List<AnnotationTreeImpl>> annotations, AstNode identifierAstNode, Optional<ArgumentListTreeImpl> arguments, Optional<ClassTreeImpl> classBody, Optional<AstNode> semicolonTokenAstNode) {
        IdentifierTreeImpl identifier = new IdentifierTreeImpl(InternalSyntaxToken.create(identifierAstNode));
        if (annotations.isPresent()) {
            identifier.prependChildren(annotations.get());
        }
        ArrayList children = Lists.newArrayList();
        if (arguments.isPresent()) {
            children.add(arguments.get());
        }
        if (classBody.isPresent()) {
            children.add(classBody.get());
        }
        NewClassTreeImpl newClass = new NewClassTreeImpl(arguments.isPresent() ? (List)arguments.get() : Collections.emptyList(), classBody.isPresent() ? classBody.get() : null, children.toArray(new AstNode[0]));
        newClass.completeWithIdentifier(identifier);
        EnumConstantTreeImpl result = new EnumConstantTreeImpl(ModifiersTreeImpl.EMPTY, identifier, newClass);
        result.addChild(identifier);
        result.addChild(newClass);
        if (semicolonTokenAstNode.isPresent()) {
            result.addChild(semicolonTokenAstNode.get());
        }
        return result;
    }

    public ClassTreeImpl completeInterfaceDeclaration(AstNode interfaceTokenAstNode, AstNode identifierAstNode, Optional<TypeParameterListTreeImpl> typeParameters, Optional<Tuple<AstNode, QualifiedIdentifierListTreeImpl>> extendsClause, ClassTreeImpl partial) {
        IdentifierTreeImpl identifier = new IdentifierTreeImpl(InternalSyntaxToken.create(identifierAstNode));
        ArrayList children = Lists.newArrayList();
        children.add(interfaceTokenAstNode);
        children.add(identifier);
        partial.completeIdentifier(identifier);
        if (typeParameters.isPresent()) {
            children.add(typeParameters.get());
            partial.completeTypeParameters(typeParameters.get());
        }
        if (extendsClause.isPresent()) {
            children.add(extendsClause.get().first());
            children.add(extendsClause.get().second());
            partial.completeInterfaces(extendsClause.get().second());
        }
        partial.prependChildren(children);
        return partial;
    }

    public ClassTreeImpl newInterfaceBody(AstNode openBraceTokenAstNode, Optional<List<AstNode>> members, AstNode closeBraceTokenAstNode) {
        return this.newClassBody(Tree.Kind.INTERFACE, openBraceTokenAstNode, members, closeBraceTokenAstNode);
    }

    public AstNode completeMember(ModifiersTreeImpl modifiers, JavaTree partial) {
        if (partial instanceof ClassTreeImpl) {
            ((ClassTreeImpl)partial).completeModifiers(modifiers);
            partial.prependChildren(new AstNode[]{modifiers});
        } else if (partial instanceof VariableDeclaratorListTreeImpl) {
            for (VariableTreeImpl variable : (VariableDeclaratorListTreeImpl)partial) {
                variable.completeModifiers(modifiers);
            }
            partial.prependChildren(new AstNode[]{modifiers});
        } else if (partial instanceof MethodTreeImpl) {
            ((MethodTreeImpl)partial).completeWithModifiers(modifiers);
        } else {
            throw new IllegalArgumentException();
        }
        return partial;
    }

    public BlockTreeImpl newInitializerMember(Optional<AstNode> staticTokenAstNode, BlockTreeImpl block) {
        Tree.Kind kind = staticTokenAstNode.isPresent() ? Tree.Kind.STATIC_INITIALIZER : Tree.Kind.INITIALIZER;
        ArrayList children = Lists.newArrayList();
        if (staticTokenAstNode.isPresent()) {
            children.add(staticTokenAstNode.get());
        }
        children.addAll(block.getChildren());
        return new BlockTreeImpl(kind, (InternalSyntaxToken)block.openBraceToken(), block.body(), (InternalSyntaxToken)block.closeBraceToken(), children.toArray(new AstNode[0]));
    }

    public AstNode newEmptyMember(AstNode semicolonTokenAstNode) {
        return semicolonTokenAstNode;
    }

    public MethodTreeImpl completeGenericMethodOrConstructorDeclaration(TypeParameterListTreeImpl typeParameters, MethodTreeImpl partial) {
        partial.prependChildren(new AstNode[]{typeParameters});
        return partial.completeWithTypeParameters(typeParameters);
    }

    private MethodTreeImpl newMethodOrConstructor(Optional<ExpressionTree> type, AstNode identifierAstNode, FormalParametersListTreeImpl parameters, Optional<List<Tuple<Optional<List<AnnotationTreeImpl>>, Tuple<AstNode, AstNode>>>> annotatedDimensions, Optional<Tuple<AstNode, QualifiedIdentifierListTreeImpl>> throwsClause, AstNode blockOrSemicolon) {
        IdentifierTreeImpl identifier = new IdentifierTreeImpl(InternalSyntaxToken.create(identifierAstNode));
        ExpressionTree actualType = type.isPresent() ? this.applyDim(type.get(), annotatedDimensions.isPresent() ? annotatedDimensions.get().size() : 0) : null;
        MethodTreeImpl result = new MethodTreeImpl(actualType, identifier, parameters, throwsClause.isPresent() ? (List)throwsClause.get().second() : ImmutableList.of(), blockOrSemicolon.is(new AstNodeType[]{Tree.Kind.BLOCK}) ? (BlockTreeImpl)blockOrSemicolon : null);
        ArrayList children = Lists.newArrayList();
        if (type.isPresent()) {
            children.add((AstNode)type.get());
        }
        children.add(identifier);
        children.add(parameters);
        if (annotatedDimensions.isPresent()) {
            for (Tuple<Optional<List<AnnotationTreeImpl>>, Tuple<AstNode, AstNode>> annotatedDimension : annotatedDimensions.get()) {
                if (annotatedDimension.first().isPresent()) {
                    for (AnnotationTreeImpl annotation : annotatedDimension.first().get()) {
                        children.add(annotation);
                    }
                }
                children.add(annotatedDimension.second());
            }
        }
        if (throwsClause.isPresent()) {
            children.add(throwsClause.get().first());
            children.add(throwsClause.get().second());
        }
        children.add(blockOrSemicolon);
        result.prependChildren(children);
        return result;
    }

    public MethodTreeImpl newMethod(ExpressionTree type, AstNode identifierAstNode, FormalParametersListTreeImpl parameters, Optional<List<Tuple<Optional<List<AnnotationTreeImpl>>, Tuple<AstNode, AstNode>>>> annotatedDimensions, Optional<Tuple<AstNode, QualifiedIdentifierListTreeImpl>> throwsClause, AstNode blockOrSemicolon) {
        return this.newMethodOrConstructor(Optional.of(type), identifierAstNode, parameters, annotatedDimensions, throwsClause, blockOrSemicolon);
    }

    public MethodTreeImpl newConstructor(AstNode identifierAstNode, FormalParametersListTreeImpl parameters, Optional<List<Tuple<Optional<List<AnnotationTreeImpl>>, Tuple<AstNode, AstNode>>>> annotatedDimensions, Optional<Tuple<AstNode, QualifiedIdentifierListTreeImpl>> throwsClause, AstNode blockOrSemicolon) {
        return this.newMethodOrConstructor(Optional.<ExpressionTree>absent(), identifierAstNode, parameters, annotatedDimensions, throwsClause, blockOrSemicolon);
    }

    public VariableDeclaratorListTreeImpl completeFieldDeclaration(ExpressionTree type, VariableDeclaratorListTreeImpl partial, AstNode semicolonTokenAstNode) {
        partial.prependChildren((AstNode)type);
        for (VariableTreeImpl variable : partial) {
            variable.completeType(type);
        }
        partial.addChild(semicolonTokenAstNode);
        return partial;
    }

    public ClassTreeImpl completeAnnotationType(AstNode atTokenAstNode, AstNode interfaceTokenAstNode, AstNode identifier, ClassTreeImpl partial) {
        return partial.complete(InternalSyntaxToken.create(atTokenAstNode), InternalSyntaxToken.create(interfaceTokenAstNode), new IdentifierTreeImpl(InternalSyntaxToken.create(identifier)));
    }

    public ClassTreeImpl newAnnotationType(AstNode openBraceTokenAstNode, Optional<List<AstNode>> annotationTypeElementDeclarations, AstNode closeBraceTokenAstNode) {
        InternalSyntaxToken openBraceToken = InternalSyntaxToken.create(openBraceTokenAstNode);
        InternalSyntaxToken closeBraceToken = InternalSyntaxToken.create(closeBraceTokenAstNode);
        ModifiersTreeImpl emptyModifiers = ModifiersTreeImpl.emptyModifiers();
        ImmutableList.Builder members = ImmutableList.builder();
        ArrayList children = Lists.newArrayList();
        children.add(openBraceToken);
        if (annotationTypeElementDeclarations.isPresent()) {
            for (AstNode annotationTypeElementDeclaration : annotationTypeElementDeclarations.get()) {
                children.add(annotationTypeElementDeclaration);
                if (annotationTypeElementDeclaration.is(new AstNodeType[]{JavaLexer.VARIABLE_DECLARATORS})) {
                    for (VariableTreeImpl variable : (VariableDeclaratorListTreeImpl)annotationTypeElementDeclaration) {
                        members.add((Object)variable);
                    }
                    continue;
                }
                if (annotationTypeElementDeclaration.is(new AstNodeType[]{JavaPunctuator.SEMI})) continue;
                members.add((Object)((Tree)annotationTypeElementDeclaration));
            }
        }
        children.add(closeBraceToken);
        return new ClassTreeImpl(emptyModifiers, (List<Tree>)members.build(), (List<AstNode>)children);
    }

    public AstNode completeAnnotationTypeMember(ModifiersTreeImpl modifiers, AstNode partialAstNode) {
        JavaTree partial = (JavaTree)partialAstNode;
        partial.prependChildren(new AstNode[]{modifiers});
        if (partial.is(new AstNodeType[]{JavaLexer.VARIABLE_DECLARATORS})) {
            for (VariableTreeImpl variable : (VariableDeclaratorListTreeImpl)partial) {
                variable.completeModifiers(modifiers);
            }
        } else if (partial.is(Tree.Kind.CLASS) || partial.is(Tree.Kind.INTERFACE) || partial.is(Tree.Kind.ENUM) || partial.is(Tree.Kind.ANNOTATION_TYPE)) {
            ((ClassTreeImpl)partial).completeModifiers(modifiers);
        } else if (partial.is(Tree.Kind.METHOD)) {
            ((MethodTreeImpl)partial).completeWithModifiers(modifiers);
        } else {
            throw new IllegalArgumentException("Unsupported type: " + partial);
        }
        return partial;
    }

    public AstNode completeAnnotationMethod(ExpressionTree type, AstNode identifierAstNode, MethodTreeImpl partial, AstNode semiTokenAstNode) {
        partial.complete(type, new IdentifierTreeImpl(InternalSyntaxToken.create(identifierAstNode)));
        partial.addChild(semiTokenAstNode);
        return partial;
    }

    public MethodTreeImpl newAnnotationTypeMethod(AstNode openParenTokenAstNode, AstNode closeParenTokenAstNode, Optional<Tuple<InternalSyntaxToken, ExpressionTree>> defaultValue) {
        InternalSyntaxToken openParenToken = InternalSyntaxToken.create(openParenTokenAstNode);
        InternalSyntaxToken closeParenToken = InternalSyntaxToken.create(closeParenTokenAstNode);
        FormalParametersListTreeImpl parameters = new FormalParametersListTreeImpl(openParenToken, closeParenToken);
        InternalSyntaxToken defaultToken = null;
        ExpressionTree defaultExpression = null;
        if (defaultValue.isPresent()) {
            defaultToken = defaultValue.get().first();
            defaultExpression = defaultValue.get().second();
        }
        return new MethodTreeImpl(parameters, defaultToken, defaultExpression);
    }

    public Tuple<InternalSyntaxToken, ExpressionTree> newDefaultValue(AstNode defaultTokenAstNode, ExpressionTree elementValue) {
        InternalSyntaxToken defaultToken = InternalSyntaxToken.create(defaultTokenAstNode);
        return new Tuple<InternalSyntaxToken, ExpressionTree>(defaultToken, elementValue);
    }

    public AnnotationTreeImpl newAnnotation(AstNode atTokenAstNode, ExpressionTree qualifiedIdentifier, Optional<ArgumentListTreeImpl> arguments) {
        InternalSyntaxToken atToken = InternalSyntaxToken.create(atTokenAstNode);
        return new AnnotationTreeImpl(atToken, (Tree)qualifiedIdentifier, arguments.isPresent() ? arguments.get() : null);
    }

    public ArgumentListTreeImpl completeNormalAnnotation(AstNode openParenTokenAstNode, Optional<ArgumentListTreeImpl> partial, AstNode closeParenTokenAstNode) {
        InternalSyntaxToken openParenToken = InternalSyntaxToken.create(openParenTokenAstNode);
        InternalSyntaxToken closeParenToken = InternalSyntaxToken.create(closeParenTokenAstNode);
        if (!partial.isPresent()) {
            return new ArgumentListTreeImpl(openParenToken, closeParenToken);
        }
        ArgumentListTreeImpl elementValuePairs = partial.get();
        elementValuePairs.prependChildren(openParenToken);
        elementValuePairs.addChild(closeParenToken);
        return elementValuePairs;
    }

    public ArgumentListTreeImpl newNormalAnnotation(AssignmentExpressionTreeImpl elementValuePair, Optional<List<AstNode>> rests) {
        ImmutableList.Builder expressions = ImmutableList.builder();
        ArrayList children = Lists.newArrayList();
        expressions.add((Object)elementValuePair);
        children.add(elementValuePair);
        if (rests.isPresent()) {
            for (AstNode rest : rests.get()) {
                for (AstNode child : rest.getChildren()) {
                    if (!child.is(new AstNodeType[]{JavaPunctuator.COMMA})) {
                        expressions.add((Object)((ExpressionTree)child));
                    }
                    children.add(child);
                }
            }
        }
        return new ArgumentListTreeImpl((List<ExpressionTree>)expressions.build(), children);
    }

    public AssignmentExpressionTreeImpl newElementValuePair(AstNode identifierAstNode, AstNode equalTokenAstNode, ExpressionTree elementValue) {
        InternalSyntaxToken operator = InternalSyntaxToken.create(equalTokenAstNode);
        return new AssignmentExpressionTreeImpl(this.kindMaps.getAssignmentOperator((JavaPunctuator)operator.getType()), (ExpressionTree)new IdentifierTreeImpl(InternalSyntaxToken.create(identifierAstNode)), operator, elementValue);
    }

    public NewArrayTreeImpl completeElementValueArrayInitializer(AstNode openBraceTokenAstNode, Optional<NewArrayTreeImpl> partial, Optional<AstNode> commaTokenAstNode, AstNode closeBraceTokenAstNode) {
        InternalSyntaxToken openBraceToken = InternalSyntaxToken.create(openBraceTokenAstNode);
        InternalSyntaxToken commaToken = commaTokenAstNode.isPresent() ? InternalSyntaxToken.create(commaTokenAstNode.get()) : null;
        InternalSyntaxToken closeBraceToken = InternalSyntaxToken.create(closeBraceTokenAstNode);
        NewArrayTreeImpl elementValues = partial.isPresent() ? partial.get() : new NewArrayTreeImpl((List<ExpressionTree>)ImmutableList.of(), (List<ExpressionTree>)ImmutableList.of(), (List<AstNode>)ImmutableList.of());
        elementValues.prependChildren(openBraceToken);
        if (commaToken != null) {
            elementValues.addChild(commaToken);
        }
        elementValues.addChild(closeBraceToken);
        return elementValues;
    }

    public NewArrayTreeImpl newElementValueArrayInitializer(ExpressionTree elementValue, Optional<List<AstNode>> rests) {
        ImmutableList.Builder expressions = ImmutableList.builder();
        ArrayList children = Lists.newArrayList();
        expressions.add((Object)elementValue);
        children.add((AstNode)elementValue);
        if (rests.isPresent()) {
            for (AstNode rest : rests.get()) {
                for (AstNode child : rest.getChildren()) {
                    if (!child.is(new AstNodeType[]{JavaPunctuator.COMMA})) {
                        expressions.add((Object)((ExpressionTree)child));
                    }
                    children.add(child);
                }
            }
        }
        return new NewArrayTreeImpl((List<ExpressionTree>)ImmutableList.of(), (List<ExpressionTree>)expressions.build(), children);
    }

    public ArgumentListTreeImpl newSingleElementAnnotation(AstNode openParenTokenAstNode, ExpressionTree elementValue, AstNode closeParenTokenAstNode) {
        InternalSyntaxToken openParenToken = InternalSyntaxToken.create(openParenTokenAstNode);
        InternalSyntaxToken closeParenToken = InternalSyntaxToken.create(closeParenTokenAstNode);
        return new ArgumentListTreeImpl(openParenToken, elementValue, closeParenToken);
    }

    public FormalParametersListTreeImpl completeParenFormalParameters(AstNode openParenTokenAstNode, Optional<FormalParametersListTreeImpl> partial, AstNode closeParenTokenAstNode) {
        InternalSyntaxToken openParenToken = InternalSyntaxToken.create(openParenTokenAstNode);
        InternalSyntaxToken closeParenToken = InternalSyntaxToken.create(closeParenTokenAstNode);
        return partial.isPresent() ? partial.get().complete(openParenToken, closeParenToken) : new FormalParametersListTreeImpl(openParenToken, closeParenToken);
    }

    public FormalParametersListTreeImpl completeTypeFormalParameters(ModifiersTreeImpl modifiers, ExpressionTree type, FormalParametersListTreeImpl partial) {
        VariableTreeImpl variable = (VariableTreeImpl)partial.get(0);
        variable.completeModifiersAndType(modifiers, type);
        partial.prependChildren(modifiers, (AstNode)type);
        return partial;
    }

    public FormalParametersListTreeImpl prependNewFormalParameter(VariableTreeImpl variable, Optional<AstNode> rest) {
        if (rest.isPresent()) {
            AstNode comma = rest.get().getFirstChild(new AstNodeType[]{JavaPunctuator.COMMA});
            FormalParametersListTreeImpl partial = (FormalParametersListTreeImpl)rest.get().getLastChild();
            partial.add(0, variable);
            partial.prependChildren(variable, comma);
            return partial;
        }
        return new FormalParametersListTreeImpl(variable);
    }

    public FormalParametersListTreeImpl newVariableArgumentFormalParameter(Optional<List<AnnotationTreeImpl>> annotations, AstNode ellipsisTokenAstNode, VariableTreeImpl variable) {
        InternalSyntaxToken ellipsisToken = InternalSyntaxToken.create(ellipsisTokenAstNode);
        variable.setVararg(true);
        return new FormalParametersListTreeImpl(annotations.isPresent() ? annotations.get() : ImmutableList.of(), ellipsisToken, variable);
    }

    public VariableTreeImpl newVariableDeclaratorId(AstNode identifierAstNode, Optional<List<AstNode>> dims) {
        IdentifierTreeImpl identifier = new IdentifierTreeImpl(InternalSyntaxToken.create(identifierAstNode));
        return new VariableTreeImpl(identifier, dims.isPresent() ? dims.get().size() : 0, (List<AstNode>)(dims.isPresent() ? dims.get() : ImmutableList.of()));
    }

    public VariableTreeImpl newFormalParameter(ModifiersTreeImpl modifiers, ExpressionTree type, VariableTreeImpl variable) {
        variable.prependChildren(modifiers, (AstNode)type);
        return variable.completeType(type);
    }

    public VariableDeclaratorListTreeImpl completeLocalVariableDeclaration(ModifiersTreeImpl modifiers, ExpressionTree type, VariableDeclaratorListTreeImpl variables, AstNode semicolonTokenAstNode) {
        variables.prependChildren(modifiers, (AstNode)type);
        variables.addChild(semicolonTokenAstNode);
        for (VariableTreeImpl variable : variables) {
            variable.completeModifiersAndType(modifiers, type);
        }
        return variables;
    }

    public VariableDeclaratorListTreeImpl newVariableDeclarators(VariableTreeImpl variable, Optional<List<Tuple<AstNode, VariableTreeImpl>>> rests) {
        ImmutableList.Builder variables = ImmutableList.builder();
        variables.add((Object)variable);
        ArrayList children = Lists.newArrayList();
        children.add(variable);
        if (rests.isPresent()) {
            for (Tuple<AstNode, VariableTreeImpl> rest : rests.get()) {
                variables.add((Object)rest.second());
                children.add(rest.first());
                children.add(rest.second());
            }
        }
        return new VariableDeclaratorListTreeImpl((List<VariableTreeImpl>)variables.build(), children);
    }

    public VariableTreeImpl completeVariableDeclarator(AstNode identifierAstNode, Optional<List<Tuple<AstNode, AstNode>>> dimensions, Optional<VariableTreeImpl> partial) {
        IdentifierTreeImpl identifier = new IdentifierTreeImpl(InternalSyntaxToken.create(identifierAstNode));
        ArrayList children = Lists.newArrayList();
        if (dimensions.isPresent()) {
            for (Tuple<AstNode, AstNode> dimension : dimensions.get()) {
                children.add(dimension.first());
                children.add(dimension.second());
            }
        }
        if (partial.isPresent()) {
            children.add(0, identifier);
            partial.get().prependChildren(children);
            return partial.get().completeIdentifierAndDims(identifier, dimensions.isPresent() ? dimensions.get().size() : 0);
        }
        return new VariableTreeImpl(identifier, dimensions.isPresent() ? dimensions.get().size() : 0, children);
    }

    public VariableTreeImpl newVariableDeclarator(AstNode equalTokenAstNode, ExpressionTree initializer) {
        InternalSyntaxToken equalToken = InternalSyntaxToken.create(equalTokenAstNode);
        return new VariableTreeImpl(equalToken, initializer, equalToken, (AstNode)initializer);
    }

    public BlockTreeImpl block(AstNode openBraceTokenAstNode, BlockStatementListTreeImpl blockStatements, AstNode closeBraceTokenAstNode) {
        InternalSyntaxToken openBraceToken = InternalSyntaxToken.create(openBraceTokenAstNode);
        InternalSyntaxToken closeBraceToken = InternalSyntaxToken.create(closeBraceTokenAstNode);
        return new BlockTreeImpl(openBraceToken, blockStatements, closeBraceToken, openBraceToken, blockStatements, closeBraceToken);
    }

    public AssertStatementTreeImpl completeAssertStatement(AstNode assertToken, ExpressionTree expression, Optional<AssertStatementTreeImpl> detailExpression, AstNode semicolonToken) {
        return detailExpression.isPresent() ? detailExpression.get().complete(expression, assertToken, (AstNode)expression, semicolonToken) : new AssertStatementTreeImpl(expression, assertToken, (AstNode)expression, semicolonToken);
    }

    public AssertStatementTreeImpl newAssertStatement(AstNode colonToken, ExpressionTree expression) {
        return new AssertStatementTreeImpl(expression, colonToken, (AstNode)expression);
    }

    public IfStatementTreeImpl completeIf(AstNode ifToken, AstNode openParen, ExpressionTree condition, AstNode closeParen, StatementTree statement, Optional<IfStatementTreeImpl> elseClause) {
        InternalSyntaxToken ifKeyword = InternalSyntaxToken.create(ifToken);
        InternalSyntaxToken openParenToken = InternalSyntaxToken.create(openParen);
        InternalSyntaxToken closeParenToken = InternalSyntaxToken.create(closeParen);
        if (elseClause.isPresent()) {
            return elseClause.get().complete(ifKeyword, openParenToken, condition, closeParenToken, statement, ifKeyword, openParenToken, (AstNode)condition, closeParenToken, (AstNode)statement);
        }
        return new IfStatementTreeImpl(ifKeyword, openParenToken, condition, closeParenToken, statement, ifKeyword, openParenToken, (AstNode)condition, closeParenToken, (AstNode)statement);
    }

    public IfStatementTreeImpl newIfWithElse(AstNode elseToken, StatementTree elseStatement) {
        InternalSyntaxToken elseKeyword = InternalSyntaxToken.create(elseToken);
        return new IfStatementTreeImpl(elseKeyword, elseStatement, elseKeyword, (AstNode)elseStatement);
    }

    public ForStatementTreeImpl newStandardForStatement(AstNode forTokenAstNode, AstNode openParenTokenAstNode, Optional<StatementExpressionListTreeImpl> forInit, AstNode forInitSemicolonTokenAstNode, Optional<ExpressionTree> expression, AstNode expressionSemicolonTokenAstNode, Optional<StatementExpressionListTreeImpl> forUpdate, AstNode forUpdateSemicolonTokenAstNode, StatementTree statement) {
        StatementExpressionListTreeImpl forInit2 = forInit.isPresent() ? forInit.get() : new StatementExpressionListTreeImpl((List<? extends StatementTree>)ImmutableList.of());
        StatementExpressionListTreeImpl forUpdate2 = forUpdate.isPresent() ? forUpdate.get() : new StatementExpressionListTreeImpl((List<? extends StatementTree>)ImmutableList.of());
        ForStatementTreeImpl result = new ForStatementTreeImpl(forInit2, expression.isPresent() ? expression.get() : null, forUpdate2, statement);
        ArrayList children = Lists.newArrayList();
        children.add(forTokenAstNode);
        children.add(openParenTokenAstNode);
        children.add(forInit2);
        children.add(forInitSemicolonTokenAstNode);
        if (expression.isPresent()) {
            children.add((AstNode)expression.get());
        }
        children.add(expressionSemicolonTokenAstNode);
        children.add(forUpdate2);
        children.add(forUpdateSemicolonTokenAstNode);
        children.add((AstNode)statement);
        result.prependChildren(children);
        return result;
    }

    public StatementExpressionListTreeImpl newForInitDeclaration(ModifiersTreeImpl modifiers, ExpressionTree type, VariableDeclaratorListTreeImpl variables) {
        for (VariableTreeImpl variable : variables) {
            variable.completeModifiersAndType(modifiers, type);
        }
        StatementExpressionListTreeImpl result = new StatementExpressionListTreeImpl(variables);
        result.prependChildren(modifiers, (AstNode)type, variables);
        return result;
    }

    public StatementExpressionListTreeImpl newStatementExpressions(ExpressionTree expression, Optional<List<AstNode>> rests) {
        ArrayList children = Lists.newArrayList();
        ImmutableList.Builder statements = ImmutableList.builder();
        ExpressionStatementTreeImpl statement = new ExpressionStatementTreeImpl(expression, null, (AstNode)expression);
        statements.add((Object)statement);
        children.add(statement);
        if (rests.isPresent()) {
            for (AstNode rest : rests.get()) {
                children.add(rest.getFirstChild());
                statement = new ExpressionStatementTreeImpl((ExpressionTree)rest.getLastChild(), null, rest.getLastChild());
                statements.add((Object)statement);
                children.add(statement);
            }
        }
        StatementExpressionListTreeImpl result = new StatementExpressionListTreeImpl((List<? extends StatementTree>)statements.build());
        result.prependChildren(children);
        return result;
    }

    public ForEachStatementImpl newForeachStatement(AstNode forTokenAstNode, AstNode openParenTokenAstNode, VariableTreeImpl variable, AstNode colonTokenAstNode, ExpressionTree expression, AstNode closeParenTokenAstNode, StatementTree statement) {
        return new ForEachStatementImpl(variable, expression, statement, forTokenAstNode, openParenTokenAstNode, variable, colonTokenAstNode, (AstNode)expression, closeParenTokenAstNode, (AstNode)statement);
    }

    public WhileStatementTreeImpl whileStatement(AstNode whileToken, AstNode openParen, ExpressionTree expression, AstNode closeParen, StatementTree statement) {
        InternalSyntaxToken whileKeyword = InternalSyntaxToken.create(whileToken);
        InternalSyntaxToken openParenToken = InternalSyntaxToken.create(openParen);
        InternalSyntaxToken closeParenToken = InternalSyntaxToken.create(closeParen);
        return new WhileStatementTreeImpl(whileKeyword, openParenToken, expression, closeParenToken, statement, whileKeyword, openParenToken, (AstNode)expression, closeParenToken, (AstNode)statement);
    }

    public DoWhileStatementTreeImpl doWhileStatement(AstNode doToken, StatementTree statement, AstNode whileToken, AstNode openParen, ExpressionTree expression, AstNode closeParen, AstNode semicolon) {
        InternalSyntaxToken doKeyword = InternalSyntaxToken.create(doToken);
        InternalSyntaxToken whileKeyword = InternalSyntaxToken.create(whileToken);
        InternalSyntaxToken openParenToken = InternalSyntaxToken.create(openParen);
        InternalSyntaxToken closeParenToken = InternalSyntaxToken.create(closeParen);
        InternalSyntaxToken semiColonToken = InternalSyntaxToken.create(semicolon);
        return new DoWhileStatementTreeImpl(doKeyword, statement, whileKeyword, openParenToken, expression, closeParenToken, semiColonToken, doKeyword, (AstNode)statement, whileKeyword, openParenToken, (AstNode)expression, closeParenToken, semiColonToken);
    }

    public TryStatementTreeImpl completeStandardTryStatement(AstNode tryTokenAstNode, BlockTreeImpl block, TryStatementTreeImpl partial) {
        InternalSyntaxToken tryToken = InternalSyntaxToken.create(tryTokenAstNode);
        return partial.completeStandardTry(tryToken, block);
    }

    public TryStatementTreeImpl newTryCatch(Optional<List<CatchTreeImpl>> catches, Optional<BlockTreeImpl> finallyBlock) {
        return new TryStatementTreeImpl(catches.isPresent() ? catches.get() : ImmutableList.of(), finallyBlock.isPresent() ? finallyBlock.get() : null);
    }

    public TryStatementTreeImpl newTryFinally(BlockTreeImpl finallyBlock) {
        return new TryStatementTreeImpl(finallyBlock);
    }

    public CatchTreeImpl newCatchClause(AstNode catchTokenAstNode, AstNode openParenTokenAstNode, VariableTreeImpl parameter, AstNode closeParenTokenAstNode, BlockTreeImpl block) {
        InternalSyntaxToken catchToken = InternalSyntaxToken.create(catchTokenAstNode);
        InternalSyntaxToken openParenToken = InternalSyntaxToken.create(openParenTokenAstNode);
        InternalSyntaxToken closeParenToken = InternalSyntaxToken.create(closeParenTokenAstNode);
        return new CatchTreeImpl(catchToken, openParenToken, parameter, closeParenToken, block);
    }

    public VariableTreeImpl newCatchFormalParameter(Optional<ModifiersTreeImpl> modifiers, Tree type, VariableTreeImpl parameter) {
        if (modifiers.isPresent()) {
            parameter.prependChildren(modifiers.get(), (AstNode)type);
        } else {
            parameter.prependChildren((AstNode)type);
        }
        return parameter.completeType(type);
    }

    public Tree newCatchType(ExpressionTree qualifiedIdentifier, Optional<List<AstNode>> rests) {
        if (!rests.isPresent()) {
            return qualifiedIdentifier;
        }
        ArrayList children = Lists.newArrayList();
        ImmutableList.Builder types = ImmutableList.builder();
        children.add((AstNode)qualifiedIdentifier);
        types.add((Object)qualifiedIdentifier);
        for (AstNode rest : rests.get()) {
            children.add(rest.getFirstChild());
            ExpressionTree qualifiedIdentifier2 = (ExpressionTree)rest.getLastChild();
            types.add((Object)qualifiedIdentifier2);
            children.add((AstNode)qualifiedIdentifier2);
        }
        return new JavaTree.UnionTypeTreeImpl(new TypeUnionListTreeImpl((List<Tree>)types.build(), children));
    }

    public BlockTreeImpl newFinallyBlock(AstNode finallyTokenAstNode, BlockTreeImpl block) {
        InternalSyntaxToken finallyToken = InternalSyntaxToken.create(finallyTokenAstNode);
        block.prependChildren(finallyToken);
        return block;
    }

    public TryStatementTreeImpl newTryWithResourcesStatement(AstNode tryTokenAstNode, AstNode openParenTokenAstNode, ResourceListTreeImpl resources, AstNode closeParenTokenAstNode, BlockTreeImpl block, Optional<List<CatchTreeImpl>> catches, Optional<BlockTreeImpl> finallyBlock) {
        InternalSyntaxToken tryToken = InternalSyntaxToken.create(tryTokenAstNode);
        InternalSyntaxToken openParenToken = InternalSyntaxToken.create(openParenTokenAstNode);
        InternalSyntaxToken closeParenToken = InternalSyntaxToken.create(closeParenTokenAstNode);
        return new TryStatementTreeImpl(tryToken, openParenToken, resources, closeParenToken, block, catches.isPresent() ? catches.get() : ImmutableList.of(), finallyBlock.isPresent() ? finallyBlock.get() : null);
    }

    public ResourceListTreeImpl newResources(List<AstNode> rests) {
        ArrayList children = Lists.newArrayList();
        ImmutableList.Builder resources = ImmutableList.builder();
        for (AstNode rest : rests) {
            VariableTreeImpl resource = (VariableTreeImpl)rest.getFirstChild();
            children.add(resource);
            resources.add((Object)resource);
            if (rest.getNumberOfChildren() != 2) continue;
            children.add(rest.getLastChild());
        }
        return new ResourceListTreeImpl((List<VariableTreeImpl>)resources.build(), children);
    }

    public VariableTreeImpl newResource(ModifiersTreeImpl modifiers, ExpressionTree classType, VariableTreeImpl partial, AstNode equalTokenAstNode, ExpressionTree expression) {
        partial.prependChildren(modifiers, (AstNode)classType);
        partial.addChild(equalTokenAstNode);
        partial.addChild((AstNode)expression);
        return partial.completeTypeAndInitializer(classType, expression);
    }

    public SwitchStatementTreeImpl switchStatement(AstNode switchToken, AstNode openParen, ExpressionTree expression, AstNode closeParen, AstNode leftCurlyBraceToken, Optional<List<CaseGroupTreeImpl>> optionalGroups, AstNode rightCurlyBraceToken) {
        InternalSyntaxToken switchKeyword = InternalSyntaxToken.create(switchToken);
        InternalSyntaxToken openParenToken = InternalSyntaxToken.create(openParen);
        InternalSyntaxToken closeParenToken = InternalSyntaxToken.create(closeParen);
        InternalSyntaxToken openBraceToken = InternalSyntaxToken.create(leftCurlyBraceToken);
        InternalSyntaxToken closeBraceToken = InternalSyntaxToken.create(rightCurlyBraceToken);
        List<CaseGroupTreeImpl> groups = optionalGroups.isPresent() ? optionalGroups.get() : Collections.emptyList();
        ImmutableList.Builder children = ImmutableList.builder();
        children.add((Object[])new AstNode[]{switchKeyword, openParenToken, (AstNode)expression, closeParenToken, openBraceToken});
        children.addAll(groups);
        children.add((Object)closeBraceToken);
        return new SwitchStatementTreeImpl(switchKeyword, openParenToken, expression, closeParenToken, openBraceToken, groups, closeBraceToken, (List<AstNode>)children.build());
    }

    public CaseGroupTreeImpl switchGroup(List<CaseLabelTreeImpl> labels, BlockStatementListTreeImpl blockStatements) {
        return new CaseGroupTreeImpl(labels, blockStatements, blockStatements);
    }

    public CaseLabelTreeImpl newCaseSwitchLabel(AstNode caseToken, ExpressionTree expression, AstNode colonToken) {
        return new CaseLabelTreeImpl(expression, caseToken, (AstNode)expression, colonToken);
    }

    public CaseLabelTreeImpl newDefaultSwitchLabel(AstNode defaultToken, AstNode colonToken) {
        return new CaseLabelTreeImpl(null, defaultToken, colonToken);
    }

    public SynchronizedStatementTreeImpl synchronizedStatement(AstNode synchronizedToken, AstNode openParen, ExpressionTree expression, AstNode closeParen, BlockTreeImpl block) {
        InternalSyntaxToken synchronizedKeyword = InternalSyntaxToken.create(synchronizedToken);
        InternalSyntaxToken openParenToken = InternalSyntaxToken.create(openParen);
        InternalSyntaxToken closeParenToken = InternalSyntaxToken.create(closeParen);
        return new SynchronizedStatementTreeImpl(synchronizedKeyword, openParenToken, expression, closeParenToken, block, synchronizedKeyword, openParenToken, (AstNode)expression, closeParenToken, block);
    }

    public BreakStatementTreeImpl breakStatement(AstNode breakToken, Optional<AstNode> identifierAstNode, AstNode semicolonToken) {
        if (identifierAstNode.isPresent()) {
            IdentifierTreeImpl identifier = new IdentifierTreeImpl(InternalSyntaxToken.create(identifierAstNode.get()));
            return new BreakStatementTreeImpl(identifier, breakToken, identifier, semicolonToken);
        }
        return new BreakStatementTreeImpl(null, breakToken, semicolonToken);
    }

    public ContinueStatementTreeImpl continueStatement(AstNode continueToken, Optional<AstNode> identifierAstNode, AstNode semicolonToken) {
        if (identifierAstNode.isPresent()) {
            IdentifierTreeImpl identifier = new IdentifierTreeImpl(InternalSyntaxToken.create(identifierAstNode.get()));
            return new ContinueStatementTreeImpl(identifier, continueToken, identifier, semicolonToken);
        }
        return new ContinueStatementTreeImpl(null, continueToken, semicolonToken);
    }

    public ReturnStatementTreeImpl returnStatement(AstNode returnToken, Optional<ExpressionTree> expression, AstNode semicolonToken) {
        return expression.isPresent() ? new ReturnStatementTreeImpl(expression.get(), returnToken, (AstNode)expression.get(), semicolonToken) : new ReturnStatementTreeImpl(null, returnToken, semicolonToken);
    }

    public ThrowStatementTreeImpl throwStatement(AstNode throwToken, ExpressionTree expression, AstNode semicolonToken) {
        return new ThrowStatementTreeImpl(expression, throwToken, (AstNode)expression, semicolonToken);
    }

    public LabeledStatementTreeImpl labeledStatement(AstNode identifierAstNode, AstNode colon, StatementTree statement) {
        IdentifierTreeImpl identifier = new IdentifierTreeImpl(InternalSyntaxToken.create(identifierAstNode));
        return new LabeledStatementTreeImpl(identifier, statement, identifier, colon, (AstNode)statement);
    }

    public ExpressionStatementTreeImpl expressionStatement(ExpressionTree expression, AstNode semicolonTokenAstNode) {
        InternalSyntaxToken semicolonToken = InternalSyntaxToken.create(semicolonTokenAstNode);
        return new ExpressionStatementTreeImpl(expression, semicolonToken, (AstNode)expression, semicolonToken);
    }

    public EmptyStatementTreeImpl emptyStatement(AstNode semicolon) {
        return new EmptyStatementTreeImpl(semicolon);
    }

    public BlockStatementListTreeImpl blockStatements(Optional<List<BlockStatementListTreeImpl>> blockStatements) {
        ArrayList children = Lists.newArrayList();
        ImmutableList.Builder builder = ImmutableList.builder();
        if (blockStatements.isPresent()) {
            for (BlockStatementListTreeImpl blockStatement : blockStatements.get()) {
                children.add(blockStatement);
                builder.addAll((Iterable)blockStatement);
            }
        }
        return new BlockStatementListTreeImpl((List<? extends StatementTree>)builder.build(), children);
    }

    public BlockStatementListTreeImpl wrapInBlockStatements(VariableDeclaratorListTreeImpl variables) {
        return new BlockStatementListTreeImpl(variables, (List<AstNode>)ImmutableList.of((Object)variables));
    }

    public BlockStatementListTreeImpl newInnerClassOrEnum(ModifiersTreeImpl modifiers, ClassTreeImpl classTree) {
        classTree.prependChildren(new AstNode[]{modifiers});
        classTree.completeModifiers(modifiers);
        return new BlockStatementListTreeImpl((List<? extends StatementTree>)ImmutableList.of((Object)classTree), (List<AstNode>)ImmutableList.of((Object)classTree));
    }

    public BlockStatementListTreeImpl wrapInBlockStatements(StatementTree statement) {
        return new BlockStatementListTreeImpl((List<? extends StatementTree>)ImmutableList.of((Object)statement), (List<AstNode>)ImmutableList.of((Object)((AstNode)statement)));
    }

    public ExpressionTree assignmentExpression(ExpressionTree expression, Optional<List<OperatorAndOperand>> operatorAndOperands) {
        if (!operatorAndOperands.isPresent()) {
            return expression;
        }
        ExpressionTree result = null;
        InternalSyntaxToken lastOperator = null;
        for (OperatorAndOperand operatorAndOperand : Lists.reverse(operatorAndOperands.get())) {
            result = lastOperator == null ? operatorAndOperand.operand() : new AssignmentExpressionTreeImpl(this.kindMaps.getAssignmentOperator((JavaPunctuator)lastOperator.getType()), operatorAndOperand.operand(), lastOperator, result);
            lastOperator = operatorAndOperand.operator();
        }
        result = new AssignmentExpressionTreeImpl(this.kindMaps.getAssignmentOperator((JavaPunctuator)lastOperator.getType()), expression, lastOperator, result);
        return result;
    }

    public ExpressionTree completeTernaryExpression(ExpressionTree expression, Optional<ConditionalExpressionTreeImpl> partial) {
        return partial.isPresent() ? partial.get().complete(expression) : expression;
    }

    public ConditionalExpressionTreeImpl newTernaryExpression(AstNode queryTokenAstNode, ExpressionTree trueExpression, AstNode colonTokenAstNode, ExpressionTree falseExpression) {
        InternalSyntaxToken queryToken = InternalSyntaxToken.create(queryTokenAstNode);
        InternalSyntaxToken colonToken = InternalSyntaxToken.create(colonTokenAstNode);
        return new ConditionalExpressionTreeImpl(queryToken, trueExpression, colonToken, falseExpression);
    }

    public ExpressionTree completeInstanceofExpression(ExpressionTree expression, Optional<InstanceOfTreeImpl> partial) {
        return partial.isPresent() ? partial.get().complete(expression) : expression;
    }

    public InstanceOfTreeImpl newInstanceofExpression(AstNode instanceofTokenAstNode, Tree type) {
        InternalSyntaxToken instanceofToken = InternalSyntaxToken.create(instanceofTokenAstNode);
        return new InstanceOfTreeImpl(instanceofToken, type, (AstNode)type);
    }

    private ExpressionTree binaryExpression(ExpressionTree expression, Optional<List<OperatorAndOperand>> operatorAndOperands) {
        if (!operatorAndOperands.isPresent()) {
            return expression;
        }
        ExpressionTree result = expression;
        for (OperatorAndOperand operatorAndOperand : operatorAndOperands.get()) {
            result = new BinaryExpressionTreeImpl(this.kindMaps.getBinaryOperator((JavaPunctuator)operatorAndOperand.operator().getType()), result, operatorAndOperand.operator(), operatorAndOperand.operand());
        }
        return result;
    }

    private OperatorAndOperand newOperatorAndOperand(AstNode operator, ExpressionTree operand) {
        return new OperatorAndOperand(InternalSyntaxToken.create(operator), operand);
    }

    public OperatorAndOperand newOperatorAndOperand11(AstNode operator, ExpressionTree operand) {
        return this.newOperatorAndOperand(operator, operand);
    }

    public ExpressionTree binaryExpression10(ExpressionTree expression, Optional<List<OperatorAndOperand>> operatorAndOperands) {
        return this.binaryExpression(expression, operatorAndOperands);
    }

    public OperatorAndOperand newOperatorAndOperand10(AstNode operator, ExpressionTree operand) {
        return this.newOperatorAndOperand(operator, operand);
    }

    public ExpressionTree binaryExpression9(ExpressionTree expression, Optional<List<OperatorAndOperand>> operatorAndOperands) {
        return this.binaryExpression(expression, operatorAndOperands);
    }

    public OperatorAndOperand newOperatorAndOperand9(AstNode operator, ExpressionTree operand) {
        return this.newOperatorAndOperand(operator, operand);
    }

    public ExpressionTree binaryExpression8(ExpressionTree expression, Optional<List<OperatorAndOperand>> operatorAndOperands) {
        return this.binaryExpression(expression, operatorAndOperands);
    }

    public OperatorAndOperand newOperatorAndOperand8(AstNode operator, ExpressionTree operand) {
        return this.newOperatorAndOperand(operator, operand);
    }

    public ExpressionTree binaryExpression7(ExpressionTree expression, Optional<List<OperatorAndOperand>> operatorAndOperands) {
        return this.binaryExpression(expression, operatorAndOperands);
    }

    public OperatorAndOperand newOperatorAndOperand7(AstNode operator, ExpressionTree operand) {
        return this.newOperatorAndOperand(operator, operand);
    }

    public ExpressionTree binaryExpression6(ExpressionTree expression, Optional<List<OperatorAndOperand>> operatorAndOperands) {
        return this.binaryExpression(expression, operatorAndOperands);
    }

    public OperatorAndOperand newOperatorAndOperand6(AstNode operator, ExpressionTree operand) {
        return this.newOperatorAndOperand(operator, operand);
    }

    public ExpressionTree binaryExpression5(ExpressionTree expression, Optional<List<OperatorAndOperand>> operatorAndOperands) {
        return this.binaryExpression(expression, operatorAndOperands);
    }

    public OperatorAndOperand newOperatorAndOperand5(AstNode operator, ExpressionTree operand) {
        return this.newOperatorAndOperand(operator, operand);
    }

    public ExpressionTree binaryExpression4(ExpressionTree expression, Optional<List<OperatorAndOperand>> operatorAndOperands) {
        return this.binaryExpression(expression, operatorAndOperands);
    }

    public OperatorAndOperand newOperatorAndOperand4(AstNode operator, ExpressionTree operand) {
        return this.newOperatorAndOperand(operator, operand);
    }

    public ExpressionTree binaryExpression3(ExpressionTree expression, Optional<List<OperatorAndOperand>> operatorAndOperands) {
        return this.binaryExpression(expression, operatorAndOperands);
    }

    public OperatorAndOperand newOperatorAndOperand3(AstNode operator, ExpressionTree operand) {
        return this.newOperatorAndOperand(operator, operand);
    }

    public ExpressionTree binaryExpression2(ExpressionTree expression, Optional<List<OperatorAndOperand>> operatorAndOperands) {
        return this.binaryExpression(expression, operatorAndOperands);
    }

    public OperatorAndOperand newOperatorAndOperand2(AstNode operator, ExpressionTree operand) {
        return this.newOperatorAndOperand(operator, operand);
    }

    public ExpressionTree binaryExpression1(ExpressionTree expression, Optional<List<OperatorAndOperand>> operatorAndOperands) {
        return this.binaryExpression(expression, operatorAndOperands);
    }

    public OperatorAndOperand newOperatorAndOperand1(AstNode operator, ExpressionTree operand) {
        return this.newOperatorAndOperand(operator, operand);
    }

    public ExpressionTree newPrefixedExpression(AstNode operatorTokenAstNode, ExpressionTree expression) {
        InternalSyntaxToken operatorToken = InternalSyntaxToken.create(operatorTokenAstNode);
        return new InternalPrefixUnaryExpression(this.kindMaps.getPrefixOperator((JavaPunctuator)operatorTokenAstNode.getType()), operatorToken, expression);
    }

    public ExpressionTree newPostfixExpression(ExpressionTree expression, Optional<AstNode> postfixOperatorAstNode) {
        ExpressionTree result = expression;
        if (postfixOperatorAstNode.isPresent()) {
            InternalSyntaxToken postfixOperatorToken = InternalSyntaxToken.create(postfixOperatorAstNode.get());
            result = new InternalPostfixUnaryExpression(this.kindMaps.getPostfixOperator((JavaPunctuator)postfixOperatorAstNode.get().getType()), result, postfixOperatorToken);
        }
        return result;
    }

    public ExpressionTree newTildaExpression(AstNode tildaTokenAstNode, ExpressionTree expression) {
        InternalSyntaxToken operatorToken = InternalSyntaxToken.create(tildaTokenAstNode);
        return new InternalPrefixUnaryExpression(Tree.Kind.BITWISE_COMPLEMENT, operatorToken, expression);
    }

    public ExpressionTree newBangExpression(AstNode bangTokenAstNode, ExpressionTree expression) {
        InternalSyntaxToken operatorToken = InternalSyntaxToken.create(bangTokenAstNode);
        return new InternalPrefixUnaryExpression(Tree.Kind.LOGICAL_COMPLEMENT, operatorToken, expression);
    }

    public ExpressionTree completeCastExpression(AstNode openParenTokenAstNode, TypeCastExpressionTreeImpl partial) {
        return partial.complete(InternalSyntaxToken.create(openParenTokenAstNode));
    }

    public TypeCastExpressionTreeImpl newBasicTypeCastExpression(JavaTree.PrimitiveTypeTreeImpl basicType, AstNode closeParenTokenAstNode, ExpressionTree expression) {
        InternalSyntaxToken closeParenToken = InternalSyntaxToken.create(closeParenTokenAstNode);
        ArrayList children = Lists.newArrayList();
        children.add(basicType);
        children.add(closeParenToken);
        children.add((AstNode)expression);
        return new TypeCastExpressionTreeImpl(basicType, expression, closeParenToken, children);
    }

    public TypeCastExpressionTreeImpl newClassCastExpression(Tree type, Optional<List<AstNode>> classTypes, AstNode closeParenTokenAstNode, ExpressionTree expression) {
        InternalSyntaxToken closeParenToken = InternalSyntaxToken.create(closeParenTokenAstNode);
        ArrayList children = Lists.newArrayList();
        children.add((AstNode)type);
        if (classTypes.isPresent()) {
            for (AstNode classType : classTypes.get()) {
                children.addAll(classType.getChildren());
            }
        }
        children.add(closeParenToken);
        children.add((AstNode)expression);
        return new TypeCastExpressionTreeImpl(type, expression, closeParenToken, children);
    }

    public ExpressionTree completeMethodReference(MethodReferenceTreeImpl partial, Optional<TypeArgumentListTreeImpl> typeArguments, AstNode newOrIdentifierToken) {
        TypeArguments typeArgs = null;
        if (typeArguments.isPresent()) {
            typeArgs = typeArguments.get();
            partial.addChild((AstNode)typeArgs);
        }
        IdentifierTreeImpl identifier = new IdentifierTreeImpl(InternalSyntaxToken.create(newOrIdentifierToken));
        partial.addChild(newOrIdentifierToken);
        partial.complete(typeArgs, identifier);
        return partial;
    }

    public MethodReferenceTreeImpl newSuperMethodReference(AstNode superToken, AstNode doubleColonToken) {
        IdentifierTreeImpl superIdentifier = new IdentifierTreeImpl(InternalSyntaxToken.create(superToken));
        return new MethodReferenceTreeImpl(superIdentifier, InternalSyntaxToken.create(doubleColonToken), superToken, doubleColonToken);
    }

    public MethodReferenceTreeImpl newTypeMethodReference(Tree type, AstNode doubleColonToken) {
        return new MethodReferenceTreeImpl(type, InternalSyntaxToken.create(doubleColonToken), (AstNode)type, doubleColonToken);
    }

    public MethodReferenceTreeImpl newPrimaryMethodReference(ExpressionTree expression, AstNode doubleColonToken) {
        return new MethodReferenceTreeImpl(expression, InternalSyntaxToken.create(doubleColonToken), (AstNode)expression, doubleColonToken);
    }

    public ExpressionTree lambdaExpression(LambdaParameterListTreeImpl parameters, AstNode arrowToken, Tree body) {
        return new LambdaExpressionTreeImpl(parameters.openParenToken(), (List<VariableTree>)ImmutableList.builder().addAll((Iterable)parameters).build(), parameters.closeParenToken(), body, parameters, arrowToken, (AstNode)body);
    }

    public LambdaParameterListTreeImpl newInferedParameters(AstNode openParenTokenAstNode, Optional<Tuple<VariableTreeImpl, Optional<List<Tuple<AstNode, VariableTreeImpl>>>>> identifiersOpt, AstNode closeParenTokenAstNode) {
        InternalSyntaxToken openParenToken = InternalSyntaxToken.create(openParenTokenAstNode);
        InternalSyntaxToken closeParenToken = InternalSyntaxToken.create(closeParenTokenAstNode);
        ImmutableList.Builder params = ImmutableList.builder();
        ArrayList children = Lists.newArrayList();
        children.add(openParenToken);
        if (identifiersOpt.isPresent()) {
            Tuple<VariableTreeImpl, Optional<List<Tuple<AstNode, VariableTreeImpl>>>> identifiers = identifiersOpt.get();
            params.add((Object)identifiers.first());
            children.add(identifiers.first());
            if (identifiers.second().isPresent()) {
                for (Tuple<AstNode, VariableTreeImpl> identifier : identifiers.second().get()) {
                    params.add((Object)identifier.second());
                    children.add(identifier.first());
                    children.add(identifier.second());
                }
            }
        }
        children.add(closeParenToken);
        return new LambdaParameterListTreeImpl(openParenToken, (List<VariableTreeImpl>)params.build(), closeParenToken, children);
    }

    public LambdaParameterListTreeImpl formalLambdaParameters(FormalParametersListTreeImpl formalParameters) {
        return new LambdaParameterListTreeImpl(formalParameters.openParenToken(), formalParameters, formalParameters.closeParenToken(), formalParameters.getChildren());
    }

    public LambdaParameterListTreeImpl singleInferedParameter(VariableTreeImpl parameter) {
        return new LambdaParameterListTreeImpl(null, (List<VariableTreeImpl>)ImmutableList.of((Object)parameter), null, (List<AstNode>)ImmutableList.of((Object)parameter));
    }

    public VariableTreeImpl newSimpleParameter(AstNode identifierAstNode) {
        IdentifierTreeImpl identifier = new IdentifierTreeImpl(InternalSyntaxToken.create(identifierAstNode));
        return new VariableTreeImpl(identifier);
    }

    public ParenthesizedTreeImpl parenthesizedExpression(AstNode leftParenthesisToken, ExpressionTree expression, AstNode rightParenthesisToken) {
        return new ParenthesizedTreeImpl(expression, leftParenthesisToken, (AstNode)expression, rightParenthesisToken);
    }

    public ExpressionTree newExpression(AstNode newToken, Optional<List<AnnotationTreeImpl>> annotations, ExpressionTree partial) {
        if (annotations.isPresent()) {
            ((JavaTree)((Object)partial)).prependChildren(annotations.get());
        }
        ((JavaTree)((Object)partial)).prependChildren(newToken);
        return partial;
    }

    public ExpressionTree completeCreator(Optional<TypeArgumentListTreeImpl> typeArguments, ExpressionTree partial) {
        if (typeArguments.isPresent()) {
            ((JavaTree)((Object)partial)).prependChildren(new AstNode[]{typeArguments.get()});
        }
        return partial;
    }

    public ExpressionTree newClassCreator(ExpressionTree qualifiedIdentifier, NewClassTreeImpl classCreatorRest) {
        classCreatorRest.prependChildren((AstNode)qualifiedIdentifier);
        return classCreatorRest.completeWithIdentifier(qualifiedIdentifier);
    }

    public ExpressionTree newArrayCreator(Tree type, NewArrayTreeImpl partial) {
        return partial.complete(type, (AstNode)type);
    }

    public NewArrayTreeImpl completeArrayCreator(Optional<List<AnnotationTreeImpl>> annotations, NewArrayTreeImpl partial) {
        if (annotations.isPresent()) {
            partial.prependChildren(annotations.get());
        }
        return partial;
    }

    public NewArrayTreeImpl newArrayCreatorWithInitializer(AstNode openBracketToken, AstNode closeBracketToken, Optional<List<Tuple<AstNode, AstNode>>> dimensions, NewArrayTreeImpl partial) {
        ArrayList children = Lists.newArrayList();
        children.add(openBracketToken);
        children.add(closeBracketToken);
        if (dimensions.isPresent()) {
            for (Tuple<AstNode, AstNode> dimension : dimensions.get()) {
                children.add(dimension.first());
                children.add(dimension.second());
            }
        }
        partial.prependChildren(children);
        return partial;
    }

    public NewArrayTreeImpl newArrayCreatorWithDimension(AstNode openBracketToken, ExpressionTree expression, AstNode closeBracketToken, Optional<List<ArrayAccessExpressionTreeImpl>> arrayAccesses, Optional<List<AstNode>> dims) {
        ImmutableList.Builder dimensions = ImmutableList.builder();
        dimensions.add((Object)expression);
        if (arrayAccesses.isPresent()) {
            for (ArrayAccessExpressionTreeImpl arrayAccess : arrayAccesses.get()) {
                dimensions.add((Object)arrayAccess.index());
            }
        }
        ArrayList children = Lists.newArrayList();
        children.add(openBracketToken);
        children.add((AstNode)expression);
        children.add(closeBracketToken);
        if (arrayAccesses.isPresent()) {
            children.addAll((Collection)arrayAccesses.get());
        }
        if (dims.isPresent()) {
            children.addAll((Collection)dims.get());
        }
        return new NewArrayTreeImpl((List<ExpressionTree>)dimensions.build(), (List<ExpressionTree>)ImmutableList.of(), children);
    }

    public ExpressionTree basicClassExpression(JavaTree.PrimitiveTypeTreeImpl basicType, Optional<List<Tuple<AstNode, AstNode>>> dimensions, AstNode dotToken, AstNode classTokenAstNode) {
        IdentifierTreeImpl classToken = new IdentifierTreeImpl(InternalSyntaxToken.create(classTokenAstNode));
        ArrayList children = Lists.newArrayList();
        children.add(basicType);
        if (dimensions.isPresent()) {
            for (Tuple<AstNode, AstNode> dimension : dimensions.get()) {
                children.add(dimension.first());
                children.add(dimension.second());
            }
        }
        children.add(dotToken);
        children.add(classToken);
        return new MemberSelectExpressionTreeImpl(this.applyDim(basicType, dimensions.isPresent() ? dimensions.get().size() : 0), (IdentifierTree)classToken, children.toArray(new AstNode[children.size()]));
    }

    public ExpressionTree voidClassExpression(AstNode voidTokenAstNode, AstNode dotToken, AstNode classTokenAstNode) {
        InternalSyntaxToken voidToken = InternalSyntaxToken.create(voidTokenAstNode);
        JavaTree.PrimitiveTypeTreeImpl voidType = new JavaTree.PrimitiveTypeTreeImpl(voidToken, (List<AstNode>)ImmutableList.of((Object)voidToken));
        IdentifierTreeImpl classToken = new IdentifierTreeImpl(InternalSyntaxToken.create(classTokenAstNode));
        return new MemberSelectExpressionTreeImpl(voidType, (IdentifierTree)classToken, voidType, dotToken, classToken);
    }

    public JavaTree.PrimitiveTypeTreeImpl newBasicType(Optional<List<AnnotationTreeImpl>> annotations, AstNode basicType) {
        InternalSyntaxToken token = InternalSyntaxToken.create(basicType);
        ArrayList children = Lists.newArrayList();
        if (annotations.isPresent()) {
            children.addAll((Collection)annotations.get());
        }
        children.add(token);
        return new JavaTree.PrimitiveTypeTreeImpl(token, children);
    }

    public ArgumentListTreeImpl completeArguments(AstNode openParenthesisTokenAstNode, Optional<ArgumentListTreeImpl> expressions, AstNode closeParenthesisTokenAstNode) {
        InternalSyntaxToken openParenthesisToken = InternalSyntaxToken.create(openParenthesisTokenAstNode);
        InternalSyntaxToken closeParenthesisToken = InternalSyntaxToken.create(closeParenthesisTokenAstNode);
        return expressions.isPresent() ? expressions.get().complete(openParenthesisToken, closeParenthesisToken) : new ArgumentListTreeImpl(openParenthesisToken, closeParenthesisToken);
    }

    public ArgumentListTreeImpl newArguments(ExpressionTree expression, Optional<List<AstNode>> rests) {
        ArrayList children = Lists.newArrayList();
        ImmutableList.Builder expressions = ImmutableList.builder();
        children.add((AstNode)expression);
        expressions.add((Object)expression);
        if (rests.isPresent()) {
            for (AstNode rest : rests.get()) {
                children.addAll(rest.getChildren());
                expressions.add((Object)((ExpressionTree)rest.getLastChild()));
            }
        }
        return new ArgumentListTreeImpl((List<ExpressionTree>)expressions.build(), children);
    }

    public ExpressionTree annotationIdentifier(AstNode firstIdentifier, Optional<List<Tuple<AstNode, AstNode>>> rests) {
        ArrayList children = Lists.newArrayList();
        children.add(firstIdentifier);
        if (rests.isPresent()) {
            for (Tuple<AstNode, AstNode> rest : rests.get()) {
                children.add(rest.first());
                children.add(rest.second());
            }
        }
        AbstractTypedTree result = null;
        ArrayList pendingChildren = Lists.newArrayList();
        for (AstNode child : children) {
            if (!child.is(new AstNodeType[]{JavaTokenType.IDENTIFIER})) {
                pendingChildren.add(child);
                continue;
            }
            InternalSyntaxToken identifierToken = InternalSyntaxToken.create(child);
            if (result == null) {
                pendingChildren.add(identifierToken);
                result = new IdentifierTreeImpl(identifierToken, pendingChildren);
            } else {
                IdentifierTreeImpl identifier = new IdentifierTreeImpl(identifierToken);
                pendingChildren.add(0, result);
                pendingChildren.add(identifier);
                result = new MemberSelectExpressionTreeImpl((ExpressionTree)((Object)result), (IdentifierTree)identifier, pendingChildren.toArray(new AstNode[pendingChildren.size()]));
            }
            pendingChildren.clear();
        }
        return result;
    }

    public ExpressionTree newQualifiedIdentifier(ExpressionTree firstIdentifier, Optional<List<Tuple<AstNode, ExpressionTree>>> rests) {
        ExpressionTree result = firstIdentifier;
        if (rests.isPresent()) {
            for (Tuple<AstNode, ExpressionTree> rest : rests.get()) {
                if (rest.second().is(Tree.Kind.IDENTIFIER)) {
                    result = new MemberSelectExpressionTreeImpl(result, (IdentifierTree)((IdentifierTreeImpl)rest.second()), (AstNode)result, rest.first(), (AstNode)rest.second());
                    continue;
                }
                if (rest.second().is(Tree.Kind.PARAMETERIZED_TYPE)) {
                    JavaTree.ParameterizedTypeTreeImpl parameterizedType = (JavaTree.ParameterizedTypeTreeImpl)rest.second();
                    IdentifierTreeImpl identifier = (IdentifierTreeImpl)parameterizedType.type();
                    result = new MemberSelectExpressionTreeImpl(result, (IdentifierTree)identifier, (AstNode)result, rest.first(), identifier);
                    result = new JavaTree.ParameterizedTypeTreeImpl(result, (TypeArgumentListTreeImpl)parameterizedType.typeArguments());
                    continue;
                }
                throw new IllegalArgumentException();
            }
        }
        return result;
    }

    public ExpressionTree newAnnotatedParameterizedIdentifier(Optional<List<AnnotationTreeImpl>> annotations, AstNode identifierAstNode, Optional<TypeArgumentListTreeImpl> typeArguments) {
        AbstractTypedTree result = new IdentifierTreeImpl(InternalSyntaxToken.create(identifierAstNode));
        if (annotations.isPresent()) {
            ((JavaTree)result).prependChildren(annotations.get());
        }
        if (typeArguments.isPresent()) {
            result = new JavaTree.ParameterizedTypeTreeImpl((ExpressionTree)((Object)result), typeArguments.get());
        }
        return result;
    }

    public NewArrayTreeImpl newArrayInitializer(AstNode openBraceTokenAstNode, Optional<List<AstNode>> rests, AstNode closeBraceTokenAstNode) {
        ImmutableList.Builder initializers = ImmutableList.builder();
        ArrayList children = Lists.newArrayList();
        children.add(openBraceTokenAstNode);
        if (rests.isPresent()) {
            for (AstNode rest : rests.get()) {
                initializers.add((Object)((ExpressionTree)rest.getFirstChild()));
                children.add(rest.getFirstChild());
                if (rest.getNumberOfChildren() != 2) continue;
                children.add(rest.getLastChild());
            }
        }
        children.add(closeBraceTokenAstNode);
        return new NewArrayTreeImpl((List<ExpressionTree>)ImmutableList.of(), (List<ExpressionTree>)initializers.build(), children);
    }

    public QualifiedIdentifierListTreeImpl newQualifiedIdentifierList(ExpressionTree qualifiedIdentifier, Optional<List<Tuple<AstNode, ExpressionTree>>> rests) {
        ImmutableList.Builder qualifiedIdentifiers = ImmutableList.builder();
        ArrayList children = Lists.newArrayList();
        qualifiedIdentifiers.add((Object)qualifiedIdentifier);
        children.add((AstNode)qualifiedIdentifier);
        if (rests.isPresent()) {
            for (Tuple<AstNode, ExpressionTree> rest : rests.get()) {
                qualifiedIdentifiers.add((Object)rest.second());
                children.add(rest.first());
                children.add((AstNode)rest.second());
            }
        }
        return new QualifiedIdentifierListTreeImpl((List<? extends ExpressionTree>)qualifiedIdentifiers.build(), children);
    }

    public ArrayAccessExpressionTreeImpl newArrayAccessExpression(Optional<List<AnnotationTreeImpl>> annotations, AstNode openBracketTokenAstNode, ExpressionTree index, AstNode closeBracketTokenAstNode) {
        InternalSyntaxToken openBracketToken = InternalSyntaxToken.create(openBracketTokenAstNode);
        InternalSyntaxToken closeBracketToken = InternalSyntaxToken.create(closeBracketTokenAstNode);
        ArrayAccessExpressionTreeImpl result = new ArrayAccessExpressionTreeImpl(openBracketToken, index, closeBracketToken);
        if (annotations.isPresent()) {
            result.prependChildren(annotations.get());
        }
        return result;
    }

    public NewClassTreeImpl newClassCreatorRest(ArgumentListTreeImpl arguments, Optional<ClassTreeImpl> classBody) {
        ArrayList children = Lists.newArrayList();
        children.add(arguments);
        if (classBody.isPresent()) {
            children.add(classBody.get());
        }
        return new NewClassTreeImpl(arguments, classBody.isPresent() ? classBody.get() : null, children.toArray(new AstNode[0]));
    }

    public ExpressionTree newIdentifierOrMethodInvocation(Optional<TypeArgumentListTreeImpl> typeArguments, AstNode identifierAstNode, Optional<ArgumentListTreeImpl> arguments) {
        InternalSyntaxToken identifierToken = InternalSyntaxToken.create(identifierAstNode);
        IdentifierTreeImpl identifier = new IdentifierTreeImpl(identifierToken);
        if (typeArguments.isPresent()) {
            identifier.prependChildren(new AstNode[]{typeArguments.get()});
        }
        AbstractTypedTree result = identifier;
        if (arguments.isPresent()) {
            result = new MethodInvocationTreeImpl(identifier, typeArguments.orNull(), arguments.get(), identifier, arguments.get());
        }
        return result;
    }

    public ExpressionTree completeMemberSelectOrMethodSelector(AstNode dotTokenAstNode, ExpressionTree partial) {
        ((JavaTree)((Object)partial)).prependChildren(dotTokenAstNode);
        return partial;
    }

    public ExpressionTree completeCreatorSelector(AstNode dotTokenAstNode, ExpressionTree partial) {
        ((JavaTree)((Object)partial)).prependChildren(dotTokenAstNode);
        return partial;
    }

    public ExpressionTree newDotClassSelector(Optional<List<Tuple<AstNode, AstNode>>> dimensions, AstNode dotTokenAstNode, AstNode classTokenAstNode) {
        IdentifierTreeImpl identifier = new IdentifierTreeImpl(InternalSyntaxToken.create(classTokenAstNode));
        ArrayList children = Lists.newArrayList();
        if (dimensions.isPresent()) {
            for (Tuple<AstNode, AstNode> dimension : dimensions.get()) {
                children.add(dimension.first());
                children.add(dimension.second());
            }
        }
        children.add(dotTokenAstNode);
        children.add(identifier);
        return new MemberSelectExpressionTreeImpl(dimensions.isPresent() ? dimensions.get().size() : 0, identifier, children);
    }

    private ExpressionTree applySelectors(ExpressionTree primary, Optional<List<ExpressionTree>> selectors) {
        ExpressionTree result = primary;
        if (selectors.isPresent()) {
            for (ExpressionTree selector : selectors.get()) {
                if (selector.is(Tree.Kind.IDENTIFIER)) {
                    IdentifierTreeImpl identifier = (IdentifierTreeImpl)selector;
                    result = new MemberSelectExpressionTreeImpl(result, (IdentifierTree)identifier, (AstNode)result, identifier);
                    continue;
                }
                if (selector.is(Tree.Kind.METHOD_INVOCATION)) {
                    MethodInvocationTreeImpl methodInvocation = (MethodInvocationTreeImpl)selector;
                    IdentifierTreeImpl identifier = (IdentifierTreeImpl)methodInvocation.methodSelect();
                    MemberSelectExpressionTreeImpl memberSelect = new MemberSelectExpressionTreeImpl(result, (IdentifierTree)identifier, (AstNode)result, methodInvocation.getFirstChild(new AstNodeType[]{JavaPunctuator.DOT}), identifier);
                    ArrayList children = Lists.newArrayList();
                    children.add(memberSelect);
                    children.add((ArgumentListTreeImpl)methodInvocation.arguments());
                    result = new MethodInvocationTreeImpl(memberSelect, methodInvocation.typeArguments(), methodInvocation.arguments(), children.toArray(new AstNode[0]));
                    continue;
                }
                if (selector.is(Tree.Kind.NEW_CLASS)) {
                    NewClassTreeImpl newClass = (NewClassTreeImpl)selector;
                    newClass.prependChildren((AstNode)result);
                    result = newClass.completeWithEnclosingExpression(result);
                    continue;
                }
                if (selector.is(Tree.Kind.ARRAY_ACCESS_EXPRESSION)) {
                    ArrayAccessExpressionTreeImpl arrayAccess = (ArrayAccessExpressionTreeImpl)selector;
                    result = arrayAccess.complete(result);
                    continue;
                }
                if (selector.is(Tree.Kind.MEMBER_SELECT)) {
                    MemberSelectExpressionTreeImpl memberSelect = (MemberSelectExpressionTreeImpl)selector;
                    memberSelect.prependChildren((AstNode)result);
                    result = memberSelect.completeWithExpression(result);
                    continue;
                }
                throw new IllegalStateException();
            }
        }
        return result;
    }

    public ExpressionTree applySelectors1(ExpressionTree primary, Optional<List<ExpressionTree>> selectors) {
        return this.applySelectors(primary, selectors);
    }

    public ExpressionTree applySelectors2(ExpressionTree primary, Optional<List<ExpressionTree>> selectors) {
        return this.applySelectors(primary, selectors);
    }

    public AstNode newWrapperAstNode(Optional<List<AstNode>> e1, AstNode e2) {
        if (e1.isPresent()) {
            AstNode astNode = new AstNode(WRAPPER_AST_NODE, WRAPPER_AST_NODE.toString(), null);
            for (AstNode child : e1.get()) {
                astNode.addChild(child);
            }
            astNode.addChild(e2);
            return astNode;
        }
        return e2;
    }

    public AstNode newWrapperAstNode(AstNode e1, AstNode e2) {
        AstNode astNode = new AstNode(WRAPPER_AST_NODE, WRAPPER_AST_NODE.toString(), null);
        astNode.addChild(e1);
        astNode.addChild(e2);
        return astNode;
    }

    public AstNode newWrapperAstNode(AstNode e1, Optional<AstNode> e2) {
        AstNode astNode = new AstNode(WRAPPER_AST_NODE, WRAPPER_AST_NODE.toString(), null);
        astNode.addChild(e1);
        if (e2.isPresent()) {
            astNode.addChild(e2.get());
        }
        return astNode;
    }

    public AstNode newWrapperAstNode2(AstNode e1, AstNode e2) {
        return this.newWrapperAstNode(e1, e2);
    }

    public AstNode newWrapperAstNode4(AstNode e1, AstNode e2) {
        return this.newWrapperAstNode(e1, e2);
    }

    public AstNode newWrapperAstNode5(Optional<List<AstNode>> e1, AstNode e2) {
        return this.newWrapperAstNode(e1, e2);
    }

    public AstNode newWrapperAstNode6(AstNode e1, AstNode e2) {
        return this.newWrapperAstNode(e1, e2);
    }

    public AstNode newWrapperAstNode7(AstNode e1, AstNode e2) {
        return this.newWrapperAstNode(e1, e2);
    }

    public AstNode newWrapperAstNode8(AstNode e1, AstNode e2) {
        return this.newWrapperAstNode(e1, e2);
    }

    public AstNode newWrapperAstNode9(AstNode e1, AstNode e2) {
        return this.newWrapperAstNode(e1, e2);
    }

    public AstNode newWrapperAstNode10(AstNode e1, AstNode e2) {
        return this.newWrapperAstNode(e1, e2);
    }

    public AstNode newWrapperAstNode11(Optional<List<AstNode>> e1, AstNode e2) {
        return this.newWrapperAstNode(e1, e2);
    }

    public AstNode newWrapperAstNode12(AstNode e1, AstNode e2) {
        return this.newWrapperAstNode(e1, e2);
    }

    public AstNode newWrapperAstNode13(AstNode e1, AstNode e2) {
        return this.newWrapperAstNode(e1, e2);
    }

    public AstNode newWrapperAstNode14(AstNode e1, Optional<AstNode> e2) {
        return this.newWrapperAstNode(e1, e2);
    }

    public AstNode newWrapperAstNode15(AstNode e1, Optional<AstNode> e2) {
        return this.newWrapperAstNode(e1, e2);
    }

    private <T, U> Tuple<T, U> newTuple(T first, U second) {
        return new Tuple<T, U>(first, second);
    }

    public <T, U> Tuple<T, U> newTuple1(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple2(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple3(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple4(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple5(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple6(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple7(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple8(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple9(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple10(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple11(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple12(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple14(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple15(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple16(T first, U second) {
        return this.newTuple(first, second);
    }

    public <T, U> Tuple<T, U> newTuple17(T first, U second) {
        return this.newTuple(first, second);
    }

    private ExpressionTree applyDim(ExpressionTree expression, int count) {
        ExpressionTree result = expression;
        for (int i = 0; i < count; ++i) {
            result = new JavaTree.ArrayTypeTreeImpl(null, result);
        }
        return result;
    }

    public static class Tuple<T, U>
    extends AstNode {
        private final T first;
        private final U second;

        public Tuple(T first, U second) {
            super(WRAPPER_AST_NODE, WRAPPER_AST_NODE.toString(), null);
            this.first = first;
            this.second = second;
            this.add(first);
            this.add(second);
        }

        public T first() {
            return this.first;
        }

        public U second() {
            return this.second;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void add(Object o) {
            if (o instanceof AstNode) {
                this.addChild((AstNode)o);
                return;
            } else {
                if (!(o instanceof Optional)) throw new IllegalStateException("Unsupported argument type: " + o.getClass().getSimpleName());
                Optional opt = (Optional)o;
                if (!opt.isPresent()) return;
                Object o2 = opt.get();
                if (o2 instanceof AstNode) {
                    this.addChild((AstNode)o2);
                    return;
                } else {
                    if (!(o2 instanceof List)) throw new IllegalArgumentException("Unsupported type: " + o2.getClass().getSimpleName());
                    for (Object o3 : (List)o2) {
                        Preconditions.checkArgument((boolean)(o3 instanceof AstNode), (Object)("Unsupported type: " + o3.getClass().getSimpleName()));
                        this.addChild((AstNode)o3);
                    }
                }
            }
        }
    }

    private static class OperatorAndOperand {
        private final InternalSyntaxToken operator;
        private final ExpressionTree operand;

        public OperatorAndOperand(InternalSyntaxToken operator, ExpressionTree operand) {
            this.operator = operator;
            this.operand = operand;
        }

        public InternalSyntaxToken operator() {
            return this.operator;
        }

        public ExpressionTree operand() {
            return this.operand;
        }
    }
}

