/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode;

import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmMethod;

public class VirtualMethodsLinker {
    public void process(AsmMethod method) {
        AsmMethod implementation;
        if (!method.isBodyLoaded() && method.isUsed() && (implementation = this.findImplementation(method.getParent(), method.getKey())) != null) {
            implementation.setUsed(true);
            method.linkTo(implementation);
        }
    }

    private AsmMethod findImplementation(AsmClass asmClass, String methodKey) {
        AsmMethod method = asmClass.getMethod(methodKey);
        if (method != null && method.isBodyLoaded()) {
            return method;
        }
        if (asmClass.getSuperClass() != null) {
            return this.findImplementation(asmClass.getSuperClass(), methodKey);
        }
        return null;
    }
}

