/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class ReturnStatementTreeImpl
extends JavaTree
implements ReturnStatementTree {
    @Nullable
    private final ExpressionTree expression;

    public ReturnStatementTreeImpl(@Nullable ExpressionTree expression, AstNode ... children) {
        super(Tree.Kind.RETURN_STATEMENT);
        this.expression = expression;
        for (AstNode child : children) {
            this.addChild(child);
        }
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.RETURN_STATEMENT;
    }

    @Override
    public SyntaxToken returnKeyword() {
        return InternalSyntaxToken.createLegacy(this.getAstNode().getFirstChild(new AstNodeType[]{JavaKeyword.RETURN}));
    }

    @Override
    @Nullable
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public SyntaxToken semicolonToken() {
        return InternalSyntaxToken.createLegacy(this.getAstNode().getFirstChild(new AstNodeType[]{JavaPunctuator.SEMI}));
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitReturnStatement(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.singletonIterator((Object)this.expression);
    }
}

