/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.parser.ResourceListTreeImpl;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.statement.BlockTreeImpl;
import org.sonar.java.model.statement.CatchTreeImpl;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class TryStatementTreeImpl
extends JavaTree
implements TryStatementTree {
    private InternalSyntaxToken tryToken;
    @Nullable
    private final InternalSyntaxToken openParenToken;
    private final List<VariableTree> resources;
    @Nullable
    private final InternalSyntaxToken closeParenToken;
    private BlockTree block;
    private final List<CatchTreeImpl> catches;
    @Nullable
    private final BlockTreeImpl finallyBlock;

    public TryStatementTreeImpl(List<CatchTreeImpl> catches, @Nullable BlockTreeImpl finallyBlock) {
        super(Tree.Kind.TRY_STATEMENT);
        this.openParenToken = null;
        this.resources = ImmutableList.of();
        this.closeParenToken = null;
        this.catches = catches;
        this.finallyBlock = finallyBlock;
        for (CatchTreeImpl catch_ : catches) {
            this.addChild(catch_);
        }
        if (finallyBlock != null) {
            this.addChild(finallyBlock);
        }
    }

    public TryStatementTreeImpl(BlockTreeImpl finallyBlock) {
        this((List<CatchTreeImpl>)ImmutableList.of(), finallyBlock);
    }

    public TryStatementTreeImpl(InternalSyntaxToken tryToken, InternalSyntaxToken openParenToken, ResourceListTreeImpl resources, InternalSyntaxToken closeParenToken, BlockTreeImpl block, List<CatchTreeImpl> catches, @Nullable BlockTreeImpl finallyBlock) {
        super(Tree.Kind.TRY_STATEMENT);
        this.tryToken = tryToken;
        this.openParenToken = openParenToken;
        this.resources = resources;
        this.closeParenToken = closeParenToken;
        this.block = block;
        this.catches = catches;
        this.finallyBlock = finallyBlock;
        this.addChild(tryToken);
        this.addChild(openParenToken);
        this.addChild(resources);
        this.addChild(closeParenToken);
        this.addChild(block);
        for (CatchTreeImpl catch_ : catches) {
            this.addChild(catch_);
        }
        if (finallyBlock != null) {
            this.addChild(finallyBlock);
        }
    }

    public TryStatementTreeImpl completeStandardTry(InternalSyntaxToken tryToken, BlockTreeImpl block) {
        this.tryToken = tryToken;
        this.block = block;
        this.prependChildren(tryToken, block);
        return this;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.TRY_STATEMENT;
    }

    @Override
    public SyntaxToken tryKeyword() {
        return this.tryToken;
    }

    @Override
    @Nullable
    public SyntaxToken openParenToken() {
        return this.openParenToken;
    }

    @Override
    public List<VariableTree> resources() {
        return this.resources;
    }

    @Override
    @Nullable
    public SyntaxToken closeParenToken() {
        return this.closeParenToken;
    }

    @Override
    public BlockTree block() {
        return this.block;
    }

    @Override
    public List<CatchTree> catches() {
        return this.catches;
    }

    @Override
    @Nullable
    public SyntaxToken finallyKeyword() {
        if (this.finallyBlock == null) {
            return null;
        }
        return InternalSyntaxToken.createLegacy(this.finallyBlock.getFirstChild(new AstNodeType[]{JavaKeyword.FINALLY}));
    }

    @Override
    @Nullable
    public BlockTree finallyBlock() {
        return this.finallyBlock;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitTryStatement(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat(this.resources.iterator(), (Iterator)Iterators.singletonIterator((Object)this.block), this.catches.iterator(), (Iterator)Iterators.singletonIterator((Object)this.finallyBlock));
    }
}

