/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchExtension;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.WildcardPattern;

public class JavaClasspath
implements BatchExtension {
    private static final char SEPARATOR = ',';
    private static final Logger LOG = LoggerFactory.getLogger(JavaClasspath.class);
    private final Project project;
    private final Settings settings;
    private final FileSystem fs;
    @Nullable
    private final MavenProject pom;
    private List<File> binaries;
    private List<File> elements;
    private boolean validateLibraries;
    private boolean hasJavaSources;
    private boolean initalized;

    public JavaClasspath(Project project, Settings settings, FileSystem fs) {
        this(project, settings, fs, null);
    }

    public JavaClasspath(Project project, Settings settings, FileSystem fs, @Nullable MavenProject pom) {
        this.project = project;
        this.settings = settings;
        this.fs = fs;
        this.pom = pom;
        this.initalized = false;
    }

    private void init() {
        if (!this.initalized) {
            boolean useDeprecatedProperties;
            this.initalized = true;
            this.validateLibraries = this.project.getModules().isEmpty();
            FilePredicates predicates = this.fs.predicates();
            this.hasJavaSources = this.fs.hasFiles(predicates.and(predicates.hasLanguage("java"), predicates.hasType(InputFile.Type.MAIN)));
            File baseDir = this.fs.baseDir();
            this.binaries = this.getFilesFromProperty("sonar.java.binaries", this.settings, baseDir);
            List<File> libraries = this.getFilesFromProperty("sonar.java.libraries", this.settings, baseDir);
            boolean bl = useDeprecatedProperties = this.binaries.isEmpty() && libraries.isEmpty();
            if (useDeprecatedProperties) {
                this.binaries = this.getFilesFromProperty("sonar.binaries", this.settings, baseDir);
                libraries = this.getFilesFromProperty("sonar.libraries", this.settings, baseDir);
            }
            if (this.pom != null && libraries.isEmpty()) {
                this.elements = this.getLibrariesFromMaven(this.pom);
            } else {
                this.elements = Lists.newArrayList(this.binaries);
                this.elements.addAll(libraries);
                if (useDeprecatedProperties && !this.elements.isEmpty()) {
                    LOG.warn("sonar.binaries and sonar.libraries are deprecated since version 2.5 of sonar-java-plugin, please use sonar.java.binaries and sonar.java.libraries instead");
                }
            }
        }
    }

    private List<File> getLibrariesFromMaven(MavenProject pom) {
        try {
            File outputDirectoryFile;
            ArrayList files = Lists.newArrayList();
            if (pom.getCompileClasspathElements() != null) {
                for (String classPathString : pom.getCompileClasspathElements()) {
                    files.add(new File(classPathString));
                }
            }
            if (pom.getBuild().getOutputDirectory() != null && (outputDirectoryFile = new File(pom.getBuild().getOutputDirectory())).exists()) {
                files.add(outputDirectoryFile);
            }
            return files;
        }
        catch (DependencyResolutionRequiredException e) {
            throw new SonarException("Fail to create the project classloader", (Throwable)e);
        }
    }

    private List<File> getFilesFromProperty(String property, Settings settings, File baseDir) {
        ArrayList result = Lists.newArrayList();
        String fileList = settings.getString(property);
        if (StringUtils.isNotEmpty((String)fileList)) {
            Iterable fileNames = Splitter.on((char)',').omitEmptyStrings().split((CharSequence)fileList);
            for (String pathPattern : fileNames) {
                boolean isLibraryProperty = property.endsWith("libraries");
                List<File> libraryFilesForPattern = this.getFilesForPattern(baseDir, pathPattern, isLibraryProperty);
                if (this.validateLibraries && libraryFilesForPattern.isEmpty() && this.hasJavaSources) {
                    LOG.error("Invalid value for " + property);
                    String message = "No files nor directories matching '" + pathPattern + "'";
                    throw new IllegalStateException(message);
                }
                result.addAll(libraryFilesForPattern);
            }
        }
        return result;
    }

    private List<File> getFilesForPattern(File baseDir, String pathPattern, boolean libraryProperty) {
        String filePattern;
        int lastPathSeparator;
        String dirPath = pathPattern;
        int wildcardIndex = pathPattern.indexOf(42);
        if (wildcardIndex >= 0) {
            dirPath = pathPattern.substring(0, wildcardIndex);
        }
        if ((lastPathSeparator = Math.max(dirPath.lastIndexOf(47), dirPath.lastIndexOf(92))) == -1) {
            dirPath = ".";
            filePattern = pathPattern;
        } else {
            dirPath = pathPattern.substring(0, lastPathSeparator);
            filePattern = pathPattern.substring(lastPathSeparator + 1);
        }
        File dir = this.resolvePath(baseDir, dirPath);
        if (!dir.isDirectory()) {
            return Lists.newArrayList();
        }
        return this.getMatchingFiles(filePattern, dir, libraryProperty);
    }

    private List<File> getMatchingFiles(String pattern, File dir, boolean libraryProperty) {
        WilcardPatternFileFilter wilcardPatternFileFilter;
        WilcardPatternFileFilter fileFilter = wilcardPatternFileFilter = new WilcardPatternFileFilter(dir, pattern);
        ArrayList files = Lists.newArrayList();
        if (libraryProperty) {
            if (pattern.endsWith("*")) {
                fileFilter = new AndFileFilter((IOFileFilter)fileFilter, (IOFileFilter)new OrFileFilter((List)Lists.newArrayList((Object[])new IOFileFilter[]{FileFilterUtils.suffixFileFilter((String)".jar", (IOCase)IOCase.INSENSITIVE), FileFilterUtils.suffixFileFilter((String)".zip", (IOCase)IOCase.INSENSITIVE)})));
            }
            files.addAll(Lists.newArrayList((Iterable)FileUtils.listFiles((File)dir, (IOFileFilter)fileFilter, (IOFileFilter)TrueFileFilter.TRUE)));
        }
        IOFileFilter subdirectories = pattern.isEmpty() ? FalseFileFilter.FALSE : TrueFileFilter.TRUE;
        Collection dirs = FileUtils.listFilesAndDirs((File)dir, (IOFileFilter)new AndFileFilter((IOFileFilter)wilcardPatternFileFilter, DirectoryFileFilter.DIRECTORY), (IOFileFilter)subdirectories);
        if (!pattern.isEmpty()) {
            dirs.remove(dir);
            Iterator iterator = dirs.iterator();
            while (iterator.hasNext()) {
                File matchingDir = (File)iterator.next();
                if (wilcardPatternFileFilter.accept(matchingDir)) continue;
                iterator.remove();
            }
        }
        if (libraryProperty) {
            for (File directory : dirs) {
                files.addAll(this.getMatchingFiles("**/*.jar", directory, true));
                files.addAll(this.getMatchingFiles("**/*.zip", directory, true));
            }
        }
        files.addAll(dirs);
        return files;
    }

    private File resolvePath(File baseDir, String fileName) {
        File file = new File(fileName);
        if (!file.isAbsolute()) {
            file = new File(baseDir, fileName);
        }
        return file;
    }

    public List<File> getElements() {
        this.init();
        return this.elements;
    }

    public List<File> getBinaryDirs() {
        this.init();
        return this.binaries;
    }

    private static class WilcardPatternFileFilter
    implements IOFileFilter {
        private File baseDir;
        private WildcardPattern wildcardPattern;

        public WilcardPatternFileFilter(File baseDir, String wildcardPattern) {
            this.baseDir = baseDir;
            this.wildcardPattern = WildcardPattern.create((String)FilenameUtils.separatorsToSystem((String)wildcardPattern), (String)File.separator);
        }

        public boolean accept(File dir, String name) {
            return this.accept(new File(dir, name));
        }

        public boolean accept(File file) {
            String path = file.getAbsolutePath();
            path = path.substring(this.baseDir.getAbsolutePath().length() + 1);
            return this.wildcardPattern.match(path);
        }
    }
}

