/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.design.Dependency;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.TimeProfiler;
import org.sonar.graph.DirectedGraph;
import org.sonar.java.CharsetAwareVisitor;
import org.sonar.java.JavaAstScanner;
import org.sonar.java.JavaConfiguration;
import org.sonar.java.Measurer;
import org.sonar.java.SonarComponents;
import org.sonar.java.ast.AstScanner;
import org.sonar.java.ast.visitors.FileLinesVisitor;
import org.sonar.java.ast.visitors.SyntaxHighlighterVisitor;
import org.sonar.java.bytecode.BytecodeScanner;
import org.sonar.java.bytecode.visitor.DependenciesVisitor;
import org.sonar.java.model.TestFileVisitorsBridge;
import org.sonar.java.model.VisitorsBridge;
import org.sonar.plugins.java.api.JavaResourceLocator;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.api.CodeVisitor;
import org.sonar.squidbridge.api.Query;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourceCodeSearchEngine;
import org.sonar.squidbridge.indexer.SquidIndex;

public class JavaSquid
implements SourceCodeSearchEngine {
    private static final Logger LOG = LoggerFactory.getLogger(JavaSquid.class);
    private final SquidIndex squidIndex;
    private final AstScanner astScanner;
    private final AstScanner astScannerForTests;
    private final BytecodeScanner bytecodeScanner;
    private final DirectedGraph<Resource, Dependency> graph = new DirectedGraph();
    private boolean bytecodeScanned = false;

    @VisibleForTesting
    public JavaSquid(JavaConfiguration conf, JavaResourceLocator javaResourceLocator, CodeVisitor ... visitors) {
        this(conf, (SonarComponents)null, (Measurer)null, javaResourceLocator, visitors);
    }

    public JavaSquid(JavaConfiguration conf, @Nullable SonarComponents sonarComponents, @Nullable Measurer measurer, JavaResourceLocator javaResourceLocator, CodeVisitor ... visitors) {
        this.astScanner = JavaAstScanner.create(conf, new SquidAstVisitor[0]);
        Iterable visitorsToBridge = Iterables.concat(Arrays.asList(javaResourceLocator), Arrays.asList(visitors));
        if (measurer != null) {
            List<CodeVisitor> measurers = Arrays.asList(measurer);
            visitorsToBridge = Iterables.concat((Iterable)visitorsToBridge, measurers);
        }
        if (sonarComponents != null) {
            visitorsToBridge = Iterables.concat(sonarComponents.createJavaFileScanners(), (Iterable)visitorsToBridge);
        }
        VisitorsBridge visitorsBridge = new VisitorsBridge(visitorsToBridge, sonarComponents);
        visitorsBridge.setCharset(conf.getCharset());
        visitorsBridge.setAnalyseAccessors(conf.separatesAccessorsFromMethods());
        this.astScanner.accept((CodeVisitor)visitorsBridge);
        if (sonarComponents != null) {
            this.astScanner.accept((CodeVisitor)new FileLinesVisitor(sonarComponents, conf.getCharset()));
            this.astScanner.accept((CodeVisitor)new SyntaxHighlighterVisitor(sonarComponents, conf.getCharset()));
        }
        this.squidIndex = (SquidIndex)this.astScanner.getIndex();
        this.bytecodeScanner = new BytecodeScanner(this.squidIndex, javaResourceLocator);
        this.bytecodeScanner.accept(new DependenciesVisitor(this.graph));
        for (CodeVisitor visitor : visitors) {
            if (visitor instanceof CharsetAwareVisitor) {
                ((CharsetAwareVisitor)visitor).setCharset(conf.getCharset());
            }
            this.astScanner.accept(visitor);
            this.bytecodeScanner.accept(visitor);
        }
        this.astScannerForTests = new AstScanner(this.astScanner);
        this.astScannerForTests.accept((CodeVisitor)new TestFileVisitorsBridge(javaResourceLocator));
    }

    public void scan(Iterable<File> sourceFiles, Iterable<File> testFiles, Collection<File> bytecodeFilesOrDirectories) {
        this.scanSources(sourceFiles);
        this.scanBytecode(bytecodeFilesOrDirectories);
        this.scanTests(testFiles);
    }

    private void scanSources(Iterable<File> sourceFiles) {
        TimeProfiler profiler = new TimeProfiler(this.getClass()).start("Java Main Files AST scan");
        this.astScanner.scan(sourceFiles);
        profiler.stop();
    }

    private void scanTests(Iterable<File> testFiles) {
        TimeProfiler profiler = new TimeProfiler(this.getClass()).start("Java Test Files AST scan");
        this.astScannerForTests.simpleScan(testFiles);
        profiler.stop();
    }

    private void scanBytecode(Collection<File> bytecodeFilesOrDirectories) {
        if (JavaSquid.hasBytecode(bytecodeFilesOrDirectories)) {
            TimeProfiler profiler = new TimeProfiler(this.getClass()).start("Java bytecode scan");
            this.bytecodeScanner.scan(bytecodeFilesOrDirectories);
            this.bytecodeScanned = true;
            profiler.stop();
        } else {
            LOG.warn("Java bytecode has not been made available to the analyzer. The " + Joiner.on((String)", ").join((Iterable)this.bytecodeScanner.getVisitors()) + " are disabled.");
            this.bytecodeScanned = false;
        }
    }

    static boolean hasBytecode(Collection<File> bytecodeFilesOrDirectories) {
        if (bytecodeFilesOrDirectories == null) {
            return false;
        }
        for (File bytecodeFilesOrDirectory : bytecodeFilesOrDirectories) {
            if (!bytecodeFilesOrDirectory.exists() || !bytecodeFilesOrDirectory.isFile() && FileUtils.listFiles((File)bytecodeFilesOrDirectory, (String[])new String[]{"class"}, (boolean)true).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean isBytecodeScanned() {
        return this.bytecodeScanned;
    }

    public SquidIndex getIndex() {
        return this.squidIndex;
    }

    public DirectedGraph<Resource, Dependency> getGraph() {
        return this.graph;
    }

    public SourceCode search(String key) {
        return this.squidIndex.search(key);
    }

    public Collection<SourceCode> search(Query ... query) {
        return this.squidIndex.search(query);
    }
}

