/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.PersistenceMode;
import org.sonar.api.measures.RangeDistributionBuilder;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.java.CharsetAwareVisitor;
import org.sonar.java.ast.visitors.AccessorVisitor;
import org.sonar.java.ast.visitors.CommentLinesVisitor;
import org.sonar.java.ast.visitors.LinesOfCodeVisitor;
import org.sonar.java.ast.visitors.PublicApiChecker;
import org.sonar.java.ast.visitors.StatementVisitor;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

public class Measurer
extends SubscriptionVisitor
implements CharsetAwareVisitor {
    private static final Number[] LIMITS_COMPLEXITY_METHODS = new Number[]{1, 2, 4, 6, 8, 10, 12};
    private static final Number[] LIMITS_COMPLEXITY_FILES = new Number[]{0, 5, 10, 20, 30, 60, 90};
    private final SensorContext sensorContext;
    private final Project project;
    private final boolean separateAccessorsFromMethods;
    private org.sonar.api.resources.File sonarFile;
    private int methods;
    private int accessors;
    private int complexityInMethods;
    private RangeDistributionBuilder methodComplexityDistribution;
    private final Deque<ClassTree> classTrees = new LinkedList<ClassTree>();
    private final AccessorVisitor accessorVisitor;
    private Charset charset;
    private double classes;

    public Measurer(Project project, SensorContext context, boolean separateAccessorsFromMethods) {
        this.project = project;
        this.sensorContext = context;
        this.separateAccessorsFromMethods = separateAccessorsFromMethods;
        this.accessorVisitor = new AccessorVisitor();
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)((Object)Tree.Kind.CLASS), (Object)((Object)Tree.Kind.INTERFACE), (Object)((Object)Tree.Kind.ENUM), (Object)((Object)Tree.Kind.ANNOTATION_TYPE), (Object)((Object)Tree.Kind.NEW_CLASS), (Object)((Object)Tree.Kind.ENUM_CONSTANT), (Object)((Object)Tree.Kind.METHOD), (Object)((Object)Tree.Kind.CONSTRUCTOR));
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.sonarFile = org.sonar.api.resources.File.fromIOFile((File)context.getFile(), (Project)this.project);
        this.classTrees.clear();
        this.methods = 0;
        this.complexityInMethods = 0;
        this.accessors = 0;
        this.classes = 0.0;
        PublicApiChecker publicApiChecker = PublicApiChecker.newInstanceWithAccessorsHandledAsMethods();
        if (this.separateAccessorsFromMethods) {
            publicApiChecker = PublicApiChecker.newInstanceWithAccessorsSeparatedFromMethods();
        }
        publicApiChecker.scan(context.getTree());
        this.methodComplexityDistribution = new RangeDistributionBuilder(CoreMetrics.FUNCTION_COMPLEXITY_DISTRIBUTION, LIMITS_COMPLEXITY_METHODS);
        super.scanFile(context);
        int fileComplexity = context.getComplexity(context.getTree());
        this.saveMetricOnFile(CoreMetrics.CLASSES, this.classes);
        this.saveMetricOnFile(CoreMetrics.FUNCTIONS, this.methods);
        this.saveMetricOnFile(CoreMetrics.ACCESSORS, this.accessors);
        this.saveMetricOnFile(CoreMetrics.COMPLEXITY_IN_FUNCTIONS, this.complexityInMethods);
        this.saveMetricOnFile(CoreMetrics.COMPLEXITY, fileComplexity);
        this.saveMetricOnFile(CoreMetrics.PUBLIC_API, publicApiChecker.getPublicApi());
        this.saveMetricOnFile(CoreMetrics.PUBLIC_DOCUMENTED_API_DENSITY, publicApiChecker.getDocumentedPublicApiDensity());
        this.saveMetricOnFile(CoreMetrics.PUBLIC_UNDOCUMENTED_API, publicApiChecker.getUndocumentedPublicApi());
        this.saveMetricOnFile(CoreMetrics.COMMENT_LINES, new CommentLinesVisitor().commentLines(context.getTree()));
        this.saveMetricOnFile(CoreMetrics.STATEMENTS, new StatementVisitor().numberOfStatements(context.getTree()));
        this.saveMetricOnFile(CoreMetrics.NCLOC, new LinesOfCodeVisitor().linesOfCode(context.getTree()));
        this.sensorContext.saveMeasure((Resource)this.sonarFile, this.methodComplexityDistribution.build(true).setPersistenceMode(PersistenceMode.MEMORY));
        RangeDistributionBuilder fileComplexityDistribution = new RangeDistributionBuilder(CoreMetrics.FILE_COMPLEXITY_DISTRIBUTION, LIMITS_COMPLEXITY_FILES);
        this.sensorContext.saveMeasure((Resource)this.sonarFile, fileComplexityDistribution.add((Number)fileComplexity).build(true).setPersistenceMode(PersistenceMode.MEMORY));
        this.saveLinesMetric();
    }

    private void saveLinesMetric() {
        try {
            String content = Files.toString((File)this.context.getFile(), (Charset)this.charset);
            this.saveMetricOnFile(CoreMetrics.LINES, content.split("(\r)?\n|\r", -1).length);
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void visitNode(Tree tree) {
        if (this.isClassTree(tree)) {
            this.classes += 1.0;
            this.classTrees.push((ClassTree)tree);
        }
        if (tree.is(Tree.Kind.NEW_CLASS) && ((NewClassTree)tree).classBody() != null) {
            this.classes -= 1.0;
        }
        if (tree.is(Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR) && this.classTrees.peek().simpleName() != null) {
            MethodTree methodTree = (MethodTree)tree;
            if (this.separateAccessorsFromMethods && this.accessorVisitor.isAccessor(this.classTrees.peek(), methodTree)) {
                ++this.accessors;
            } else {
                ++this.methods;
                int methodComplexity = this.context.getMethodComplexity(this.classTrees.peek(), methodTree);
                this.methodComplexityDistribution.add((Number)methodComplexity);
                this.complexityInMethods += methodComplexity;
            }
        }
    }

    @Override
    public void leaveNode(Tree tree) {
        if (this.isClassTree(tree)) {
            this.classTrees.pop();
        }
    }

    private boolean isClassTree(Tree tree) {
        return tree.is(Tree.Kind.CLASS) || tree.is(Tree.Kind.INTERFACE) || tree.is(Tree.Kind.ENUM) || tree.is(Tree.Kind.ANNOTATION_TYPE);
    }

    private void saveMetricOnFile(Metric metric, double value) {
        this.sensorContext.saveMeasure((Resource)this.sonarFile, new Measure(metric, Double.valueOf(value)));
    }

    @Override
    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}

