/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.declaration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.parser.JavaLexer;
import org.sonar.java.ast.parser.QualifiedIdentifierListTreeImpl;
import org.sonar.java.ast.parser.TypeParameterListTreeImpl;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.declaration.ModifiersTreeImpl;
import org.sonar.java.model.expression.IdentifierTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeParameters;

public class ClassTreeImpl
extends JavaTree
implements ClassTree {
    private final Tree.Kind kind;
    private ModifiersTree modifiers;
    private IdentifierTree simpleName;
    private TypeParameters typeParameters;
    @Nullable
    private Tree superClass;
    private List<Tree> superInterfaces;
    private final List<Tree> members;
    @Nullable
    private Symbol.TypeSymbol symbol;

    public ClassTreeImpl(Tree.Kind kind, List<Tree> members, List<AstNode> children) {
        super(kind);
        this.kind = kind;
        this.members = members;
        this.modifiers = ModifiersTreeImpl.EMPTY;
        this.typeParameters = new TypeParameterListTreeImpl();
        this.superInterfaces = ImmutableList.of();
        for (AstNode child : children) {
            this.addChild(child);
        }
    }

    public ClassTreeImpl(ModifiersTree modifiers, List<Tree> members, List<AstNode> children) {
        super(Tree.Kind.ANNOTATION_TYPE);
        this.kind = (Tree.Kind)((Object)Preconditions.checkNotNull((Object)((Object)Tree.Kind.ANNOTATION_TYPE)));
        this.modifiers = modifiers;
        this.typeParameters = new TypeParameterListTreeImpl();
        this.superClass = null;
        this.superInterfaces = ImmutableList.of();
        this.members = (List)Preconditions.checkNotNull(members);
        for (AstNode child : children) {
            this.addChild(child);
        }
    }

    public ClassTreeImpl(AstNode astNode, Tree.Kind kind, ModifiersTree modifiers, @Nullable IdentifierTree simpleName, TypeParameters typeParameters, @Nullable Tree superClass, List<Tree> superInterfaces, List<Tree> members) {
        super(astNode);
        this.kind = (Tree.Kind)((Object)Preconditions.checkNotNull((Object)((Object)kind)));
        this.modifiers = (ModifiersTree)Preconditions.checkNotNull((Object)modifiers);
        this.simpleName = simpleName;
        this.typeParameters = typeParameters;
        this.superClass = superClass;
        this.superInterfaces = (List)Preconditions.checkNotNull(superInterfaces);
        this.members = (List)Preconditions.checkNotNull(members);
    }

    public ClassTreeImpl completeModifiers(ModifiersTreeImpl modifiers) {
        this.modifiers = modifiers;
        return this;
    }

    public ClassTreeImpl completeIdentifier(IdentifierTree identifier) {
        this.simpleName = identifier;
        return this;
    }

    public ClassTreeImpl completeTypeParameters(TypeParameterListTreeImpl typeParameters) {
        this.typeParameters = typeParameters;
        return this;
    }

    public ClassTreeImpl completeSuperclass(Tree superClass) {
        this.superClass = superClass;
        return this;
    }

    public ClassTreeImpl completeInterfaces(QualifiedIdentifierListTreeImpl interfaces) {
        this.superInterfaces = interfaces;
        return this;
    }

    public ClassTreeImpl complete(InternalSyntaxToken atToken, InternalSyntaxToken interfaceToken, IdentifierTree simpleName) {
        Preconditions.checkState((this.simpleName == null ? 1 : 0) != 0);
        this.simpleName = simpleName;
        this.prependChildren(atToken, interfaceToken, (AstNode)simpleName);
        return this;
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    @Nullable
    public IdentifierTree simpleName() {
        return this.simpleName;
    }

    @Override
    public TypeParameters typeParameters() {
        return this.typeParameters;
    }

    @Override
    public ModifiersTree modifiers() {
        return this.modifiers;
    }

    @Override
    @Nullable
    public Tree superClass() {
        return this.superClass;
    }

    @Override
    public List<Tree> superInterfaces() {
        return this.superInterfaces;
    }

    @Override
    public SyntaxToken openBraceToken() {
        return this.getBrace(JavaPunctuator.LWING);
    }

    @Nullable
    private SyntaxToken getBrace(JavaPunctuator leftOrRightBrace) {
        if (this.is(Tree.Kind.ANNOTATION_TYPE)) {
            return new InternalSyntaxToken(this.getAstNode().getFirstChild(new AstNodeType[]{leftOrRightBrace}).getToken());
        }
        if (this.getAstNode().is(new AstNodeType[]{Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE})) {
            return new InternalSyntaxToken(this.getAstNode().getFirstChild(new AstNodeType[]{leftOrRightBrace}).getToken());
        }
        return new InternalSyntaxToken(this.getAstNode().getFirstChild(new AstNodeType[]{JavaLexer.CLASS_BODY, JavaLexer.INTERFACE_BODY, JavaLexer.ENUM_BODY}).getFirstChild(new AstNodeType[]{leftOrRightBrace}).getToken());
    }

    @Override
    public List<Tree> members() {
        return this.members;
    }

    @Override
    public SyntaxToken closeBraceToken() {
        return this.getBrace(JavaPunctuator.RWING);
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitClass(this);
    }

    @Nullable
    public Symbol.TypeSymbol getSymbol() {
        return this.symbol;
    }

    public void setSymbol(Symbol.TypeSymbol symbol) {
        Preconditions.checkState((this.symbol == null ? 1 : 0) != 0);
        this.symbol = symbol;
    }

    @Override
    public int getLine() {
        if (this.simpleName == null) {
            return super.getLine();
        }
        return ((IdentifierTreeImpl)this.simpleName).getLine();
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        UnmodifiableIterator typeParamIterator = Iterators.emptyIterator();
        if (this.typeParameters != null) {
            typeParamIterator = Iterators.singletonIterator((Object)this.typeParameters);
        }
        return Iterators.concat((Iterator[])new Iterator[]{Iterators.forArray((Object[])new Tree[]{this.modifiers, this.simpleName}), typeParamIterator, Iterators.singletonIterator((Object)this.superClass), this.superInterfaces.iterator(), this.members.iterator()});
    }
}

