/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class InstanceOfTreeImpl
extends AbstractTypedTree
implements InstanceOfTree {
    private ExpressionTree expression;
    private final InternalSyntaxToken instanceofToken;
    private final Tree type;

    public InstanceOfTreeImpl(InternalSyntaxToken instanceofToken, Tree type, AstNode child) {
        super(Tree.Kind.INSTANCE_OF);
        this.instanceofToken = instanceofToken;
        this.type = (Tree)Preconditions.checkNotNull((Object)type);
        this.addChild(instanceofToken);
        this.addChild(child);
    }

    public InstanceOfTreeImpl complete(ExpressionTree expression) {
        Preconditions.checkState((this.expression == null ? 1 : 0) != 0);
        this.expression = expression;
        this.prependChildren((AstNode)expression);
        return this;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.INSTANCE_OF;
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public SyntaxToken instanceofKeyword() {
        return this.instanceofToken;
    }

    @Override
    public Tree type() {
        return this.type;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitInstanceOf(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.expression, this.type});
    }
}

