/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.declaration.VariableTreeImpl;
import org.sonar.java.resolve.Resolve;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Symbols;
import org.sonar.java.resolve.Type;
import org.sonar.java.resolve.TypeAndReferenceSolver;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeParameterTree;
import org.sonar.plugins.java.api.tree.TypeParameters;
import org.sonar.plugins.java.api.tree.VariableTree;

public class SecondPass
implements Symbol.Completer {
    private final SemanticModel semanticModel;
    private final Symbols symbols;
    private final TypeAndReferenceSolver typeAndReferenceSolver;

    public SecondPass(SemanticModel semanticModel, Symbols symbols, TypeAndReferenceSolver typeAndReferenceSolver) {
        this.semanticModel = semanticModel;
        this.symbols = symbols;
        this.typeAndReferenceSolver = typeAndReferenceSolver;
    }

    @Override
    public void complete(Symbol symbol) {
        if (symbol.kind == 2) {
            this.complete((Symbol.TypeSymbol)symbol);
        } else if (symbol.kind == 16) {
            this.complete((Symbol.MethodSymbol)symbol);
        } else if (symbol.kind == 4) {
            this.complete((Symbol.VariableSymbol)symbol);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void complete(Symbol.TypeSymbol symbol) {
        Resolve.Env env = this.semanticModel.getEnv(symbol);
        Type.ClassType type = (Type.ClassType)symbol.type;
        if ((symbol.flags() & 0x200) == 0) {
            symbol.members.enter(new Symbol.VariableSymbol(16, "this", symbol.type, (Symbol)symbol));
        }
        if ("".equals(symbol.name)) {
            type.interfaces = ImmutableList.of();
            return;
        }
        ClassTree tree = (ClassTree)this.semanticModel.getTree(symbol);
        this.completeTypeParameters(tree.typeParameters(), env);
        Tree superClassTree = tree.superClass();
        if (superClassTree != null) {
            type.supertype = this.resolveType(env, superClassTree);
            this.checkHierarchyCycles(symbol.type);
            symbol.members.enter(new Symbol.VariableSymbol(16, "super", ((Type.ClassType)symbol.type).supertype, (Symbol)symbol));
        } else if (tree.is(Tree.Kind.ENUM)) {
            type.supertype = this.symbols.enumType;
        } else if (tree.is(Tree.Kind.CLASS, Tree.Kind.INTERFACE)) {
            type.supertype = this.symbols.objectType;
        }
        ImmutableList.Builder interfaces = ImmutableList.builder();
        for (Tree interfaceTree : tree.superInterfaces()) {
            Type interfaceType = this.resolveType(env, interfaceTree);
            if (interfaceType == null) continue;
            interfaces.add((Object)interfaceType);
        }
        if (tree.is(Tree.Kind.ANNOTATION_TYPE)) {
            interfaces.add((Object)this.symbols.annotationType);
        }
        type.interfaces = interfaces.build();
    }

    private void completeTypeParameters(TypeParameters typeParameters, Resolve.Env env) {
        for (TypeParameterTree typeParameterTree : typeParameters) {
            ArrayList bounds = Lists.newArrayList();
            if (typeParameterTree.bounds().isEmpty()) {
                bounds.add(this.symbols.objectType);
            } else {
                for (Tree boundTree : typeParameterTree.bounds()) {
                    bounds.add(this.resolveType(env, boundTree));
                }
            }
            ((Type.TypeVariableType)this.semanticModel.getSymbol((Tree)typeParameterTree).type).bounds = bounds;
        }
    }

    private void checkHierarchyCycles(Type baseType) {
        HashSet types = Sets.newHashSet();
        Type.ClassType type = (Type.ClassType)baseType;
        while (type != null) {
            if (!types.add(type)) {
                throw new IllegalStateException("Cycling class hierarchy detected with symbol : " + baseType.symbol.name + ".");
            }
            type = (Type.ClassType)type.symbol.getSuperclass();
        }
    }

    private void complete(Symbol.MethodSymbol symbol) {
        MethodTree methodTree = (MethodTree)this.semanticModel.getTree(symbol);
        Resolve.Env env = this.semanticModel.getEnv(symbol);
        this.completeTypeParameters(methodTree.typeParameters(), env);
        ImmutableList.Builder thrown = ImmutableList.builder();
        ImmutableList.Builder thrownTypes = ImmutableList.builder();
        for (ExpressionTree throwClause : methodTree.throwsClauses()) {
            Type thrownType = this.resolveType(env, throwClause);
            if (thrownType == null) continue;
            thrownTypes.add((Object)thrownType);
            thrown.add((Object)thrownType.symbol);
        }
        symbol.thrown = thrown.build();
        Type returnType = null;
        if (!"<init>".equals(symbol.name) && (returnType = this.resolveType(env, methodTree.returnType())) != null) {
            symbol.returnType = returnType.symbol;
        }
        ArrayList argTypes = Lists.newArrayList();
        Collection<Symbol> scopeSymbols = symbol.parameters.scopeSymbols();
        for (VariableTree variableTree : methodTree.parameters()) {
            for (Symbol param : scopeSymbols) {
                if (!variableTree.simpleName().name().equals(param.getName())) continue;
                param.complete();
                argTypes.add(param.getType());
            }
            if (!((VariableTreeImpl)variableTree).isVararg()) continue;
            symbol.flags |= 0x80;
        }
        Type.MethodType methodType = new Type.MethodType(argTypes, returnType, (List<Type>)thrownTypes.build(), (Symbol.TypeSymbol)symbol.owner);
        symbol.setMethodType(methodType);
    }

    private void complete(Symbol.VariableSymbol symbol) {
        VariableTree variableTree = (VariableTree)this.semanticModel.getTree(symbol);
        Resolve.Env env = this.semanticModel.getEnv(symbol);
        symbol.type = variableTree.is(Tree.Kind.ENUM_CONSTANT) ? env.enclosingClass().type : this.resolveType(env, variableTree.type());
    }

    private Type resolveType(Resolve.Env env, Tree tree) {
        Preconditions.checkArgument((boolean)this.checkTypeOfTree(tree), (Object)("Kind of tree unexpected " + (Object)((Object)((JavaTree)tree).getKind())));
        Type type = ((AbstractTypedTree)tree).getSymbolType();
        if (type != null) {
            return type;
        }
        this.typeAndReferenceSolver.env = env;
        this.typeAndReferenceSolver.resolveAs(tree, 2, env);
        this.typeAndReferenceSolver.env = null;
        return ((AbstractTypedTree)tree).getSymbolType();
    }

    private boolean checkTypeOfTree(Tree tree) {
        return tree.is(Tree.Kind.MEMBER_SELECT) || tree.is(Tree.Kind.IDENTIFIER) || tree.is(Tree.Kind.PARAMETERIZED_TYPE) || tree.is(Tree.Kind.ARRAY_TYPE) || tree.is(Tree.Kind.UNION_TYPE) || tree.is(Tree.Kind.PRIMITIVE_TYPE) || tree.is(Tree.Kind.INFERED_TYPE);
    }
}

