/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.JavaTree;
import org.sonar.java.resolve.BytecodeCompleter;
import org.sonar.java.resolve.FirstPass;
import org.sonar.java.resolve.LabelsVisitor;
import org.sonar.java.resolve.ParametrizedTypeCache;
import org.sonar.java.resolve.Resolve;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Symbols;
import org.sonar.java.resolve.TypeAndReferenceSolver;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;

public class SemanticModel {
    private final BiMap<Tree, Symbol> symbolsTree = HashBiMap.create();
    private Multimap<Symbol, IdentifierTree> usagesTree = HashMultimap.create();
    private Map<IdentifierTree, Symbol> refersTo = Maps.newHashMap();
    private final Map<Symbol, Resolve.Env> symbolEnvs = Maps.newHashMap();
    private final BiMap<Tree, Resolve.Env> envs = HashBiMap.create();
    private final Map<Tree, Tree> parentLink = Maps.newHashMap();
    private BytecodeCompleter bytecodeCompleter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SemanticModel createFor(CompilationUnitTree tree, List<File> projectClasspath) {
        ParametrizedTypeCache parametrizedTypeCache = new ParametrizedTypeCache();
        BytecodeCompleter bytecodeCompleter = new BytecodeCompleter(projectClasspath, parametrizedTypeCache);
        Symbols symbols = new Symbols(bytecodeCompleter);
        SemanticModel semanticModel = new SemanticModel();
        semanticModel.bytecodeCompleter = bytecodeCompleter;
        semanticModel.createParentLink((JavaTree)((Object)tree));
        try {
            Resolve resolve = new Resolve(symbols, bytecodeCompleter, parametrizedTypeCache);
            TypeAndReferenceSolver typeAndReferenceSolver = new TypeAndReferenceSolver(semanticModel, symbols, resolve, parametrizedTypeCache);
            new FirstPass(semanticModel, symbols, resolve, typeAndReferenceSolver).visitCompilationUnit(tree);
            typeAndReferenceSolver.visitCompilationUnit(tree);
            new LabelsVisitor(semanticModel).visitCompilationUnit(tree);
        }
        finally {
            SemanticModel.handleMissingTypes(symbols, tree);
        }
        return semanticModel;
    }

    public void done() {
        this.bytecodeCompleter.done();
    }

    public static void handleMissingTypes(Tree tree) {
        BytecodeCompleter bytecodeCompleter = new BytecodeCompleter((List<File>)ImmutableList.of(), new ParametrizedTypeCache());
        Symbols symbols = new Symbols(bytecodeCompleter);
        SemanticModel.handleMissingTypes(symbols, tree);
    }

    private static void handleMissingTypes(final Symbols symbols, Tree tree) {
        tree.accept(new BaseTreeVisitor(){

            @Override
            protected void scan(@Nullable Tree tree) {
                AbstractTypedTree typedNode;
                if (tree instanceof AbstractTypedTree && (typedNode = (AbstractTypedTree)tree).getSymbolType() == null) {
                    typedNode.setType(symbols.unknownType);
                }
                super.scan(tree);
            }
        });
    }

    @VisibleForTesting
    SemanticModel() {
    }

    private void createParentLink(JavaTree tree) {
        if (!tree.isLeaf()) {
            Iterator<Tree> iter = tree.childrenIterator();
            while (iter.hasNext()) {
                Tree next = iter.next();
                if (next == null) continue;
                this.parentLink.put(next, tree);
                this.createParentLink((JavaTree)next);
            }
        }
    }

    public void saveEnv(Symbol symbol, Resolve.Env env) {
        this.symbolEnvs.put(symbol, env);
    }

    public Resolve.Env getEnv(Symbol symbol) {
        return this.symbolEnvs.get(symbol);
    }

    public void associateEnv(Tree tree, Resolve.Env env) {
        this.envs.put((Object)tree, (Object)env);
    }

    public Tree getTree(Resolve.Env env) {
        return (Tree)this.envs.inverse().get((Object)env);
    }

    public Resolve.Env getEnv(Tree tree) {
        JavaTree javaTree = (JavaTree)tree;
        Resolve.Env result = null;
        while (result == null && javaTree != null) {
            result = (Resolve.Env)this.envs.get((Object)javaTree);
            javaTree = (JavaTree)this.parentLink.get(javaTree);
        }
        return result;
    }

    public Symbol getEnclosingClass(Tree tree) {
        return this.getEnv((Tree)tree).enclosingClass;
    }

    public void associateSymbol(Tree tree, Symbol symbol) {
        Preconditions.checkNotNull((Object)symbol);
        this.symbolsTree.put((Object)tree, (Object)symbol);
    }

    public Symbol getSymbol(Tree tree) {
        return (Symbol)this.symbolsTree.get((Object)tree);
    }

    public Tree getTree(Symbol symbol) {
        return (Tree)this.symbolsTree.inverse().get((Object)symbol);
    }

    public void associateReference(IdentifierTree tree, Symbol symbol) {
        this.usagesTree.put((Object)symbol, (Object)tree);
        this.refersTo.put(tree, symbol);
    }

    public Symbol getReference(IdentifierTree tree) {
        return this.refersTo.get(tree);
    }

    @VisibleForTesting
    Map<Tree, Symbol> getSymbolsTree() {
        return Collections.unmodifiableMap(this.symbolsTree);
    }

    public Collection<IdentifierTree> getUsages(Symbol symbol) {
        return Collections.unmodifiableCollection(this.usagesTree.get((Object)symbol));
    }

    @VisibleForTesting
    Collection<Symbol> getSymbolUsed() {
        return this.usagesTree.keySet();
    }
}

