/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.sonar.java.resolve.Symbol;

public class Type {
    public static final int BYTE = 1;
    public static final int CHAR = 2;
    public static final int SHORT = 3;
    public static final int INT = 4;
    public static final int LONG = 5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 7;
    public static final int BOOLEAN = 8;
    public static final int VOID = 9;
    public static final int CLASS = 10;
    public static final int ARRAY = 11;
    public static final int METHOD = 12;
    public static final int BOT = 13;
    public static final int UNKNOWN = 14;
    public static final int TYPEVAR = 15;
    int tag;
    Type primitiveType = null;
    Type primitiveWrapperType = null;
    Symbol.TypeSymbol symbol;

    public Type(int tag, Symbol.TypeSymbol symbol) {
        this.tag = tag;
        this.symbol = symbol;
    }

    public boolean isTagged(int tag) {
        return tag == this.tag;
    }

    public boolean isNumerical() {
        return this.tag <= 7;
    }

    public Symbol.TypeSymbol getSymbol() {
        this.symbol.complete();
        return this.symbol;
    }

    public boolean is(String fullyQualifiedName) {
        if (this.isTagged(10)) {
            return fullyQualifiedName.equals(this.symbol.getFullyQualifiedName());
        }
        if (this.tag < 10) {
            return fullyQualifiedName.equals(this.symbol.name);
        }
        if (this.isTagged(11)) {
            return fullyQualifiedName.endsWith("[]") && ((ArrayType)this).elementType.is(fullyQualifiedName.substring(0, fullyQualifiedName.length() - 2));
        }
        if (this.isTagged(15)) {
            return false;
        }
        return this.isTagged(13) || !this.isTagged(14);
    }

    public boolean isSubtypeOf(String fullyQualifiedName) {
        if (this.isTagged(10)) {
            if (this.is(fullyQualifiedName) || this.superTypeContains(fullyQualifiedName)) {
                return true;
            }
        } else {
            if (this.isTagged(11)) {
                return fullyQualifiedName.endsWith("[]") && ((ArrayType)this).elementType.isSubtypeOf(fullyQualifiedName.substring(0, fullyQualifiedName.length() - 2));
            }
            if (this.isTagged(15)) {
                return this.erasure().isSubtypeOf(fullyQualifiedName);
            }
        }
        return false;
    }

    private boolean superTypeContains(String fullyQualifiedName) {
        for (ClassType classType : this.symbol.superTypes()) {
            if (!classType.is(fullyQualifiedName)) continue;
            return true;
        }
        return false;
    }

    public boolean isParametrized() {
        this.symbol.complete();
        return this.symbol.isParametrized;
    }

    public Type erasure() {
        return this;
    }

    public boolean isPrimitive() {
        return this.tag <= 8;
    }

    public boolean isPrimitiveWrapper() {
        if (!this.isTagged(10)) {
            return false;
        }
        return this.is("java.lang.Byte") || this.is("java.lang.Character") || this.is("java.lang.Short") || this.is("java.lang.Integer") || this.is("java.lang.Long") || this.is("java.lang.Float") || this.is("java.lang.Double") || this.is("java.lang.Boolean");
    }

    public String toString() {
        return this.symbol == null ? "" : this.symbol.toString();
    }

    @Nullable
    public Type primitiveType() {
        return this.primitiveType;
    }

    @Nullable
    public Type primitiveWrapperType() {
        return this.primitiveWrapperType;
    }

    public static class ParametrizedTypeType
    extends ClassType {
        final Map<TypeVariableType, Type> typeSubstitution;
        final Type rawType;

        ParametrizedTypeType(Symbol.TypeSymbol symbol, Map<TypeVariableType, Type> typeSubstitution) {
            super(symbol);
            this.rawType = symbol.getType();
            this.typeSubstitution = typeSubstitution;
        }

        @Override
        public Type erasure() {
            return this.rawType.erasure();
        }

        @Nullable
        public Type substitution(TypeVariableType typeVariableType) {
            Type result = null;
            if (this.typeSubstitution != null) {
                result = this.typeSubstitution.get(typeVariableType);
            }
            return result;
        }

        public Set<TypeVariableType> typeParameters() {
            if (this.typeSubstitution != null) {
                return this.typeSubstitution.keySet();
            }
            return Sets.newHashSet();
        }
    }

    public static class TypeVariableType
    extends Type {
        List<Type> bounds;

        public TypeVariableType(Symbol.TypeVariableSymbol symbol) {
            super(15, symbol);
        }

        @Override
        public Type erasure() {
            return this.bounds.get(0);
        }
    }

    public static class MethodType
    extends Type {
        List<Type> argTypes;
        @Nullable
        Type resultType;
        List<Type> thrown;

        public MethodType(List<Type> argTypes, @Nullable Type resultType, List<Type> thrown, Symbol.TypeSymbol symbol) {
            super(12, symbol);
            this.argTypes = argTypes;
            this.resultType = resultType;
            this.thrown = thrown;
        }

        @Override
        public String toString() {
            return this.resultType == null ? "constructor" : "returns " + this.resultType.toString();
        }
    }

    public static class ArrayType
    extends Type {
        private final ArrayType erasure;
        Type elementType;

        public ArrayType(Type elementType, Symbol.TypeSymbol arrayClass) {
            super(11, arrayClass);
            this.elementType = elementType;
            this.erasure = new ArrayType(arrayClass);
        }

        private ArrayType(Symbol.TypeSymbol arrayClass) {
            super(11, arrayClass);
            this.erasure = this;
        }

        public int hashCode() {
            return new HashCodeBuilder(31, 37).append((Object)this.elementType).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ArrayType)) {
                return false;
            }
            ArrayType rhs = (ArrayType)obj;
            return new EqualsBuilder().append((Object)this.elementType, (Object)rhs.elementType).isEquals();
        }

        @Override
        public String toString() {
            return this.elementType.toString() + "[]";
        }

        public Type elementType() {
            return this.elementType;
        }

        @Override
        public Type erasure() {
            if (this.erasure.elementType == null) {
                this.erasure.elementType = this.elementType.erasure();
            }
            return this.erasure;
        }
    }

    public static class ClassType
    extends Type {
        Type supertype;
        List<Type> interfaces;

        public ClassType(Symbol.TypeSymbol symbol) {
            super(10, symbol);
        }
    }
}

