/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.parser;

import com.google.common.collect.ImmutableList;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.ast.parser.JavaLexer;
import org.sonar.java.ast.parser.ListTreeImpl;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeParameterTree;
import org.sonar.plugins.java.api.tree.TypeParameters;

public class TypeParameterListTreeImpl
extends ListTreeImpl<TypeParameterTree>
implements TypeParameters {
    @Nullable
    private final InternalSyntaxToken openBracketToken;
    @Nullable
    private final InternalSyntaxToken closeBracketToken;

    public TypeParameterListTreeImpl(InternalSyntaxToken openBracketToken, List<TypeParameterTree> typeParameters, List<AstNode> children, InternalSyntaxToken closeBracketToken) {
        super((AstNodeType)JavaLexer.TYPE_PARAMETERS, typeParameters, (List<AstNode>)ImmutableList.of());
        this.openBracketToken = openBracketToken;
        this.closeBracketToken = closeBracketToken;
        this.addChild(openBracketToken);
        for (AstNode child : children) {
            this.addChild(child);
        }
        this.addChild(closeBracketToken);
    }

    public TypeParameterListTreeImpl() {
        super((AstNodeType)JavaLexer.TYPE_PARAMETERS, ImmutableList.of(), (List<AstNode>)ImmutableList.of());
        this.openBracketToken = null;
        this.closeBracketToken = null;
    }

    @Override
    @Nullable
    public SyntaxToken openBracketToken() {
        return this.openBracketToken;
    }

    @Override
    @Nullable
    public SyntaxToken closeBracketToken() {
        return this.closeBracketToken;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitTypeParameters(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return ImmutableList.builder().addAll((Iterable)this).build().iterator();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.TYPE_PARAMETERS;
    }
}

