/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class AccessorVisitor
extends SubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.emptyList();
    }

    public boolean isAccessor(ClassTree classTree, MethodTree methodTree) {
        return this.isPublicMethod(methodTree) && methodTree.block() != null && (this.isGetter(classTree, methodTree) || this.isSetter(classTree, methodTree));
    }

    private boolean isPublicMethod(MethodTree methodTree) {
        return methodTree.is(Tree.Kind.METHOD) && methodTree.modifiers().modifiers().contains((Object)Modifier.PUBLIC);
    }

    private boolean isSetter(ClassTree classTree, MethodTree methodTree) {
        return methodTree.simpleName().name().startsWith("set") && methodTree.parameters().size() == 1 && this.returnTypeIs(methodTree, "void") && this.hasOneAssignementStatement(methodTree, classTree);
    }

    private boolean hasOneAssignementStatement(MethodTree methodTree, ClassTree classTree) {
        List<StatementTree> body = methodTree.block().body();
        return body.size() == 1 && body.get(0).is(Tree.Kind.EXPRESSION_STATEMENT) && ((ExpressionStatementTree)body.get(0)).expression().is(Tree.Kind.ASSIGNMENT) && this.referencePrivateProperty((AssignmentExpressionTree)((ExpressionStatementTree)body.get(0)).expression(), classTree);
    }

    private boolean referencePrivateProperty(AssignmentExpressionTree assignmentExpressionTree, ClassTree classTree) {
        return this.referencePrivateProperty(assignmentExpressionTree.variable(), classTree);
    }

    private boolean isGetter(ClassTree classTree, MethodTree methodTree) {
        return methodTree.parameters().isEmpty() && this.hasOneReturnStatement(methodTree, classTree) && (this.isValidGetter(methodTree) || this.isBooleanGetter(methodTree));
    }

    private boolean isBooleanGetter(MethodTree methodTree) {
        return methodTree.simpleName().name().startsWith("is") && this.returnTypeIs(methodTree, "boolean");
    }

    private boolean isValidGetter(MethodTree methodTree) {
        return methodTree.simpleName().name().startsWith("get");
    }

    private boolean hasOneReturnStatement(MethodTree methodTree, ClassTree classTree) {
        List<StatementTree> body = methodTree.block().body();
        return body.size() == 1 && body.get(0).is(Tree.Kind.RETURN_STATEMENT) && this.referencePrivateProperty((ReturnStatementTree)body.get(0), classTree);
    }

    private boolean referencePrivateProperty(ReturnStatementTree returnStatementTree, ClassTree classTree) {
        ExpressionTree expression = returnStatementTree.expression();
        String variableName = "";
        if (expression == null) {
            return false;
        }
        if (expression.is(Tree.Kind.IDENTIFIER)) {
            variableName = ((IdentifierTree)expression).name();
        }
        return !StringUtils.isEmpty((String)variableName) && this.referencePrivateProperty(variableName, classTree);
    }

    private boolean referencePrivateProperty(ExpressionTree expression, ClassTree classTree) {
        String variableReturned = "";
        if (expression.is(Tree.Kind.IDENTIFIER)) {
            variableReturned = ((IdentifierTree)expression).name();
        } else if (expression.is(Tree.Kind.MEMBER_SELECT)) {
            variableReturned = ((MemberSelectExpressionTree)expression).identifier().name();
        }
        return !StringUtils.isEmpty((String)variableReturned) && this.referencePrivateProperty(variableReturned, classTree);
    }

    private boolean referencePrivateProperty(String variableName, ClassTree classTree) {
        for (Tree member : classTree.members()) {
            VariableTree variableTree;
            if (!member.is(Tree.Kind.VARIABLE) || !(variableTree = (VariableTree)member).modifiers().modifiers().contains((Object)Modifier.PRIVATE) || !variableTree.simpleName().name().equals(variableName)) continue;
            return true;
        }
        return false;
    }

    private boolean returnTypeIs(MethodTree methodTree, String expectedReturnType) {
        TypeTree returnType = methodTree.returnType();
        return returnType != null && returnType.is(Tree.Kind.PRIMITIVE_TYPE) && expectedReturnType.equals(((PrimitiveTypeTree)returnType).keyword().text());
    }
}

