/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.sonar.api.source.Highlightable;
import org.sonar.java.SonarComponents;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.parser.JavaLexer;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.sslr.parser.LexerlessGrammar;

public class SyntaxHighlighterVisitor
extends SquidAstVisitor<LexerlessGrammar>
implements AstAndTokenVisitor {
    private final SonarComponents sonarComponents;
    private final Map<AstNodeType, String> types;
    private final Charset charset;
    private Highlightable.HighlightingBuilder highlighting;
    private List<Integer> lineStart;

    public SyntaxHighlighterVisitor(SonarComponents sonarComponents, Charset charset) {
        this.sonarComponents = sonarComponents;
        this.charset = charset;
        ImmutableMap.Builder typesBuilder = ImmutableMap.builder();
        for (JavaKeyword type : JavaKeyword.values()) {
            typesBuilder.put((Object)type, (Object)"k");
        }
        typesBuilder.put((Object)Tree.Kind.STRING_LITERAL, (Object)"s");
        typesBuilder.put((Object)Tree.Kind.CHAR_LITERAL, (Object)"s");
        typesBuilder.put((Object)Tree.Kind.FLOAT_LITERAL, (Object)"c");
        typesBuilder.put((Object)Tree.Kind.DOUBLE_LITERAL, (Object)"c");
        typesBuilder.put((Object)Tree.Kind.LONG_LITERAL, (Object)"c");
        typesBuilder.put((Object)Tree.Kind.INT_LITERAL, (Object)"c");
        typesBuilder.put((Object)Tree.Kind.ANNOTATION, (Object)"a");
        this.types = typesBuilder.build();
    }

    public void init() {
        for (AstNodeType type : this.types.keySet()) {
            this.subscribeTo(new AstNodeType[]{type});
        }
    }

    public void visitFile(AstNode astNode) {
        String content;
        if (astNode == null) {
            return;
        }
        this.highlighting = this.sonarComponents.highlightableFor(this.getContext().getFile()).newHighlighting();
        this.lineStart = Lists.newArrayList();
        try {
            content = Files.toString((File)this.getContext().getFile(), (Charset)this.charset);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.lineStart.add(0);
        for (int i = 0; i < content.length(); ++i) {
            if (content.charAt(i) != '\n' && (content.charAt(i) != '\r' || i + 1 >= content.length() || content.charAt(i + 1) == '\n')) continue;
            this.lineStart.add(i + 1);
        }
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{Tree.Kind.ANNOTATION})) {
            this.highlighting.highlight(astNode.getFromIndex(), ((AstNode)((AnnotationTree)astNode).annotationType()).getToIndex(), this.types.get(astNode.getType()));
        } else {
            AstNode target = astNode;
            if (astNode.hasChildren()) {
                for (AstNode child : astNode.getChildren()) {
                    if (child.is(new AstNodeType[]{JavaLexer.SPACING})) continue;
                    target = child;
                }
            }
            this.highlighting.highlight(target.getFromIndex(), target.getToIndex(), this.types.get(astNode.getType()));
        }
    }

    public void visitToken(Token token) {
        for (Trivia trivia : token.getTrivia()) {
            if (!trivia.isComment()) continue;
            Token triviaToken = trivia.getToken();
            int offset = this.getOffset(triviaToken.getLine(), triviaToken.getColumn());
            this.highlighting.highlight(offset, offset + triviaToken.getValue().length(), "cppd");
        }
    }

    private int getOffset(int line, int column) {
        return this.lineStart.get(line - 1) + column;
    }

    public void leaveFile(AstNode astNode) {
        if (astNode == null) {
            return;
        }
        this.highlighting.done();
    }
}

