/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.sonar.java.bytecode.BytecodeVisitorNotifier;
import org.sonar.java.bytecode.ClassLoaderBuilder;
import org.sonar.java.bytecode.VirtualMethodsLinker;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmClassProvider;
import org.sonar.java.bytecode.asm.AsmClassProviderImpl;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.loader.SquidClassLoader;
import org.sonar.java.bytecode.visitor.BytecodeVisitor;
import org.sonar.plugins.java.api.JavaResourceLocator;
import org.sonar.squidbridge.api.AnalysisException;
import org.sonar.squidbridge.api.CodeScanner;
import org.sonar.squidbridge.api.CodeVisitor;
import org.sonar.squidbridge.indexer.SquidIndex;

public class BytecodeScanner
extends CodeScanner<BytecodeVisitor> {
    private final SquidIndex indexer;
    private JavaResourceLocator javaResourceLocator;

    public BytecodeScanner(SquidIndex indexer, JavaResourceLocator javaResourceLocator) {
        this.indexer = indexer;
        this.javaResourceLocator = javaResourceLocator;
    }

    public BytecodeScanner scan(Collection<File> bytecodeFilesOrDirectories) {
        ClassLoader classLoader = ClassLoaderBuilder.create(bytecodeFilesOrDirectories);
        this.scanClasses(this.javaResourceLocator.classKeys(), new AsmClassProviderImpl(classLoader));
        ((SquidClassLoader)classLoader).close();
        return this;
    }

    protected BytecodeScanner scanClasses(Collection<String> classes, AsmClassProvider classProvider) {
        this.loadByteCodeInformation(classes, classProvider);
        this.linkVirtualMethods(classes, classProvider);
        this.notifyBytecodeVisitors(classes, classProvider);
        return this;
    }

    private void linkVirtualMethods(Collection<String> keys, AsmClassProvider classProvider) {
        VirtualMethodsLinker linker = new VirtualMethodsLinker();
        for (String key : keys) {
            AsmClass asmClass = classProvider.getClass(key, AsmClassProvider.DETAIL_LEVEL.STRUCTURE_AND_CALLS);
            for (AsmMethod method : asmClass.getMethods()) {
                linker.process(method);
            }
        }
    }

    private void notifyBytecodeVisitors(Collection<String> keys, AsmClassProvider classProvider) {
        BytecodeVisitor[] visitorArray = this.getVisitors().toArray(new BytecodeVisitor[this.getVisitors().size()]);
        for (String key : keys) {
            try {
                AsmClass asmClass = classProvider.getClass(key, AsmClassProvider.DETAIL_LEVEL.STRUCTURE_AND_CALLS);
                BytecodeVisitorNotifier visitorNotifier = new BytecodeVisitorNotifier(asmClass, visitorArray);
                visitorNotifier.notifyVisitors(this.indexer, this.javaResourceLocator);
            }
            catch (Exception exception) {
                throw new AnalysisException("Unable to analyze .class file " + key, (Throwable)exception);
            }
        }
    }

    private void loadByteCodeInformation(Collection<String> keys, AsmClassProvider classProvider) {
        for (String key : keys) {
            classProvider.getClass(key, AsmClassProvider.DETAIL_LEVEL.STRUCTURE_AND_CALLS);
        }
    }

    public Collection<Class<? extends BytecodeVisitor>> getVisitorClasses() {
        return Collections.emptyList();
    }

    public void accept(CodeVisitor visitor) {
        if (visitor instanceof BytecodeVisitor) {
            super.accept(visitor);
        }
    }
}

