/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.ast.parser.AstNodeReflector;
import org.sonar.java.ast.parser.TypeUnionListTreeImpl;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.declaration.AnnotationTreeImpl;
import org.sonar.java.model.expression.TypeArgumentListTreeImpl;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.UnionTypeTree;
import org.sonar.plugins.java.api.tree.WildcardTree;

public abstract class JavaTree
extends AstNode
implements Tree {
    private static final AstNodeType NULL_NODE = new AstNodeType(){

        public String toString() {
            return "[null]";
        }
    };
    private final AstNode astNode;

    public JavaTree(AstNodeType type) {
        super(type, type.toString(), null);
        this.astNode = this;
    }

    public JavaTree(AstNodeType type, Token token) {
        super(type, type.toString(), token);
        this.astNode = this;
    }

    public JavaTree(@Nullable AstNode astNode) {
        super(astNode == null ? NULL_NODE : astNode.getType(), astNode == null ? NULL_NODE.toString() : astNode.getType().toString(), astNode == null ? null : astNode.getToken());
        this.astNode = astNode;
    }

    public boolean isLegacy() {
        return this.astNode != this;
    }

    private void prependChild(AstNode astNode) {
        Preconditions.checkState((this.getAstNode() == this ? 1 : 0) != 0, (Object)"Legacy strongly typed node");
        List children = this.getChildren();
        if (children.isEmpty()) {
            this.addChild(astNode);
        } else {
            AstNodeReflector.setParent(astNode, this);
            children.add(0, astNode);
            for (int i = 0; i < children.size(); ++i) {
                AstNodeReflector.setChildIndex((AstNode)children.get(i), i);
            }
        }
    }

    public void prependChildren(AstNode ... astNodes) {
        for (int i = astNodes.length - 1; i >= 0; --i) {
            this.prependChild(astNodes[i]);
        }
    }

    public void prependChildren(List<? extends AstNode> astNodes) {
        this.prependChildren(astNodes.toArray(new AstNode[astNodes.size()]));
    }

    public void addChild(AstNode child) {
        Preconditions.checkState((!this.isLegacy() ? 1 : 0) != 0, (Object)"Children should not be added to legacy nodes");
        super.addChild(child);
    }

    public AstNode getAstNode() {
        return this.astNode;
    }

    public int getLine() {
        return this.astNode.getTokenLine();
    }

    @Override
    public final boolean is(Tree.Kind ... kind) {
        if (this.getKind() != null) {
            for (Tree.Kind kindIter : kind) {
                if (this.getKind() != kindIter) continue;
                return true;
            }
        }
        return false;
    }

    public abstract Tree.Kind getKind();

    public abstract Iterator<Tree> childrenIterator();

    public boolean isLeaf() {
        return false;
    }

    public static class ArrayTypeTreeImpl
    extends AbstractTypedTree
    implements ArrayTypeTree {
        private final TypeTree type;

        public ArrayTypeTreeImpl(TypeTree type, List<AstNode> children) {
            super(Tree.Kind.ARRAY_TYPE);
            this.type = (TypeTree)Preconditions.checkNotNull((Object)type);
            for (AstNode child : children) {
                this.addChild(child);
            }
        }

        public ArrayTypeTreeImpl(@Nullable AstNode astNode, TypeTree type) {
            super(astNode);
            this.type = (TypeTree)Preconditions.checkNotNull((Object)type);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.ARRAY_TYPE;
        }

        @Override
        public TypeTree type() {
            return this.type;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitArrayType(this);
        }

        @Override
        public Iterator<Tree> childrenIterator() {
            return Iterators.singletonIterator((Object)this.type);
        }
    }

    public static class ParameterizedTypeTreeImpl
    extends AbstractTypedTree
    implements ParameterizedTypeTree,
    ExpressionTree {
        private final TypeTree type;
        private final List<Tree> typeArguments;

        public ParameterizedTypeTreeImpl(TypeTree type, TypeArgumentListTreeImpl typeArguments) {
            super(Tree.Kind.PARAMETERIZED_TYPE);
            this.type = (TypeTree)Preconditions.checkNotNull((Object)type);
            this.typeArguments = (List)Preconditions.checkNotNull((Object)typeArguments);
            this.addChild((AstNode)type);
            this.addChild(typeArguments);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.PARAMETERIZED_TYPE;
        }

        @Override
        public TypeTree type() {
            return this.type;
        }

        @Override
        public List<Tree> typeArguments() {
            return this.typeArguments;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitParameterizedType(this);
        }

        @Override
        public Iterator<Tree> childrenIterator() {
            return Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.type), this.typeArguments.iterator());
        }
    }

    public static class PrimitiveTypeTreeImpl
    extends AbstractTypedTree
    implements PrimitiveTypeTree {
        private final InternalSyntaxToken token;

        public PrimitiveTypeTreeImpl(InternalSyntaxToken token, List<AstNode> children) {
            super(Tree.Kind.PRIMITIVE_TYPE);
            this.token = token;
            for (AstNode child : children) {
                this.addChild(child);
            }
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.PRIMITIVE_TYPE;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitPrimitiveType(this);
        }

        @Override
        public SyntaxToken keyword() {
            return this.token != null ? this.token : InternalSyntaxToken.createLegacy(PrimitiveTypeTreeImpl.getLastTokenAstNode(this.getAstNode()));
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public Iterator<Tree> childrenIterator() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        private static AstNode getLastTokenAstNode(AstNode astNode) {
            if (!astNode.hasToken()) {
                return null;
            }
            AstNode currentNode = astNode;
            block0: while (currentNode.hasChildren()) {
                for (int i = currentNode.getChildren().size() - 1; i >= 0; --i) {
                    AstNode child = (AstNode)currentNode.getChildren().get(i);
                    if (!child.hasToken()) continue;
                    currentNode = child;
                    continue block0;
                }
            }
            return currentNode;
        }
    }

    public static class NotImplementedTreeImpl
    extends AbstractTypedTree
    implements ExpressionTree {
        private final String name;

        public NotImplementedTreeImpl(AstNode ... children) {
            super(Tree.Kind.OTHER);
            this.name = "TODO";
            for (AstNode child : children) {
                this.addChild(child);
            }
        }

        public NotImplementedTreeImpl(AstNode astNode, String name) {
            super(astNode);
            this.name = name;
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.OTHER;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitOther(this);
        }

        public String getName() {
            return this.name;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public Iterator<Tree> childrenIterator() {
            throw new UnsupportedOperationException();
        }
    }

    public static class UnionTypeTreeImpl
    extends AbstractTypedTree
    implements UnionTypeTree {
        private final List<TypeTree> typeAlternatives;

        public UnionTypeTreeImpl(TypeUnionListTreeImpl typeAlternatives) {
            super(Tree.Kind.UNION_TYPE);
            this.typeAlternatives = (List)Preconditions.checkNotNull((Object)typeAlternatives);
            this.addChild(typeAlternatives);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.UNION_TYPE;
        }

        @Override
        public List<TypeTree> typeAlternatives() {
            return this.typeAlternatives;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitUnionType(this);
        }

        @Override
        public Iterator<Tree> childrenIterator() {
            return Iterators.concat((Iterator)Iterators.emptyIterator(), this.typeAlternatives.iterator());
        }
    }

    public static class WildcardTreeImpl
    extends JavaTree
    implements WildcardTree {
        private final Tree.Kind kind;
        @Nullable
        private final TypeTree bound;

        public WildcardTreeImpl(Tree.Kind kind, InternalSyntaxToken queryToken) {
            super(kind);
            Preconditions.checkArgument((kind == Tree.Kind.UNBOUNDED_WILDCARD ? 1 : 0) != 0);
            this.kind = (Tree.Kind)((Object)Preconditions.checkNotNull((Object)((Object)kind)));
            this.bound = null;
            this.addChild(queryToken);
        }

        public WildcardTreeImpl(Tree.Kind kind, InternalSyntaxToken extendsOrSuperToken, List<AnnotationTreeImpl> annotations, TypeTree bound) {
            super(kind);
            Preconditions.checkArgument((kind == Tree.Kind.EXTENDS_WILDCARD || kind == Tree.Kind.SUPER_WILDCARD ? 1 : 0) != 0);
            this.kind = (Tree.Kind)((Object)Preconditions.checkNotNull((Object)((Object)kind)));
            this.bound = bound;
            this.addChild(extendsOrSuperToken);
            for (AnnotationTreeImpl annotation : annotations) {
                this.addChild(annotation);
            }
            this.addChild((AstNode)bound);
        }

        public WildcardTreeImpl complete(InternalSyntaxToken queryToken) {
            Preconditions.checkState((this.kind == Tree.Kind.EXTENDS_WILDCARD || this.kind == Tree.Kind.SUPER_WILDCARD ? 1 : 0) != 0);
            this.prependChildren(queryToken);
            return this;
        }

        @Override
        public Tree.Kind getKind() {
            return this.kind;
        }

        @Override
        @Nullable
        public TypeTree bound() {
            return this.bound;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitWildcard(this);
        }

        @Override
        public Iterator<Tree> childrenIterator() {
            return Iterators.singletonIterator((Object)this.bound);
        }
    }

    public static class ImportTreeImpl
    extends JavaTree
    implements ImportTree {
        private final boolean isStatic;
        private final Tree qualifiedIdentifier;
        private final SyntaxToken semiColonToken;
        private final SyntaxToken importToken;
        private final SyntaxToken staticToken;

        public ImportTreeImpl(InternalSyntaxToken importToken, @Nullable InternalSyntaxToken staticToken, Tree qualifiedIdentifier, InternalSyntaxToken semiColonToken) {
            super(Tree.Kind.IMPORT);
            this.importToken = importToken;
            this.staticToken = staticToken;
            this.qualifiedIdentifier = qualifiedIdentifier;
            this.semiColonToken = semiColonToken;
            this.isStatic = staticToken != null;
            this.addChild(importToken);
            if (this.isStatic) {
                this.addChild(staticToken);
            }
            this.addChild((AstNode)qualifiedIdentifier);
            this.addChild(semiColonToken);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.IMPORT;
        }

        @Override
        public boolean isStatic() {
            return this.isStatic;
        }

        @Override
        public SyntaxToken importKeyword() {
            return this.importToken;
        }

        @Override
        @Nullable
        public SyntaxToken staticKeyword() {
            return this.staticToken;
        }

        @Override
        public Tree qualifiedIdentifier() {
            return this.qualifiedIdentifier;
        }

        @Override
        public SyntaxToken semicolonToken() {
            return this.semiColonToken;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitImport(this);
        }

        @Override
        public Iterator<Tree> childrenIterator() {
            return Iterators.singletonIterator((Object)this.qualifiedIdentifier);
        }
    }

    public static class CompilationUnitTreeImpl
    extends JavaTree
    implements CompilationUnitTree {
        @Nullable
        private final ExpressionTree packageName;
        private final List<ImportTree> imports;
        private final List<Tree> types;
        private final List<AnnotationTree> packageAnnotations;

        public CompilationUnitTreeImpl(@Nullable ExpressionTree packageName, List<ImportTree> imports, List<Tree> types, List<AnnotationTree> packageAnnotations, List<AstNode> children) {
            super(Tree.Kind.COMPILATION_UNIT);
            this.packageName = packageName;
            this.imports = (List)Preconditions.checkNotNull(imports);
            this.types = (List)Preconditions.checkNotNull(types);
            this.packageAnnotations = (List)Preconditions.checkNotNull(packageAnnotations);
            for (AstNode child : children) {
                this.addChild(child);
            }
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.COMPILATION_UNIT;
        }

        @Override
        public List<AnnotationTree> packageAnnotations() {
            return this.packageAnnotations;
        }

        @Override
        @Nullable
        public ExpressionTree packageName() {
            return this.packageName;
        }

        @Override
        public List<ImportTree> imports() {
            return this.imports;
        }

        @Override
        public List<Tree> types() {
            return this.types;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitCompilationUnit(this);
        }

        @Override
        public Iterator<Tree> childrenIterator() {
            return Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.packageName), this.imports.iterator(), this.types.iterator(), this.packageAnnotations.iterator());
        }

        public String packageNameAsString() {
            if (this.packageName == null) {
                return "";
            }
            LinkedList<String> pieces = new LinkedList<String>();
            ExpressionTree expr = this.packageName;
            while (expr.is(Tree.Kind.MEMBER_SELECT)) {
                MemberSelectExpressionTree mse = (MemberSelectExpressionTree)expr;
                pieces.push(mse.identifier().name());
                pieces.push(".");
                expr = mse.expression();
            }
            if (expr.is(Tree.Kind.IDENTIFIER)) {
                IdentifierTree idt = (IdentifierTree)expr;
                pieces.push(idt.name());
            }
            StringBuilder sb = new StringBuilder();
            for (String piece : pieces) {
                sb.append(piece);
            }
            return sb.toString();
        }
    }
}

