/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.surefire;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.CoverageExtension;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.Project;
import org.sonar.plugins.surefire.SurefireJavaParser;
import org.sonar.plugins.surefire.api.SurefireUtils;

@DependedUpon(value={"surefire-java"})
public class SurefireSensor
implements Sensor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SurefireSensor.class);
    private final SurefireJavaParser surefireJavaParser;
    private final Settings settings;
    private final FileSystem fs;

    public SurefireSensor(SurefireJavaParser surefireJavaParser, Settings settings, FileSystem fs) {
        this.surefireJavaParser = surefireJavaParser;
        this.settings = settings;
        this.fs = fs;
    }

    @DependsUpon
    public Class dependsUponCoverageSensors() {
        return CoverageExtension.class;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.fs.hasFiles(this.fs.predicates().hasLanguage("java"));
    }

    public void analyse(Project project, SensorContext context) {
        File dir = SurefireUtils.getReportsDirectory(this.settings, project);
        this.collect(context, dir);
    }

    protected void collect(SensorContext context, File reportsDir) {
        LOGGER.info("parsing {}", (Object)reportsDir);
        this.surefireJavaParser.collect(context, reportsDir);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

