/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.surefire.data;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.sonar.plugins.surefire.data.UnitTestResult;

public final class UnitTestClassReport {
    private long errors = 0L;
    private long failures = 0L;
    private long skipped = 0L;
    private long tests = 0L;
    private long durationMilliseconds = 0L;
    private long negativeTimeTestNumber = 0L;
    private List<UnitTestResult> results = null;

    public UnitTestClassReport add(UnitTestClassReport other) {
        for (UnitTestResult otherResult : other.getResults()) {
            this.add(otherResult);
        }
        return this;
    }

    public UnitTestClassReport add(UnitTestResult result) {
        this.initResults();
        this.results.add(result);
        if (result.getStatus().equals("skipped")) {
            ++this.skipped;
        } else if (result.getStatus().equals("failure")) {
            ++this.failures;
        } else if (result.getStatus().equals("error")) {
            ++this.errors;
        }
        ++this.tests;
        if (result.getDurationMilliseconds() < 0L) {
            ++this.negativeTimeTestNumber;
        } else {
            this.durationMilliseconds += result.getDurationMilliseconds();
        }
        return this;
    }

    private void initResults() {
        if (this.results == null) {
            this.results = Lists.newArrayList();
        }
    }

    public long getErrors() {
        return this.errors;
    }

    public long getFailures() {
        return this.failures;
    }

    public long getSkipped() {
        return this.skipped;
    }

    public long getTests() {
        return this.tests;
    }

    public long getDurationMilliseconds() {
        return this.durationMilliseconds;
    }

    public long getNegativeTimeTestNumber() {
        return this.negativeTimeTestNumber;
    }

    public List<UnitTestResult> getResults() {
        if (this.results == null) {
            return Collections.emptyList();
        }
        return this.results;
    }
}

