/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java.bridges;

import org.sonar.api.design.Dependency;
import org.sonar.api.resources.Resource;
import org.sonar.graph.Dsm;
import org.sonar.graph.DsmCell;
import org.sonar.plugins.java.bridges.DependencyIndex;
import org.sonar.plugins.java.bridges.ResourceIndex;
import org.sonar.squidbridge.api.SourceCode;

public final class DsmSerializer {
    private Dsm dsm;
    private StringBuilder json;
    private DependencyIndex dependencyIndex;
    private ResourceIndex resourceIndex;

    private DsmSerializer(Dsm<SourceCode> dsm, DependencyIndex dependencyIndex, ResourceIndex resourceIndex) {
        this.dsm = dsm;
        this.json = new StringBuilder();
        this.dependencyIndex = dependencyIndex;
        this.resourceIndex = resourceIndex;
    }

    private String serialize() {
        this.json.append('[');
        this.serializeRows();
        this.json.append(']');
        return this.json.toString();
    }

    private void serializeRows() {
        for (int y = 0; y < this.dsm.getDimension(); ++y) {
            if (y > 0) {
                this.json.append(',');
            }
            this.serializeRow(y);
        }
    }

    private void serializeRow(int y) {
        SourceCode squidResource = (SourceCode)this.dsm.getVertex(y);
        Resource sonarResource = (Resource)this.resourceIndex.get(squidResource);
        this.json.append("{");
        if (sonarResource != null) {
            this.json.append("\"i\":");
            this.json.append(sonarResource.getId());
            this.json.append(",\"n\":\"");
            this.json.append(sonarResource.getName());
            this.json.append("\",\"q\":\"");
            this.json.append(sonarResource.getQualifier());
            this.json.append("\",\"v\":[");
            for (int x = 0; x < this.dsm.getDimension(); ++x) {
                if (x > 0) {
                    this.json.append(',');
                }
                this.serializeCell(y, x);
            }
            this.json.append("]");
        }
        this.json.append("}");
    }

    private void serializeCell(int y, int x) {
        DsmCell cell = this.dsm.getCell(x, y);
        this.json.append('{');
        if (cell.getEdge() != null && cell.getWeight() > 0) {
            this.json.append("\"i\":");
            this.json.append(((Dependency)this.dependencyIndex.get(cell.getEdge())).getId());
            this.json.append(",\"w\":");
            this.json.append(cell.getWeight());
        }
        this.json.append('}');
    }

    public static String serialize(Dsm<SourceCode> dsm, DependencyIndex dependencyIndex, ResourceIndex resourceIndex) {
        return new DsmSerializer(dsm, dependencyIndex, resourceIndex).serialize();
    }
}

