/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java.bridges;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.SonarException;
import org.sonar.java.JavaSquid;
import org.sonar.squidbridge.api.Query;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourceFile;
import org.sonar.squidbridge.api.SourcePackage;
import org.sonar.squidbridge.api.SourceProject;
import org.sonar.squidbridge.indexer.QueryByType;
import org.sonar.squidbridge.indexer.SquidIndex;

public final class ResourceIndex
extends HashMap<SourceCode, Resource> {
    private static final long serialVersionUID = -918346378374943773L;
    private static final Logger LOG = LoggerFactory.getLogger(ResourceIndex.class);
    private final boolean skipPackageDesignAnalysis;

    public ResourceIndex(boolean skipPackageDesignAnalysis) {
        this.skipPackageDesignAnalysis = skipPackageDesignAnalysis;
    }

    public ResourceIndex loadSquidResources(JavaSquid squid, SensorContext context, Project project) {
        this.loadSquidProject(squid.getIndex(), project);
        this.loadSquidFilesAndPackages(squid.getIndex(), context, project);
        return this;
    }

    private void loadSquidProject(SquidIndex squid, Project project) {
        this.put(squid.search(new Query[]{new QueryByType(SourceProject.class)}).iterator().next(), project);
    }

    private void loadSquidFilesAndPackages(SquidIndex squid, SensorContext context, Project project) {
        HashMap directoryReverseMap = Maps.newHashMap();
        Collection files = squid.search(new Query[]{new QueryByType(SourceFile.class)});
        for (SourceCode squidFile : files) {
            String filePath = squidFile.getName();
            File file = new File(filePath);
            org.sonar.api.resources.File sonarFile = org.sonar.api.resources.File.fromIOFile((File)file, (Project)project);
            this.put(squidFile, context.getResource((Resource)sonarFile));
            SourceCode squidPackage = squidFile.getParent(SourcePackage.class);
            if ("!error!".equals(squidPackage.getKey())) continue;
            Resource sonarDirectory = context.getResource(sonarFile.getParent());
            SourceCode previousDirectoryMapping = (SourceCode)directoryReverseMap.get(sonarDirectory);
            if (previousDirectoryMapping == null) {
                directoryReverseMap.put(sonarDirectory, squidPackage);
                this.put(squidPackage, sonarDirectory);
                continue;
            }
            if (previousDirectoryMapping.equals((Object)squidPackage)) continue;
            String message = "Directory contains files belonging to different packages";
            String warning = " - some metrics could be reported incorrectly: {}";
            if (this.skipPackageDesignAnalysis) {
                LOG.warn(message + warning, (Object)file.getParentFile());
                continue;
            }
            LOG.error(message + warning, (Object)file.getParentFile());
            throw new SonarException(message + " : " + file.getParentFile() + " Please fix your source code or use " + "sonar.skipPackageDesign" + "=true to continue the analysis.");
        }
    }
}

