/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java.bridges;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.Set;
import org.sonar.api.checks.CheckFactory;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.issue.Issuable;
import org.sonar.api.issue.Issue;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Directory;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.ActiveRule;
import org.sonar.java.checks.PackageInfoCheck;
import org.sonar.squidbridge.api.CheckMessage;
import org.sonar.squidbridge.api.SourceFile;

public class ChecksBridge {
    private final CheckFactory checkFactory;
    private final ResourcePerspectives resourcePerspectives;
    private final RulesProfile rulesProfile;
    private Set<Directory> dirsWithoutPackageInfo;

    public ChecksBridge(CheckFactory checkFactory, ResourcePerspectives resourcePerspectives, RulesProfile rulesProfile) {
        this.checkFactory = checkFactory;
        this.resourcePerspectives = resourcePerspectives;
        this.rulesProfile = rulesProfile;
    }

    public void reportIssues(SourceFile squidFile, Resource sonarFile) {
        if (squidFile.hasCheckMessages()) {
            Issuable issuable = (Issuable)this.resourcePerspectives.as(Issuable.class, sonarFile);
            Set messages = squidFile.getCheckMessages();
            for (CheckMessage checkMessage : messages) {
                RuleKey ruleKey;
                Object check = checkMessage.getCheck();
                if (check instanceof RuleKey) {
                    ruleKey = (RuleKey)check;
                } else {
                    ActiveRule rule = this.checkFactory.getActiveRule(checkMessage.getCheck());
                    if (rule == null) continue;
                    ruleKey = rule.getRule().ruleKey();
                }
                Issue issue = issuable.newIssueBuilder().ruleKey(ruleKey).line(checkMessage.getLine()).message(checkMessage.formatDefaultMessage()).build();
                issuable.addIssue(issue);
            }
            messages.clear();
        }
    }

    public void reportIssueForPackageInfo(Directory directory, Project project) {
        Issuable issuable;
        if (this.dirsWithoutPackageInfo == null) {
            this.initSetOfDirs(project);
        }
        if (this.dirsWithoutPackageInfo.contains(directory) && (issuable = (Issuable)this.resourcePerspectives.as(Issuable.class, (Resource)directory)) != null) {
            Issue issue = issuable.newIssueBuilder().ruleKey(RuleKey.of((String)"squid", (String)"S1228")).message("Add a 'package-info.java' file to document the '" + directory.getPath() + "' package").build();
            issuable.addIssue(issue);
        }
    }

    private void initSetOfDirs(Project project) {
        this.dirsWithoutPackageInfo = Sets.newHashSet();
        ActiveRule activeRule = this.rulesProfile.getActiveRule("squid", "S1228");
        if (activeRule != null) {
            Set dirs = ((PackageInfoCheck)this.checkFactory.getCheck(activeRule)).getDirectoriesWithoutPackageFile();
            for (File dir : dirs) {
                this.dirsWithoutPackageInfo.add(Directory.fromIOFile((File)dir, (Project)project));
            }
        }
    }
}

