/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.plugins.java.api.JavaResourceLocator;
import org.sonar.squid.api.Query;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.indexer.QueryByType;
import org.sonar.squid.indexer.SquidIndex;

public class DefaultJavaResourceLocator
implements JavaResourceLocator {
    private static final Logger LOG = LoggerFactory.getLogger(JavaResourceLocator.class);
    private final Project project;
    private final ModuleFileSystem fileSystem;
    private SquidIndex squidIndex;

    public DefaultJavaResourceLocator(Project project, ModuleFileSystem fileSystem) {
        this.project = project;
        this.fileSystem = fileSystem;
    }

    public void setSquidIndex(SquidIndex squidIndex) {
        this.squidIndex = (SquidIndex)Preconditions.checkNotNull((Object)squidIndex);
    }

    private SquidIndex getSquidIndex() {
        Preconditions.checkState((this.squidIndex != null ? 1 : 0) != 0, (Object)"SquidIndex can't be null");
        return this.squidIndex;
    }

    public Resource findResourceByClassName(String className) {
        String name = className.replace('.', '/');
        SourceCode sourceCode = this.getSquidIndex().search(name);
        if (sourceCode == null) {
            LOG.debug("Class not found in SquidIndex: {}", (Object)className);
            return null;
        }
        Preconditions.checkState((boolean)(sourceCode instanceof SourceClass), (String)"Expected SourceClass, got %s for %s", (Object[])new Object[]{sourceCode.getClass().getSimpleName(), name});
        String filePath = ((SourceFile)sourceCode.getParent(SourceFile.class)).getName();
        return org.sonar.api.resources.File.fromIOFile((File)new File(filePath), (Project)this.project);
    }

    public Collection<File> classFilesToAnalyze() {
        ImmutableList.Builder result = ImmutableList.builder();
        Collection sourceClasses = this.getSquidIndex().search(new Query[]{new QueryByType(SourceClass.class)});
        block0: for (SourceCode sourceClass : sourceClasses) {
            String filePath = sourceClass.getKey() + ".class";
            for (File binaryDir : this.fileSystem.binaryDirs()) {
                File classFile = new File(binaryDir, filePath);
                if (!classFile.isFile()) continue;
                result.add((Object)classFile);
                continue block0;
            }
        }
        return result.build();
    }
}

